"use client";

import CookiesBar from "@/components/CookiesBar";
import { useState, useEffect } from "react";
import { getCookie } from "@/utils/cookies";

export default function CookiesWrapper() {
  const [acceptedCookies, setAcceptedCookies] = useState<boolean>(true);

  useEffect(() => {
    const cookie = getCookie("accepted-cookies");
    if (!cookie) {
      // eslint-disable-next-line react-hooks/set-state-in-effect
      setAcceptedCookies(false);
    }
  }, []);

  return (
    <>
      {!acceptedCookies && (
        <CookiesBar setAcceptedCookies={setAcceptedCookies} />
      )}
    </>
  );
}
