"use client";
import React from "react";
import { usePathname } from "next/navigation";
import LimitedOfferBar from "../components/LimitedOfferBar";
import Providers from "../providers/ThemeProvider";

const RootContainer: React.FC<React.PropsWithChildren> = ({ children }) => {
  const pathname = usePathname();
  const transferPaths = [
    "/files-transfer",
    "/esign",
    "/projects",
    "/hr",
    "/files",
    "/chat",
    "/campaigns",
    "/blogs",
    "/privacy-policy",
    "/about",
    "/affiliate-program",
    "/",
  ];

  const isTransferPage = transferPaths.includes(pathname || "");

  return (
    <Providers>
      <main className={isTransferPage ? "mt-0" : ""}>{children}</main>
      <LimitedOfferBar pageName={pathname || ""} />
    </Providers>
  );
};

export default RootContainer;
