import { Button, Typography } from "@mui/material";
import React from "react";
import Link from "next/link";
import Image from "next/image";
import KeyboardArrowDownOutlinedIcon from "@mui/icons-material/KeyboardArrowDownOutlined";
import { useRef } from "react";
export type SwiprrHomeFeatureProps = {
  illistrationUrl: string;
  name: string;
  description: string;
};

export const swiprrFeatures: SwiprrHomeFeatureProps[] = [
  {
    name: "Connecting with Like-minded Individuals",
    description:
      "Attain Your Dating Desires, No Apologies Needed. Casual Conversations? Absolutely Fine. Seeking Commitment? Wonderful. Your Choices are Always Yours.",
    illistrationUrl: "../../../public/images/group9.png",
  },
  {
    name: "Ready, Set, Connect",
    description:
      "Feel free to start chatting right away, without waiting for a match, Engage in conversations that delve deeper, skipping to the meaningful parts where you truly connect and understand each other.",
    illistrationUrl: "../../../public/images/Group10.png",
  },
  {
    name: "We Prioritize Your Safety",
    description:
      "We prioritize your safety above all else. Our platform uses enhanced system AI to ensure that all your conversations are well secured and confidential.",
    illistrationUrl: "../../../public/images/group12.png",
  },
  {
    name: "Mastering Our Craft",
    description:
      "Be rest assured, you're at the right place. We've united countless millions of people in times past.",
    illistrationUrl: "../../../public/images/group13.png",
  },
];

const SwiprrHomeFeature: React.FC<{
  swiprrFeatures: SwiprrHomeFeatureProps;
  left: boolean;
}> = ({ swiprrFeatures, left }) => {
  const containerRef = useRef<HTMLDivElement | null>(null);


  return (
    <div
      ref={containerRef}
      id={swiprrFeatures.name.replace(/\s+/g, "-").toLowerCase()}
    >
      <h6 className="lg:text-lg sm:text-xs font-[500] w-full px-10 pt-1 sm:m-0 text-center text-gray-800 dark:text-gray-300 sm:pt-2 lg:pt-28">
        See what you can do with {swiprrFeatures.name}
        <div
          className="flex items-center justify-center mt-1 animate-bounce"
          
        >
          <KeyboardArrowDownOutlinedIcon />
        </div>
      </h6>
      <div
        className={`w-full sm:mt-4 pt-[90px] flex flex-col sm:flex-row items-center justify-between gap-16 p-2 ${
          left ? "sm:flex-row" : "sm:flex-row-reverse"
        }`}
      >
        <Image
          src={swiprrFeatures.illistrationUrl}
          className="h-72 w-auto lg:h-[calc(110vh-300px)] sm:h-[calc(60vh-300px)] sm:w-auto ml-0 sm:ml-10"
          alt={`Illustration of ${swiprrFeatures.name}`}
          width={600}
          height={400}
        />
        <div className="max-w-[600px] w-[80%] flex-grow  m-3 sm:p-16 sm:m-8">
          <div className="flex items-center justify-center gap-4 sm:justify-start">
            <Typography
              className="hidden font-light text-center text-gray-800 sm:flex sm:text-left dark:text-gray-300"
              style={{ fontSize: "2.0rem" }}
            >
              {swiprrFeatures.name}
            </Typography>
            <Typography
              className="font-normal text-center text-gray-800 sm:hidden sm:text-left dark:text-gray-300 sm:mt-0"
              style={{ fontSize: "0.8rem" }}
            >
              {swiprrFeatures.name}
            </Typography>
          </div>

          <br className="hidden sm:block" />
          <Typography
            className="hidden font-light text-center text-gray-800 sm:flex sm:text-left dark:text-gray-300"
            style={{ fontSize: "1.0rem" }}
          >
            {swiprrFeatures.description}
          </Typography>

          <Typography
            className="font-normal text-center text-gray-800 sm:hidden sm:text-left dark:text-gray-300 sm:mt-0"
            style={{ fontSize: "0.6rem" }}
          >
            {swiprrFeatures.description}
          </Typography>

          <br className="hidden sm:block" />

          <div className="flex items-center justify-center gap-4 sm:justify-start sm:mb-0">
            <Button size="small" variant="contained">
              <Link  href="https://worksuite.clikkle.com/login?referralApp=Clikkle%20Website&&?redirectto=https://ads.clikkle.com&&referralApp=https://www.clikkle.com/ads">
                Get Started
              </Link>
            </Button>
            <Button size="small" variant="outlined">
              <Link  href="https://worksuite.clikkle.com/login?referralApp=Clikkle%20Website&&?redirectto=https://ads.clikkle.com&&referralApp=https://www.clikkle.com/ads">
                Learn More
              </Link>
            </Button>
          </div>
        </div>
      </div>
    </div>
  );
};

export default SwiprrHomeFeature;
