import { ArrowRightIcon } from "lucide-react";
import React from "react";
import Link from "next/link";
import Image from "next/image";
import { appssection } from "../constants/products";
import { Button } from "./button";
import { useTheme } from "../atoms/theme";
import { getEncodedReferrer } from "@/utils/utils";

function AppsSection() {
  const { theme } = useTheme();

  return (
    <section className="w-full md:py-20 p-6 py-20 bg-white dark:bg-[#1a1a1a]">
      <div className="container max-w-[1060px] mx-auto px-0">
        <div className="md:flex items-end justify-between mb-16">
          <div className="flex flex-col gap-6 max-w-[574px]">
            <h2 className="text-[32px] md:text-5xl font-semibold w-full font-inter font-medium leading-[48px]  ">
              <span className="text-gray-900 dark:text-white tracking-[-0.46px]">
                Discover the{" "}
              </span>
              <span className="text-[#286efb] dark:text-[#A9C5FF] tracking-[-0.46px]">
                perfect
              </span>
              <br className="hidden sm:block" />
              <span className="text-gray-900 dark:text-white tracking-[-0.46px]">
                {" "}
                app for you
              </span>
            </h2>
            <p className="text-[#51515E] dark:text-[#d7d7de] max-w-[508px] font-inter font-medium text-[15px] leading-[26px]  ">
              Explore our comprehensive suite of specialized tools designed to
              meet every aspect of your business needs.
            </p>
          </div>

          <Link
            href="/products"
            className="mt-8 md:mt-0 text-[#51515E] dark:text-[#d7d7de] font-medium text-sm rounded-2xl flex flex-row md:justify-center md:items-center min-w-20"
          >
            View all
            <ArrowRightIcon className="ml-2 h-4 w-4 text-[#51515E] dark:text-[#d7d7de]" />
          </Link>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 gap-x-10 gap-y-8">
          {appssection.map((app) => (
            <div key={app.id} className="flex items-start gap-6">
              <div className="flex justify-center items-center w-20 h-20 bg-gray-100 dark:bg-[#1a1a1a] rounded-3xl overflow-hidden border border-solid border-gray-300 dark:border-[#5e5e69]">
                <Image
                width={50}
                height={50}
                  className={`object-cover w-[1.7rem]`}
                  alt={`${app.title} icon`}
                  src={app.image}
                />
              </div>

              <div className="flex flex-col items-start justify-center gap-4 flex-1">
                <div className="flex flex-col items-start gap-2 w-full">
                  <h3 className="text-gray-900 dark:text-[#d7d7de] text-lg font-inter font-semibold text-[18px] leading-[20px] tracking-[0em]">
                    {app.title}
                  </h3>
                  <p className="text-[#51515E] dark:text-[#eeeef0] text-sm font-inter font-medium text-[14px] leading-[20px] tracking-[0em]">
                    {app.description}
                  </p>
                </div>

                <Button
                  variant="ghost"
                  onClick={() => {
                    window.location.replace(
                      app.to +
                        "/signup?theme=" +
                        theme +
                        "&referralApp=" +
                        getEncodedReferrer()
                    );
                  }}
                  className={`cursor-pointer hover:bg-[#286efb] hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0]  font-inter font-medium text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#F3F4F6] dark:border-[#ffffff33]`}
                >
                  Connect app
                  <ArrowRightIcon
                    className={`h-2 w-2 dark:text-white  ${
                      app.isActive ? "text-white" : ""
                    }`}
                  />
                </Button>
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
}

export default AppsSection;
