import React from "react";
import Link from "next/link";
import Image from "next/image";
import arrow3 from "../../public/images/right_arrow.png";

const apps = [
    {
    id: 0,
    title: "Worksuite",
    description: "Comprehensive suite for your business.",
    image: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
    imageWidth: "w-[35px]",
    imageHeight: "h-[41px]",
    route: "/worksuite",
    isActive: false,
  },
  {
    id: 1,
    title: "Chat",
    description: "Engage with customers",
    image: "https://cdn.clikkle.com/images/chat/logo/2025/clikkle%20chat.png",
    imageWidth: "w-[35px]",
    imageHeight: "h-[41px]",
    route: "/chat",
    isActive: false,
  },
  {
    id: 2,
    title: "Files",
    description: "Simple cloud storage",
    image: "https://cdn.clikkle.com/images/files/logo/2025/clikkle%20files.png",
    imageWidth: "w-[43px]",
    imageHeight: "h-[41px]",
    route: "/files",
    isActive: false,
  },
  {
    id: 3,
    title: "eSign",
    description: "Sign documents with ease",
    image:
      "https://cdn.clikkle.com/images/e-sign/logo/2025/clikkle%20esign.png",
    imageWidth: "w-10",
    imageHeight: "h-[40px]",
    route: "/esign",
    isActive: false,
  },
  {
    id: 4,
    title: "Hr",
    description: "Tailored for contemporary business.",
    image: "https://cdn.clikkle.com/images/hr/logo/2025/clikkle%20hr.png",
    imageWidth: "w-[41px]",
    imageHeight: "h-[40px]",
    route: "/hr",
    isActive: false,
  },
  {
    id: 5,
    title: "Projects",
    description: "Collaborate manage tasks",
    image:
      "https://cdn.clikkle.com/images/projects/logo/2025/clikkle%20projects.png",
    imageWidth: "w-10",
    imageHeight: "h-[40px]",
    route: "/projects",
    isActive: false,
  },
  {
    id: 6,
    title: "Campaigns",
    description: "Customer engagement.",
    image:
      "https://cdn.clikkle.com/images/campaigns/logo/2025/clikkle%20campaigns.png",
    imageWidth: "w-[55px]",
    imageHeight: "h-[41px]",
    imagePosition: "left-3 top-5",
    isActive: false,
    route: "/campaigns",
  },
  {
    id: 7,
    title: "CRM",
    description: "Customer relationship management.",
    image: "https://cdn.clikkle.com/images/crm/2025/clikkle%20crm.png",
    imageWidth: "w-[55px]",
    imageHeight: "h-[41px]",
    imagePosition: "left-3 top-5",
    isActive: false,
    route: "/crm",
  },
];

export default function AppsShowcase({ className = "" }) {
  return (
    <section className={`py-28 ${className} relative z-10 w-full`}>
      <div className="max-w-7xl mx-auto px-4 text-center w-full">
        <h3 className="text-2xl md:text-3xl font-extrabold mb-10 leading-tight">

          <span className="text-[#286efb] dark:text-[#A9C5FF] tracking-[-0.46px]">
            Clikkle Worksuite{" "}
          </span>
          <span className="text-gray-900 dark:text-white tracking-[-0.46px]">
            includes all apps you need for your business.
          </span>
        </h3>

        <div className="hidden md:block">
          <div className="grid grid-cols-8 justify-center items-end">
            {apps.map((app) => (
              <div key={app.id} className="flex flex-col items-center">
                <button
                  onClick={() => (window.location.href = app.route)}
                  className="bg-white shadow-xl dark:bg-[#1a1a1a] border border-solid border-gray-300 dark:border-[#ffffff3a] w-20 h-20 rounded-xl flex items-center justify-center hover:shadow-md transition-shadow duration-150"
                  aria-label={app.title}
                >
                  <Image
                    src={app.image}
                    alt={app.title}
                    className={`object-contain ${app.imageWidth || ""} ${
                      app.imageHeight || ""
                    }`}
                    loading="lazy"
                    width={50}
                    height={50}
                  />
                </button>
                <span className="mt-3 text-sm text-[#286efb] dark:text-[#A9C5FF] font-bold">
                  {app.title}
                </span>
              </div>
            ))}
          </div>

          <div className="mt-8 flex justify-center">
            <Link
              href="/products"
              className="text-gray-900 dark:text-white text-3xl flex items-center gap-3 font-black"
            >
              <span>And many more</span>
              <Image
                src={arrow3}
                alt="arrow"
                className="w-[65px]"
                width={50}
                height={50}
              />
            </Link>
          </div>
        </div>

        <div
          className="md:hidden block w-full overflow-x-auto scrollbar-hide"
          style={{
            scrollbarWidth: "none",
            msOverflowStyle: "none",
            WebkitOverflowScrolling: "touch",
          }}
        >
          <div className="gap-4 pb-2 px-4 flex w-[300px] overflow-x-auto scrollbar-hide mx-auto"      style={{
            scrollbarWidth: "none",
            msOverflowStyle: "none",
            WebkitOverflowScrolling: "touch",
          }}>
            {apps.map((app) => (
              <div key={app.id} className="w-24 text-center">
                <button
                  onClick={() => (window.location.href = app.route)}
                  className="bg-white dark:bg-[#1a1a1a] w-20 h-20 rounded-xl shadow-sm flex items-center justify-center mx-auto border border-solid border-gray-300 dark:border-[#5e5e69]"
                >
                  <Image
                    src={app.image}
                    alt={app.title}
                    className={`object-contain ${app.imageWidth || ""} ${
                      app.imageHeight || ""
                    }`}
                    loading="lazy"
                    width={50}
                    height={50}
                  />
                </button>
                <p className="mt-2 text-xs text-[#286efb] dark:text-[#A9C5FF] font-semibold">
                  {app.title}
                </p>
              </div>
            ))}
          </div>

          <div className="mt-6 flex justify-center">
            <Link
              href="/products"
              className="text-gray-900 dark:text-white text-xl flex items-center gap-2 font-bold"
            >
              <span>And many more</span>
              <Image
                src={arrow3}
                alt="arrow"
                className="w-[45px]"
                width={45}
                height={45}
              />
            </Link>
          </div>
        </div>

        <p className="text-center text-gray-600 dark:text-[#d7d7de] mb-8 mt-6">
          Each app is built to work seamlessly together — pick what you need and
          scale as you grow.
        </p>
      </div>
    </section>
  );
}
