"use client";

import Link from "next/link";
import { motion } from "framer-motion";
import { Button } from "@/components/button";
import { Home, FileQuestion } from "lucide-react";

export default function NotFound() {
  return (
    <main className="min-h-screen bg-white dark:bg-[#1a1a1a] text-gray-900 dark:text-white flex items-center justify-center relative overflow-hidden font-inter">
      <div className="absolute inset-0 overflow-hidden pointer-events-none">
        <motion.div
          animate={{
            rotate: [0, 360],
            scale: [1, 1.2, 1],
          }}
          transition={{
            duration: 20,
            repeat: Infinity,
            ease: "linear",
          }}
          className="absolute -top-1/4 -right-1/4 w-[800px] h-[800px] bg-[#286efb]/10 dark:bg-[#286efb]/5 rounded-full blur-[100px]"
        />
        <motion.div
          animate={{
            rotate: [360, 0],
            scale: [1, 1.5, 1],
          }}
          transition={{
            duration: 25,
            repeat: Infinity,
            ease: "linear",
          }}
          className="absolute -bottom-1/4 -left-1/4 w-[600px] h-[600px] bg-blue-400/10 dark:bg-blue-400/5 rounded-full blur-[80px]"
        />
      </div>

      <div className="container max-w-3xl px-6 relative z-10 text-center my-20">
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.6 }}
        >
          <h1 className="text-[120px] md:text-[200px] font-bold leading-none text-transparent bg-clip-text bg-gradient-to-b from-[#286efb] to-[#286efb]/40 select-none relative font-inter">
            404
            <motion.span
              className="absolute inset-0 text-[#286efb]/40 blur-sm"
              animate={{
                x: [-2, 2, -2],
                opacity: [0.5, 0.8, 0.5],
              }}
              transition={{
                duration: 0.2,
                repeat: Infinity,
                repeatType: "reverse",
              }}
            >
              404
            </motion.span>
          </h1>

          <h2 className="text-3xl md:text-4xl font-bold text-[#286efb] mb-6 font-inter">
            Page Lost
          </h2>

          <p className="text-lg text-gray-600 dark:text-gray-300 mb-10 max-w-lg mx-auto leading-relaxed font-inter">
            The page you&apos;re looking for seems to have drifted into the digital void.
            It might have been moved, deleted, or never existed.
          </p>

          <div className="flex flex-col sm:flex-row gap-4 justify-center items-center mb-16">
            <Link href="/">
              <Button size="lg" className="min-w-[200px] gap-2 bg-[#286efb] hover:bg-[#1a5ce5] text-white border-none cursor-pointer">
                <Home size={18} /> Return Home
              </Button>
            </Link>
            <Link href="/contact">
              <Button size="lg" variant="outline" className="cursor-pointer min-w-[200px] gap-2 border-gray-300 dark:border-gray-700 text-gray-900 dark:text-white hover:bg-gray-100 dark:hover:bg-[#141414]">
                <FileQuestion size={18} /> Report Issue
              </Button>
            </Link>
          </div>

          <div className="grid grid-cols-1 sm:grid-cols-3 gap-4 text-left border-t border-gray-200 dark:border-[#141414] pt-8">
            <Link href="/products" className="group p-4 rounded-xl bg-gray-50 dark:bg-[#141414] hover:bg-blue-50 dark:hover:bg-[#286efb]/10 transition-colors">
              <h3 className="font-bold text-gray-900 dark:text-white mb-1 group-hover:text-[#286efb] transition-colors font-inter">Our Products</h3>
              <p className="text-sm text-gray-600 dark:text-gray-400 font-inter">Explore our digital solutions.</p>
            </Link>
            <Link href="/blogs" className="group p-4 rounded-xl bg-gray-50 dark:bg-[#141414] hover:bg-blue-50 dark:hover:bg-[#286efb]/10 transition-colors">
              <h3 className="font-bold text-gray-900 dark:text-white mb-1 group-hover:text-[#286efb] transition-colors font-inter">Insights</h3>
              <p className="text-sm text-gray-600 dark:text-gray-400 font-inter">Read our latest articles.</p>
            </Link>
            <Link href="/contact" className="group p-4 rounded-xl bg-gray-50 dark:bg-[#141414] hover:bg-blue-50 dark:hover:bg-[#286efb]/10 transition-colors">
              <h3 className="font-bold text-gray-900 dark:text-white mb-1 group-hover:text-[#286efb] transition-colors font-inter">Get in Touch</h3>
              <p className="text-sm text-gray-600 dark:text-gray-400 font-inter">Start your next project.</p>
            </Link>
          </div>
        </motion.div>
      </div>
    </main>
  );
}
