"use client";
import { Cookie } from "lucide-react";
import React from "react";
import Link from "next/link";
import { setCookie } from "@/utils/cookies";

interface CookiesBarProps {
  setAcceptedCookies: React.Dispatch<React.SetStateAction<boolean>>;
}

const CookiesBar: React.FC<CookiesBarProps> = ({ setAcceptedCookies }) => {
  const handleAcceptedCookies = () => {
    setAcceptedCookies(true);
    setCookie("accepted-cookies", "true", 365 * 24);
  };

  return (
    <div
      className="
        fixed bottom-4 
        left-1/2 -translate-x-1/2   
        sm:left-4 sm:translate-x-0  
        w-[95%] sm:w-[475px] 
        rounded-md border border-solid border-[#F3F4F6] dark:border-[#ffffff33] shadow-md p-4 
        flex flex-col sm:flex-row items-start sm:items-center justify-between gap-2 
        bg-white dark:bg-[#1a1a1a] z-[1000]"
    >
      <div className="flex items-center gap-2">
        <span className="text-xl">
          <Cookie className="dark:text-[#A9C5FF] text-[#286efb]" />
        </span>
        <p className="text-sm text-black dark:text-gray-300">
          <span className="font-semibold">We use cookies</span> to personalise
          and enhance your experience. <br className="block" />
          <span className="flex gap-3">
            <Link
              className="underline text-black dark:text-gray-300"
              href="/privacy-policy"
            >
              Review our cookies policy
            </Link>
            <button
              onClick={handleAcceptedCookies}
              className="cursor-pointer text-sm font-semibold text-black dark:text-gray-300 hover:underline"
            >
              Accept
            </button>
          </span>
        </p>
      </div>
    </div>
  );
};

export default CookiesBar;
