"use client";
import Image from "next/image";
import Link from "next/link";
import { useTheme } from "../atoms/theme";

function ClikkleLogo() {
  const { theme } = useTheme();
  const isDarkMode = theme === "dark";

  return (
    <div className="flex items-center gap-0">
      <Link href="/">
        <div className="flex items-center justify-start md:w-[245px] w-auto gap-3">
          <Image
            alt="Clikkle Technologies logo"
            width={114}
            height={40}
            className="w-[90px] md:w-[114px]"
            src={
              isDarkMode
                ? "https://cdn.clikkle.com/images/worksuite/2025/Clikkle%20Worksuite%20Blue%20(%20White%20Text).png"
                : "https://cdn.clikkle.com/images/worksuite/2025/Clikkle%20Worksuite%20Blue%20(%20Black%20Text).png"
            }
          />
          <p className="text-gray-900 dark:text-white border-l-[1px] border-gray-300 dark:border-[ffffff3a] pl-[10px] text-[9px] md:text-[10px] font-[450] leading-3">
            The smarter <br /> way to work.
          </p>
        </div>
      </Link>
    </div>
  );
}

export default ClikkleLogo;
