"use client";
import React, { useEffect, useRef, useState } from "react";
import { ArrowRightIcon, Ellipsis, Logs } from "lucide-react";
import ThemeSwitch from "../components/themeSwitch";
import { Button } from "../components/button";
import { useTheme } from "../atoms/theme";
import dashboard from "../../public/images/dashboard.webp";
import bondsmiller from "../../public/images/bonsmiller.jpg";
import chat from "../../public/images/chat.png";
import esign from "../../public/images/esign.png";
import files from "../../public/images/files.png";
import projects from "../../public/images/projects.png";
import SidebarDrawer from "../components/sidebarDrawer";
import { FaArrowRight } from "react-icons/fa";
import { Box } from "@mui/material";
import hrimage from "../../public/images/hr.png";
import illustration from "../../public/images/banner.png";
import { apps } from "../constants/products";
import Link from "next/link";
import Image from "next/image";
import { footerColumns } from "../constants/footerText";
import AnnouncementBar from "../components/AnnouncementBar";
import { getCookie } from "../utils/cookies";
import ClikkleLogo from "@/components/ClikkleLogo";
import Footer from "@/components/Footer";
import QuesthireLogo from "../../public/images/QuesthireLogo.png";
import ChatBox from "../../public/images/chatboxLogo.png";
import Hirely from "../../public/images/hirelyLogo.png";
import Wurknest from "../../public/images/wurknestLogo.png";
import Taskly from "../../public/images/tasklyLogo.png";
import Appstir from "../../public/images/AppstirLogo.png";
import { getEncodedReferrer } from "@/utils/utils";

function PartnersPage() {
  const { theme } = useTheme();
  const [scrolled, setScrolled] = useState(false);
  useEffect(() => {
    const handleScroll = () => {
      setScrolled(window.scrollY > 0);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const [leftDrawerOpen, setLeftDrawerOpen] = useState(false);
  const toggleLeftDrawer = () => setLeftDrawerOpen((prev) => !prev);
  const [productsOpen, setProductsOpen] = useState(false);

  const companyLogos = [
    {
      name: "Questhire",
      imageUrl: QuesthireLogo,
      baseWidth: 148,
      baseHeight: 68,
    },
    {
      name: "Chatbox",
      imageUrl: ChatBox,
      baseWidth: 148,
      baseHeight: 68,
    },
    {
      name: "Hirely",
      imageUrl: Hirely,
      baseWidth: 148,
      baseHeight: 50,
      forceBlackInLightMode: true,
    },
    {
      name: "Wurknest",
      imageUrl: Wurknest,
      baseWidth: 148,
      baseHeight: 68,
      forceBlackInLightMode: true,
    },
    {
      name: "Taskly",
      imageUrl: Taskly,
      baseWidth: 148,
      baseHeight: 40,
    },
    {
      name: "Appstir",
      imageUrl: Appstir,
      baseWidth: 148,
      baseHeight: 54.55,
    },
  ];

  const [dotsOpen, setDotsOpen] = useState(false);
  const productsRef = useRef<HTMLDivElement>(null);
  const dotsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (dotsRef.current && !dotsRef.current.contains(event.target as Node)) {
        setDotsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);
  const [announcementOpen, setAnnouncementOpen] = useState(false);

  useEffect(() => {
    const checkHeight = () => {
      const el = document.querySelector("[data-announcement]") as HTMLElement;
      if (el && el.offsetHeight > 0) {
        setAnnouncementOpen(true);
      } else {
        setAnnouncementOpen(false);
      }
    };
    checkHeight();
    const observer = new MutationObserver(checkHeight);
    observer.observe(document.body, { childList: true, subtree: true });
    return () => observer.disconnect();
  }, []);

  useEffect(() => {
    const checkDismissedAnnouncements = () => {
      const dismissed = getCookie("dismissedAnnouncements");
      if (dismissed) {
        try {
          const dismissedIds = JSON.parse(dismissed);
          if (dismissedIds.length > 0) {
            setAnnouncementOpen(false);
          }
        } catch (error) {
          console.error("Error parsing dismissed announcements:", error);
        }
      }
    };

    checkDismissedAnnouncements();

    const interval = setInterval(checkDismissedAnnouncements, 1000);

    return () => clearInterval(interval);
  }, []);
  return (
    <div className="bg-white dark:bg-[#1a1a1a] ">
      <section className="w-full">
        <section className="relative w-full overflow-hidden">
          {" "}
          <div
            className={`fixed top-0 inset-x-0 z-50 ${
              scrolled
                ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1a1a]/90"
                : productsOpen || dotsOpen
                ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1a1a]/90"
                : ""
            }`}
          >
            <div
              ref={(el) => {
                if (el) {
                  const height = el.getBoundingClientRect().height;

                  if (height !== 0) {
                    setAnnouncementOpen(true);
                  }
                }
              }}
            >
              <AnnouncementBar onClose={() => setAnnouncementOpen(false)} />
            </div>
            <div className="container max-w-[1233px] mx-auto max-[1300px]:px-14 max-[1100px]:px-4">
              <nav
                className={`relative flex items-center justify-between py-4`}
              >
                <ClikkleLogo />

                <div className="flex md:hidden items-center">
                  <div
                    className="flex items-center gap-0 rounded-xl border border-gray-300 dark:border-[#ffffff3a] p-[8px] shadow-sm"
                    onClick={toggleLeftDrawer}
                  >
                    <p className="text-sm font-medium text-gray-900 dark:text-white">
                      <Logs className="w-5 h-5 text-gray-900 dark:text-white mr-3" />
                    </p>

                    <p className="flex items-center  rounded-xl text-sm font-bold ">
                      Menu
                    </p>
                  </div>
                </div>

                <div className="hidden md:flex items-center gap-12 font-inter font-medium text-[18px]">
                  <Link
                    href="https://clikkle.com#features"
                    className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                  >
                    Features
                  </Link>
                  <Link
                    href="#pricing"
                    className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                  >
                    Pricing
                  </Link>
                  <Link
                    href="/blogs"
                    className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                  >
                    Blog
                  </Link>
                  <div className="flex flex-row justify-center items-center">
                    <div className="relative" ref={productsRef}>
                      <button
                        onClick={() => setProductsOpen((o) => !o)}
                        className="cursor-pointer flex items-center gap-1 text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                      >
                        Products
                      </button>
                      {productsOpen && (
                        <div
                          className={`fixed ${
                            announcementOpen ? "top-[115px]" : "top-[75px]"
                          }  
              left-1/2 transform -translate-x-1/2 w-full bg-white/90 dark:bg-[#1a1a1a]/90 backdrop-blur-md 
              shadow-lg p-6 border-b-2 border-gray-300 dark:border-[#575662] z-50 flex justify-center items-center pb-0`}
                        >
                          <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                          <div className="flex flex-col gap-3">
                              {apps
                                .slice(0, Math.ceil(apps.length / 2))
                                .map((product) => (
                                  <Link
                                    key={product.id}
                                    href={product.route}
                                    className="flex items-center gap-4 p-[0.35rem] rounded-lg hover:bg-gray-100 dark:hover:bg-white/10 transition"
                                  >
                                    <div>
                                      <Image
                                        src={product.image}
                                        alt={product.title}
                                        className="w-[26px]"
                                        width={26}
                                        height={26}
                                      />
                                    </div>
                                    <div>
                                      <p className="font-bold text-gray-900 dark:text-white text-sm">
                                        {product.title}
                                      </p>
                                      <p className="text-xs text-gray-600 dark:text-gray-300">
                                        {product.description}
                                      </p>
                                    </div>
                                  </Link>
                                ))}
                            </div>

                            <div className="flex flex-col gap-3">
                              {apps
                                .slice(
                                  Math.ceil(apps.length / 2),
                                  Math.ceil(apps.length / 2) + 2,
                                )
                                .map((product) => (
                                  <Link
                                    key={product.id}
                                    href={product.route}
                                    className="flex items-center gap-4 p-[0.35rem] rounded-lg hover:bg-gray-100 dark:hover:bg-white/10 transition"
                                  >
                                    <div>
                                      <Image
                                        src={product.image}
                                        alt={product.title}
                                        className="w-[26px]"
                                        width={26}
                                        height={26}
                                      />
                                    </div>
                                    <div>
                                      <p className="font-bold text-gray-900 dark:text-white text-sm">
                                        {product.title}
                                      </p>
                                      <p className="text-xs text-gray-600 dark:text-gray-300">
                                        {product.description}
                                      </p>
                                    </div>
                                  </Link>
                                ))}
                              <Link href="/products">
                                <Button
                                  style={{ marginTop: "5px" }}
                                  variant="ghost"
                                  className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                >
                                  View all products
                                  <ArrowRightIcon className="h-2 w-2 dark:text-white" />
                                </Button>
                              </Link>
                            </div>
                            <div className="hidden lg:flex flex-row items-center justify-center text-center gap-3">
                              <Image
                                src={illustration}
                                alt="Illustration"
                                className="w-auto h-[175px]"
                                width={400}
                                height={175}
                              />
                              <div className="flex flex-col justify-center items-center h-full">
                                <p className="text-sm text-gray-700 dark:text-gray-300 max-w-[200px] pb-5">
                                  Get started today the modern solution to power
                                  your business.
                                </p>
                                <Button
                                  variant="ghost"
                                  onClick={() => {
                                    window.location.replace(
                                      `https://worksuite.clikkle.com/signup?theme=${theme}&referralApp=${getEncodedReferrer()}`
                                    );
                                  }}
                                  className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                >
                                  Get Started Today
                                  <ArrowRightIcon
                                    className={`h-2 w-2 dark:text-white`}
                                  />
                                </Button>
                              </div>
                            </div>
                          </div>
                        </div>
                      )}
                    </div>

                    <div className="relative" ref={dotsRef}>
                      <Ellipsis
                        onClick={() => setDotsOpen((o) => !o)}
                        className="w-8 h-6 rounded-full p-[1px] cursor-pointer"
                      />
                      {dotsOpen && (
                        <div
                          className={`fixed ${
                            announcementOpen ? "top-[115px]" : "top-[75px]"
                          }  left-1/2 transform -translate-x-1/2 w-full 
    bg-white/90 dark:bg-[#1a1a1a]/90 backdrop-blur-md 
    shadow-lg border-b-2 border-gray-300 dark:border-[#575662] 
    z-50 flex justify-center`}
                        >
                          <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 py-6">
                            <div className="flex flex-col md:flex-row justify-between items-start gap-12">
                              <div className="space-y-12">
                                <div className="max-w-[285px] space-y-2 mb-0">
                                  <h3 className="font-instrument-sans font-medium text-[18px] leading-[20px] text-gray-900 dark:text-[#eeeef0]">
                                    Get Started For Free
                                  </h3>
                                  <p className="font-body-medium text-[#51515E] dark:text-[#eeeef0]">
                                    Streamline your Business with our Apps.
                                    Effortlessly for every team.
                                  </p>
                                </div>
                                <Button
                                  style={{ marginTop: "20px" }}
                                  variant="ghost"
                                  onClick={() => {
                                    window.location.replace(
                                      `https://worksuite.clikkle.com/signup?theme=${theme}&referralApp=${getEncodedReferrer()}`
                                    );
                                  }}
                                  className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                >
                                  See How It Works
                                  <ArrowRightIcon
                                    className={`h-2 w-2 dark:text-white`}
                                  />
                                </Button>
                              </div>

                              <div className="flex flex-wrap gap-x-14 gap-y-8 text-xs sm:text-sm">
                                {footerColumns.map((column, index) => (
                                  <div
                                    key={index}
                                    className="flex flex-col gap-5"
                                  >
                                    <h4 className="font-label-medium text-gray-900 dark:text-white">
                                      {column.title}
                                    </h4>
                                    <ul className="flex flex-col gap-4">
                                      {column.links.map((link, linkIndex) => (
                                        <li key={linkIndex}>
                                          <div className="flex items-start gap-3">
                                            <Link
                                              href={link.url}
                                              target={
                                                link.url.startsWith("http")
                                                  ? "_blank"
                                                  : "_self"
                                              }
                                              rel={
                                                link.url.startsWith("http")
                                                  ? "noopener noreferrer"
                                                  : undefined
                                              }
                                              className="font-body-medium text-[#51515E] dark:text-[#d7d7de] hover:text-gray-900 dark:hover:text-white transition-colors whitespace-nowrap flex items-center gap-2"
                                            >
                                              {link.text}
                                              {column.title === "Social" && (
                                                <FaArrowRight className="w-2 h-2" />
                                              )}
                                            </Link>

                                            {link.isNew && (
                                              <div className="hidden md:flex items-center gap-2">
                                                <div className="w-4 h-4 flex items-center justify-center">
                                                  <div className="w-[13px] h-[13px] bg-[#c3e6ff] rounded-[6.67px] flex items-center justify-center">
                                                    <div className="w-1 h-1 bg-[#286efb] rounded-sm" />
                                                  </div>
                                                </div>
                                                <span className="font-body-medium text-gray-900 dark:text-white whitespace-nowrap">
                                                  New
                                                </span>
                                              </div>
                                            )}
                                          </div>
                                        </li>
                                      ))}
                                    </ul>
                                  </div>
                                ))}
                              </div>
                            </div>
                          </div>
                        </div>
                      )}
                    </div>
                  </div>
                </div>

                <div className="hidden md:flex items-center gap-4">
                  <div className="hidden md:flex items-center gap-4">
                    <div className="w-6">
                      <ThemeSwitch />
                    </div>
                    <div className="flex items-center gap-2 rounded-xl border border-gray-300 dark:border-[#ffffff3a] p-1 shadow-sm">
                      <button
                        className="cursor-pointer px-3 py-1 text-sm font-medium text-gray-900 dark:text-white"
                        onClick={() => {
                          window.location.replace(
                            `https://worksuite.clikkle.com/login?theme=${theme}&referralApp=${getEncodedReferrer()}`
                          );
                        }}
                      >
                        Login
                      </button>

                      <button
                        className="cursor-pointer flex items-center gap-1 rounded-xl bg-[#286efb] hover:bg-[#3367d6] px-4 py-1.5 text-sm font-medium text-white transition"
                        onClick={() => {
                          window.location.replace(
                            `https://worksuite.clikkle.com/signup?theme=${theme}&referralApp=${getEncodedReferrer()}`
                          );
                        }}
                      >
                        Try for free
                        <span>
                          <ArrowRightIcon className="w-4" />
                        </span>
                      </button>
                    </div>
                  </div>
                </div>
              </nav>
            </div>
          </div>
        </section>
      </section>

      <section
        className={`relative py-10 md:py-20 lg:px-8 overflow-hidden pt-16 md:pb-10 mt-[8rem] px-6 ${
          announcementOpen ? "pt-[14rem]" : ""
        }`}
      >
        <div
          className={`relative mx-auto max-w-2xl md:max-w-[85rem] border-0 md:border ${
            theme === "dark" ? "md:border-[#ffffff3a]" : "md:border-[#d2d5db]"
          }`}
        >
          <div className="">
            <div className="relative grid h-full">
              <div
                className="relative mx-auto max-w-2xl lg:max-w-[85rem] "
                style={{
                  opacity: 1,
                }}
              >
                <div className="group/item relative md:pb-12 md:!px-10 ">
                  <div
                    className="relative text-center"
                    style={{ transform: "none" }}
                  >
                    <div
                      className="z-10 inline-block group"
                      style={{ opacity: 1, transform: "none" }}
                    >
                      <div className="relative p-1 md:p-2 md:translate-y-[-25px]">
                        <div
                          className="absolute inset-0 rounded-full border bg-background"
                          style={{
                            border: `1px solid ${
                              theme == "dark" ? "#ffffff3a" : "#d2d5db"
                            } `,
                          }}
                        ></div>
                        <div className="inline-flex cursor-pointer items-center justify-center whitespace-nowrap font-medium transition-all ease-in-out duration-150 disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive bg-[#25272c] dark:bg-[#286efb] text-white shadow-sm h-8 gap-1.5 px-4 rounded-full backdrop-blur-sm pointer-events-none">
                          Partners
                        </div>
                      </div>
                    </div>
                    <div
                      className="space-y-6 mt-4 max-w-[760px] mx-auto"
                      style={{ opacity: 1 }}
                    >
                      <h1 className="font-medium  text-4xl xs:text-5xl lg:text-6xl leading-[1.2] -tracking-[2.4px]">
                        Become a{" "}
                        <span className="text-[#286efb] dark:text-[#A9C5FF]">
                          Clikkle Partner{" "}
                        </span>
                        !
                      </h1>
                      <p className="text-balance lg:text-xl text-secondary-foreground tracking-tight max-w-[672px] mx-auto">
                        We build powerful solutions for modern Organizations.
                        You have the audience, we have the tools. Let&apos;s
                        help more companies scale smarter.
                      </p>
                    </div>
                    <div
                      className="mx-auto mt-6 md:mt-10 md:mb-4 flex justify-center gap-x-3 gap-y-4 flex-row"
                      style={{ opacity: 1, transform: "none" }}
                    >
                      <div className="flex gap-4 w-full flex-col md:flex-row max-w-[560px]">
                        <div
                          data-slot="form-item"
                          className="grid gap-2 flex-1"
                        >
                          <div className="border border-gray-300 dark:border-[#575662] flex items-center bg-white rounded-md text-black focus-visible:outline-none disabled:cursor-not-allowed disabled:opacity-50">
                            <svg
                              xmlns="http://www.w3.org/2000/svg"
                              width="24"
                              height="24"
                              viewBox="0 0 24 24"
                              fill="none"
                              stroke="currentColor"
                              strokeWidth="2"
                              strokeLinecap="round"
                              strokeLinejoin="round"
                              className="lucide lucide-mail flex-shrink-0 mx-4 text-gray-400"
                            >
                              <rect
                                width="20"
                                height="16"
                                x="2"
                                y="4"
                                rx="2"
                              ></rect>
                              <path d="m22 7-8.97 5.7a1.94 1.94 0 0 1-2.06 0L2 7"></path>
                            </svg>
                            <input
                              className="file:border-0 file:bg-transparent file:text-sm file:font-medium placeholder:text-muted-foreground/60 focus-visible:outline-none disabled:cursor-not-allowed disabled:opacity-50 flex w-full rounded-md border border-input py-1 transition-colors text-base bg-white h-[48px] flex-1 border-none px-0 !ring-0 focus-visible:!ring-0 shadow-none focus-visible:ring-ring"
                              placeholder="Enter your email"
                              name="email_address"
                              value=""
                            />
                          </div>
                        </div>
                        <Link href="/affiliate-program/join">
                          <button
                            type="submit"
                            className="px-6 py-[14px] bg-[#25272c] dark:bg-[#286efb]  text-white font-medium rounded-lg transition w-full sm:w-auto"
                          >
                            Join Partner Program
                          </button>
                        </Link>
                      </div>
                    </div>
                    <div
                      className="mx-auto mt-6 md:mt-10 md:mb-4 flex justify-center gap-x-3 gap-y-4 flex-row"
                      style={{ opacity: 1, transform: "none" }}
                    >
                      <div className="flex flex-col text-center gap-x-10 gap-y-8 xl:text-lg md:flex-row md:text-left">
                        <div>
                          <p>
                            <strong className="xl:text-xl text-[#286efb] dark:text-[#A9C5FF]">
                              5,1000+
                            </strong>
                          </p>
                          <p>companies powered by our tools</p>
                        </div>
                        <div>
                          <p>
                            <strong className="xl:text-xl text-[#286efb] dark:text-[#A9C5FF]">
                              45K+
                            </strong>
                          </p>
                          <p>active advocates and partners</p>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <div className="text-(--border-muted) hidden md:block">
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  width="24"
                  height="24"
                  viewBox="0 0 24 24"
                  fill="none"
                  stroke="currentColor"
                  strokeWidth="2"
                  strokeLinecap="round"
                  strokeLinejoin="round"
                  className="lucide lucide-plus absolute p-1 z-1 -top-3 -right-3"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path d="M5 12h14"></path>
                  <path d="M12 5v14"></path>
                </svg>
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  width="24"
                  height="24"
                  viewBox="0 0 24 24"
                  fill="none"
                  stroke="currentColor"
                  strokeWidth="2"
                  strokeLinecap="round"
                  strokeLinejoin="round"
                  className="lucide lucide-plus absolute p-1 z-1 -top-3 -left-3"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path d="M5 12h14"></path>
                  <path d="M12 5v14"></path>
                </svg>
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  width="24"
                  height="24"
                  viewBox="0 0 24 24"
                  fill="none"
                  stroke="currentColor"
                  strokeWidth="2"
                  strokeLinecap="round"
                  strokeLinejoin="round"
                  className="lucide lucide-plus absolute p-1 z-1 -bottom-3 -left-3"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path d="M5 12h14"></path>
                  <path d="M12 5v14"></path>
                </svg>
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  width="24"
                  height="24"
                  viewBox="0 0 24 24"
                  fill="none"
                  stroke="currentColor"
                  strokeWidth="2"
                  strokeLinecap="round"
                  strokeLinejoin="round"
                  className="lucide lucide-plus absolute p-1 z-1 -bottom-3 -right-3"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path d="M5 12h14"></path>
                  <path d="M12 5v14"></path>
                </svg>
              </div>

              <div className="text-border">
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -top-[80px] -left-[1px] "
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -top-[40px] -left-[40px] rotate-90"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -top-[80px] -right-[1px] "
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -top-[40px] -right-[40px] rotate-90"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -bottom-[80px] -left-[1px] "
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                  aria-hidden="true"
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -bottom-[40px] -left-[40px] rotate-90"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -bottom-[80px] -right-[1px] "
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -bottom-[40px] -right-[40px] rotate-90"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
              </div>
            </div>
          </div>
        </div>
      </section>

      <section className="container my-10 md:my-20 mx-auto">
        <h2 className="font-medium  text-2xl xs:text-3xl lg:text-5xl leading-[1.2] -tracking-[0.8px] text-center px-6">
          How the{" "}
          <span className="text-[#286efb] dark:text-[#A9C5FF]">
            Clikkle affiliate program{" "}
          </span>{" "}
          works
        </h2>
        <div className="pt-10 flex flex-col lg:flex-row">
          <div className="text-center flex flex-col items-center py-6 flex-1 ">
            <svg
              xmlns="http://www.w3.org/2000/svg"
              width="44"
              height="44"
              viewBox="0 0 24 24"
              fill="none"
              stroke="currentColor"
              stroke-width="2"
              stroke-linecap="round"
              stroke-linejoin="round"
              className="lucide lucide-shopping-cart bg-gray-100 dark:bg-[#141414] rounded-2xl p-2"
            >
              <circle cx="8" cy="21" r="1"></circle>
              <circle cx="19" cy="21" r="1"></circle>
              <path d="M2.05 2.05h2l2.66 12.42a2 2 0 0 0 2 1.58h9.78a2 2 0 0 0 1.95-1.57l1.65-7.43H5.12"></path>
            </svg>
            <div className="text-base xs:text-lg lg:text-xl mb-2 mt-4 md:my-4 font-bold text-[#286efb] dark:text-[#A9C5FF]">
              Pick a product to share
            </div>
            <p className="text-sm lg:text-base text-secondary-foreground w-[260px] ">
              Choose from our high-converting suite: Helply&apos;s AI agent
              handles 70% of tier 1 support tickets 24/7, InstantDocs AI
              recorder turns screen recordings into polished help docs, and
              Groove is an AI-powered shared inbox built for lean Organizations.
            </p>
          </div>
          <div className="text-center flex flex-col items-center py-6 flex-1">
            <svg
              xmlns="http://www.w3.org/2000/svg"
              width="44"
              height="44"
              viewBox="0 0 24 24"
              fill="none"
              stroke="currentColor"
              stroke-width="2"
              stroke-linecap="round"
              stroke-linejoin="round"
              className="lucide lucide-link  bg-gray-100 dark:bg-[#141414] rounded-2xl p-2"
            >
              <path d="M10 13a5 5 0 0 0 7.54.54l3-3a5 5 0 0 0-7.07-7.07l-1.72 1.71"></path>
              <path d="M14 11a5 5 0 0 0-7.54-.54l-3 3a5 5 0 0 0 7.07 7.07l1.71-1.71"></path>
            </svg>
            <div className=" text-base xs:text-lg lg:text-xl mb-2 mt-4 md:my-4 font-bold text-[#286efb] dark:text-[#A9C5FF]">
              Share a unique link
            </div>
            <p className="text-sm lg:text-base text-secondary-foreground w-[260px] ">
              Get your custom referral link for Helply, InstantDocs, or Groove.
              No complicated setup. Just copy, paste, and promote.
            </p>
          </div>
          <div className="text-center flex flex-col items-center py-6 flex-1">
            <svg
              xmlns="http://www.w3.org/2000/svg"
              width="44"
              height="44"
              viewBox="0 0 24 24"
              fill="none"
              stroke="currentColor"
              stroke-width="2"
              stroke-linecap="round"
              stroke-linejoin="round"
              className="lucide lucide-dollar-sign  bg-gray-100 dark:bg-[#141414] rounded-2xl p-2"
            >
              <line x1="12" x2="12" y1="2" y2="22"></line>
              <path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"></path>
            </svg>
            <div className="font-bold text-[#286efb] dark:text-[#A9C5FF]  text-base xs:text-lg lg:text-xl mb-2 mt-4 md:my-4">
              Earn up to 30% FOR LIFE
            </div>
            <p className="text-sm lg:text-base text-secondary-foreground w-[260px] ">
              You&apos;ll get paid monthly for every customer you send our way.
              As long as they stay, you keep earning.
            </p>
          </div>
          <div className="text-center flex flex-col items-center py-6 flex-1">
            <svg
              xmlns="http://www.w3.org/2000/svg"
              width="44"
              height="44"
              viewBox="0 0 24 24"
              fill="none"
              stroke="currentColor"
              stroke-width="2"
              stroke-linecap="round"
              stroke-linejoin="round"
              className="lucide lucide-rocket bg-gray-100 dark:bg-[#141414] rounded-2xl p-2"
            >
              <path d="M4.5 16.5c-1.5 1.26-2 5-2 5s3.74-.5 5-2c.71-.84.7-2.13-.09-2.91a2.18 2.18 0 0 0-2.91-.09z"></path>
              <path d="m12 15-3-3a22 22 0 0 1 2-3.95A12.88 12.88 0 0 1 22 2c0 2.72-.78 7.5-6 11a22.35 22.35 0 0 1-4 2z"></path>
              <path d="M9 12H4s.55-3.03 2-4c1.62-1.08 5 0 5 0"></path>
              <path d="M12 15v5s3.03-.55 4-2c1.08-1.62 0-5 0-5"></path>
            </svg>
            <div className="font-bold text-[#286efb] dark:text-[#A9C5FF]  text-base xs:text-lg lg:text-xl mb-2 mt-4 md:my-4">
              Support founders scaling smarter
            </div>
            <p className="text-sm lg:text-base text-secondary-foreground w-[260px] ">
              Our stack is built for lean, profitable SaaS teams. You&apos;ll be
              promoting tools that are easy to demo and even easier to love.
            </p>
          </div>
        </div>
      </section>

      <section className="relative py-10 px-4 md:py-20 lg:px-8 overflow-hidden mt-10 md:mt-20 bg-gray-100 dark:bg-[#141414] ">
        <div className="relative mx-auto max-w-2xl md:max-w-[85rem]">
          <div className="md:mx-10">
            <div
              className={`relative grid h-full border-0 md:border ${
                theme === "dark"
                  ? "md:border-[#ffffff3a]"
                  : "md:border-[#d2d5db]"
              }`}
            >
              <div className="mx-auto lg:max-w-[85rem] text-center">
                <span
                  data-slot="badge"
                  className="text-[#286efb] dark:text-[#A9C5FF] bg-gray-100 dark:bg-[#141414]  font-extrabold inline-flex items-center justify-center rounded-md w-fit whitespace-nowrap shrink-0 [&_svg:not([class*='size-'])]:size-4 [&>svg]:pointer-events-none transition-[color,box-shadow] overflow-hidden badge-5 h-8 px-3 py-1 text-base md:-translate-y-1/2 gap-0"
                >
                  $20,000+ paid out
                </span>
                <div className="flex flex-col gap-6 lg:flex-row items-center px-12 pb-12 pt-4">
                  <Image
                    alt="teams"
                    loading="lazy"
                    width="400"
                    height="400"
                    decoding="async"
                    data-nimg="1"
                    className="rounded-lg"
                    style={{ color: "transparent" }}
                    src={dashboard}
                  />
                  <div>
                    <div className="space-y-2 mt-6 md:mt-1.5 max-w-[600px] mx-auto gap-2 flex flex-col">
                      <h2 className="font-medium  text-2xl xs:text-3xl lg:text-5xl leading-[1.2] -tracking-[0.8px]">
                        <span className="text-[#286efb] dark:text-[#A9C5FF]">
                          Earn more{" "}
                        </span>{" "}
                        with a partner stack that sells
                      </h2>
                      <p className="text-balance text-base lg:text-xl text-secondary-foreground">
                        Turn our products into your growth engine. Many already
                        have.
                      </p>
                    </div>
                    <Link href="/affiliate-program/join">
                      <button
                        type="submit"
                        className="mt-6 px-6 py-[14px] bg-[#25272c] dark:bg-[#286efb]  text-white font-medium rounded-lg transition w-full sm:w-auto"
                      >
                        Join Partner Program
                      </button>
                    </Link>
                  </div>
                </div>
              </div>
              <div className="hidden md:block ">
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  width="24"
                  height="24"
                  viewBox="0 0 24 24"
                  fill="none"
                  stroke="currentColor"
                  strokeWidth="2"
                  strokeLinecap="round"
                  strokeLinejoin="round"
                  className="lucide lucide-plus absolute p-1 z-1 -top-3 -right-3"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path d="M5 12h14"></path>
                  <path d="M12 5v14"></path>
                </svg>
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  width="24"
                  height="24"
                  viewBox="0 0 24 24"
                  fill="none"
                  stroke="currentColor"
                  strokeWidth="2"
                  strokeLinecap="round"
                  strokeLinejoin="round"
                  className="lucide lucide-plus absolute p-1 z-1 -top-3 -left-3"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path d="M5 12h14"></path>
                  <path d="M12 5v14"></path>
                </svg>
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  width="24"
                  height="24"
                  viewBox="0 0 24 24"
                  fill="none"
                  stroke="currentColor"
                  strokeWidth="2"
                  strokeLinecap="round"
                  strokeLinejoin="round"
                  className="lucide lucide-plus absolute p-1 z-1 -bottom-3 -left-3"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path d="M5 12h14"></path>
                  <path d="M12 5v14"></path>
                </svg>
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  width="24"
                  height="24"
                  viewBox="0 0 24 24"
                  fill="none"
                  stroke="currentColor"
                  strokeWidth="2"
                  strokeLinecap="round"
                  strokeLinejoin="round"
                  className="lucide lucide-plus absolute p-1 z-1 -bottom-3 -right-3"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path d="M5 12h14"></path>
                  <path d="M12 5v14"></path>
                </svg>
              </div>
              <div className="text-border">
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -top-[80px] -left-[1px] "
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -top-[40px] -left-[40px] rotate-90"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -top-[80px] -right-[1px] "
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                  aria-hidden="true"
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -top-[40px] -right-[40px] rotate-90"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -bottom-[80px] -left-[1px] "
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                  aria-hidden="true"
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -bottom-[40px] -left-[40px] rotate-90"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -bottom-[80px] -right-[1px] "
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -bottom-[40px] -right-[40px] rotate-90"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
              </div>
            </div>
          </div>
        </div>
      </section>

      <section className="container lg:max-w-[1180px] space-y-10 md:space-y-20 my-10 md:my-20 mx-auto px-6">
        <div className="max-w-[600px] mx-auto">
          <h2 className="font-medium  text-2xl xs:text-3xl lg:text-5xl leading-[1.2] -tracking-[0.8px] text-center">
            Products built to reduce{" "}
            <span className="text-[#286efb] dark:text-[#A9C5FF]">
              {" "}
              Organizations stress
            </span>
          </h2>
          <p className="text-base md:text-xl text-secondary-foreground text-center mt-6">
            Simple on their own. Powerful together.
            <br className="hidden sm:block" />
            The only Worksuite stack that gets leaner as you scale.
          </p>
        </div>

        <div
          data-slot="card"
          className="text-card-foreground flex flex-col gap-6 rounded-3xl border-(--card-border) py-6 border-0 shadow-none !p-0 bg-transparent"
        >
          <div data-slot="card-content" className="px-0">
            <div className="flex flex-col gap-6 lg:flex-row lg:items-center [&>*]:lg:flex-1 md:gap-20">
              <div className="flex flex-col items-start lg:order-last">
                <div className="inline-flex items-center justify-center gap-x-1.5 rounded-lg px-2 py-1.5 bg-white">
                  <span className="font-extrabold text-black">Clikkle Hr</span>
                </div>
                <div className="space-y-2 mt-6">
                  <h2 className="font-medium  text-[20px] xs:text-2xl lg:text-[32px] leading-[1.2]">
                    Comprehensive HR management system for teams.
                  </h2>
                </div>
                <Link
                  target="_blank"
                  rel="noopener noreferrer"
                  data-slot="button"
                  className="bg-[#25272c] dark:bg-[#286efb] inline-flex cursor-pointer items-center justify-center whitespace-nowrap rounded-md font-medium transition-all ease-in-out duration-150 disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive  text-white  shadow-sm h-8 gap-1.5 px-4 mt-6"
                  href="/hr"
                >
                  Discover Clikkle Hr
                </Link>
              </div>
              <div>
                <Image
                  alt="Knowledge Bridge"
                  loading="lazy"
                  width="518"
                  height="324"
                  decoding="async"
                  data-nimg="1"
                  className="rounded-lg mx-auto"
                  style={{ color: "transparent" }}
                  src={hrimage}
                />
              </div>
            </div>
          </div>
        </div>

        <div
          data-slot="card"
          className="text-card-foreground flex flex-col gap-6 rounded-3xl border-(--card-border) py-6 border-0 shadow-none !p-0 bg-transparent"
        >
          <div data-slot="card-content" className="px-0">
            <div className="flex flex-col gap-6 lg:flex-row lg:items-center [&>*]:lg:flex-1 md:gap-20">
              <div className="flex flex-col items-start">
                <div className="inline-flex items-center justify-center gap-x-1.5 rounded-lg px-2 py-1.5 bg-white">
                  <span className="font-extrabold text-black">
                    Clikkle Files
                  </span>
                </div>
                <div className="space-y-2 mt-6">
                  <h2 className="font-medium  text-[20px] xs:text-2xl lg:text-[32px] leading-[1.2]">
                    Secure file storage and sharing platform.
                  </h2>
                </div>
                <Link
                  target="_blank"
                  rel="noopener noreferrer"
                  data-slot="button"
                  className="bg-[#25272c] dark:bg-[#286efb] inline-flex cursor-pointer items-center justify-center whitespace-nowrap rounded-md font-medium transition-all ease-in-out duration-150 disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive  text-white  shadow-sm h-8 gap-1.5 px-4 mt-6"
                  href="/files"
                >
                  Discover Clikkle Files
                </Link>
              </div>
              <div>
                <Image
                  alt="Step-by-step guides"
                  loading="lazy"
                  width="518"
                  height="324"
                  decoding="async"
                  data-nimg="1"
                  className="rounded-lg mx-auto"
                  style={{ color: "transparent" }}
                  src={files}
                />
              </div>
            </div>
          </div>
        </div>

        <div
          data-slot="card"
          className="text-card-foreground flex flex-col gap-6 rounded-3xl border-(--card-border) py-6 border-0 shadow-none !p-0 bg-transparent"
        >
          <div data-slot="card-content" className="px-0">
            <div className="flex flex-col gap-6 lg:flex-row lg:items-center [&>*]:lg:flex-1 md:gap-20">
              <div className="flex flex-col items-start lg:order-last">
                <div className="inline-flex items-center justify-center gap-x-1.5 rounded-lg px-2 py-1.5 bg-white">
                  <span className="font-extrabold text-black">
                    Clikkle eSign
                  </span>
                </div>
                <div className="space-y-2 mt-6">
                  <h2 className="font-medium  text-[20px] xs:text-2xl lg:text-[32px] leading-[1.2]">
                    Secure, Effortless e-Signatures Anywhere.
                  </h2>
                </div>
                <Link
                  target="_blank"
                  rel="noopener noreferrer"
                  data-slot="button"
                  className="bg-[#25272c] dark:bg-[#286efb] inline-flex cursor-pointer items-center justify-center whitespace-nowrap rounded-md font-medium transition-all ease-in-out duration-150 disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive  text-white  shadow-sm h-8 gap-1.5 px-4 mt-6"
                  href="/esign"
                >
                  Discover Clikkle eSign
                </Link>
              </div>
              <div>
                <Image
                  alt="Inbox"
                  loading="lazy"
                  width="518"
                  height="302"
                  decoding="async"
                  data-nimg="1"
                  className="rounded-lg mx-auto"
                  style={{ color: "transparent" }}
                  src={esign}
                />
              </div>
            </div>
          </div>
        </div>

        <div
          data-slot="card"
          className="text-card-foreground flex flex-col gap-6 rounded-3xl border-(--card-border) py-6 border-0 shadow-none !p-0 bg-transparent"
        >
          <div data-slot="card-content" className="px-0">
            <div className="flex flex-col gap-6 lg:flex-row lg:items-center [&>*]:lg:flex-1 md:gap-20">
              <div className="flex flex-col items-start">
                <div className="inline-flex items-center justify-center gap-x-1.5 rounded-lg px-2 py-1.5 bg-white">
                  <span className="font-extrabold text-black">
                    Clikkle Chat
                  </span>
                </div>
                <div className="space-y-2 mt-6">
                  <h2 className="font-medium  text-[20px] xs:text-2xl lg:text-[32px] leading-[1.2]">
                    Real-time team communication platform.
                  </h2>
                </div>
                <Link
                  target="_blank"
                  rel="noopener noreferrer"
                  data-slot="button"
                  className="bg-[#25272c] dark:bg-[#286efb] inline-flex cursor-pointer items-center justify-center whitespace-nowrap rounded-md font-medium transition-all ease-in-out duration-150 disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive  text-white  shadow-sm h-8 gap-1.5 px-4 mt-6"
                  href="/chat"
                >
                  Discover Clikkle Chat
                </Link>
              </div>
              <div>
                <Image
                  alt="Podcast"
                  loading="lazy"
                  width="518"
                  height="292"
                  decoding="async"
                  data-nimg="1"
                  className="rounded-lg mx-auto"
                  style={{ color: "transparent" }}
                  src={chat}
                />
              </div>
            </div>
          </div>
        </div>

        <div
          data-slot="card"
          className="text-card-foreground flex flex-col gap-6 rounded-3xl border-(--card-border) py-6 border-0 shadow-none !p-0 bg-transparent"
        >
          <div data-slot="card-content" className="px-0">
            <div className="flex flex-col gap-6 lg:flex-row lg:items-center [&>*]:lg:flex-1 md:gap-20">
              <div className="flex flex-col items-start lg:order-last">
                <div className="inline-flex items-center justify-center gap-x-1.5 rounded-lg px-2 py-1.5 bg-white">
                  <span className="font-extrabold text-black">
                    Clikkle Projects
                  </span>
                </div>
                <div className="space-y-2 mt-6">
                  <h2 className="font-medium  text-[20px] xs:text-2xl lg:text-[32px] leading-[1.2]">
                    Project management and collaboration tool.{" "}
                  </h2>
                </div>
                <Link
                  target="_blank"
                  rel="noopener noreferrer"
                  data-slot="button"
                  className="bg-[#25272c] dark:bg-[#286efb] inline-flex cursor-pointer items-center justify-center whitespace-nowrap rounded-md font-medium transition-all ease-in-out duration-150 disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive  text-white  shadow-sm h-8 gap-1.5 px-4 mt-6"
                  href="/projects"
                >
                  Discover Clikkle Projects
                </Link>
              </div>
              <div>
                <Image
                  alt="Inbox"
                  loading="lazy"
                  width="518"
                  height="302"
                  decoding="async"
                  data-nimg="1"
                  className="rounded-lg mx-auto"
                  style={{ color: "transparent" }}
                  src={projects}
                />
              </div>
            </div>
          </div>
        </div>
      </section>

      <section className="relative py-10 px-4 lg:px-8 overflow-hidden md:py-10">
        <div className="relative mx-auto max-w-2xl md:max-w-[85rem]">
          <div className="md:mx-10">
            <div
              className={`relative grid h-full border-0 md:border ${
                theme === "dark"
                  ? "md:border-[#ffffff3a]"
                  : "md:border-[#d2d5db]"
              }`}
            >
              <div className="md:my-10 text-center space-y-10 md:mx-4">
                <div>
                  <h2 className="font-medium  text-2xl xs:text-3xl lg:text-5xl leading-[1.2] -tracking-[0.8px] max-w-[600px] mx-auto">
                    Trusted by modern teams in over{" "}
                    <span className="text-[#286efb] dark:text-[#A9C5FF]">
                      80+ countries{" "}
                    </span>
                  </h2>
                </div>
                <div className="flex flex-wrap gap-y-8 gap-x-12 justify-center mx-auto max-w-[840px]">
                  {companyLogos.map((logo) => (
                    <div
                      key={logo.name}
                      className="flex items-center justify-center min-w-[128px] h-[56px]"
                    >
                      <Box
                        key={logo.name}
                        component="img"
                        src={
                          typeof logo.imageUrl === "string"
                            ? logo.imageUrl
                            : logo.imageUrl.src
                        }
                        alt={logo.name}
                        sx={{
                          width: "128px",
                          height: "28px",
                          objectFit: "contain",
                          filter:
                            theme === "dark"
                              ? "brightness(0) invert(1)"
                              : logo.forceBlackInLightMode
                              ? "brightness(0)"
                              : "none",
                          transition: "all 0.3s ease",
                          "&:hover": {
                            transform: "scale(1.1)",
                            animation: "none",
                          },
                        }}
                      />
                    </div>
                  ))}
                </div>
                <Link href="/affiliate-program/join">
                  <button
                    type="submit"
                    className="px-6 py-[14px] bg-[#25272c] dark:bg-[#286efb]  text-white font-medium rounded-lg transition w-full sm:w-auto"
                  >
                    Join Partner Program
                  </button>
                </Link>
              </div>
              <div className="text-(--border-muted) hidden md:block">
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  width="24"
                  height="24"
                  viewBox="0 0 24 24"
                  fill="none"
                  stroke="currentColor"
                  strokeWidth="2"
                  strokeLinecap="round"
                  strokeLinejoin="round"
                  className="lucide lucide-plus absolute p-1 z-1 -top-3 -right-3"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path d="M5 12h14"></path>
                  <path d="M12 5v14"></path>
                </svg>
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  width="24"
                  height="24"
                  viewBox="0 0 24 24"
                  fill="none"
                  stroke="currentColor"
                  strokeWidth="2"
                  strokeLinecap="round"
                  strokeLinejoin="round"
                  className="lucide lucide-plus absolute p-1 z-1 -top-3 -left-3"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path d="M5 12h14"></path>
                  <path d="M12 5v14"></path>
                </svg>
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  width="24"
                  height="24"
                  viewBox="0 0 24 24"
                  fill="none"
                  stroke="currentColor"
                  strokeWidth="2"
                  strokeLinecap="round"
                  strokeLinejoin="round"
                  className="lucide lucide-plus absolute p-1 z-1 -bottom-3 -left-3"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path d="M5 12h14"></path>
                  <path d="M12 5v14"></path>
                </svg>
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  width="24"
                  height="24"
                  viewBox="0 0 24 24"
                  fill="none"
                  stroke="currentColor"
                  strokeWidth="2"
                  strokeLinecap="round"
                  strokeLinejoin="round"
                  className="lucide lucide-plus absolute p-1 z-1 -bottom-3 -right-3"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path d="M5 12h14"></path>
                  <path d="M12 5v14"></path>
                </svg>
              </div>
              <div className="text-border">
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -top-[80px] -left-[1px]"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -top-[40px] -left-[40px] rotate-90"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -top-[80px] -right-[1px]"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -top-[40px] -right-[40px] rotate-90"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -bottom-[80px] -left-[1px]"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -bottom-[40px] -left-[40px] rotate-90"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -bottom-[80px] -right-[1px]"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
                <svg
                  width="1px"
                  height="80"
                  viewBox="0 0 1 120"
                  className="absolute hidden md:block -bottom-[40px] -right-[40px] rotate-90"
                  aria-hidden="true"
                  style={{
                    color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                  }}
                >
                  <path
                    d="M0.5 0V120"
                    stroke="currentColor"
                    strokeDasharray="5 5"
                  ></path>
                </svg>
              </div>
            </div>
          </div>
        </div>
      </section>

      <section className="container my-10 md:my-20 mx-auto">
        <div className="flex flex-col lg:flex-row gap-6">
          <div className="text-center flex flex-col items-center py-6 flex-1">
            <svg
              xmlns="http://www.w3.org/2000/svg"
              width="44"
              height="44"
              viewBox="0 0 24 24"
              fill="none"
              stroke="currentColor"
              strokeWidth="2"
              strokeLinecap="round"
              strokeLinejoin="round"
              className="lucide lucide-shield  bg-gray-100 dark:bg-[#141414] rounded-2xl p-2"
            >
              <path d="M20 13c0 5-3.5 7.5-7.66 8.95a1 1 0 0 1-.67-.01C7.5 20.5 4 18 4 13V6a1 1 0 0 1 1-1c2 0 4.5-1.2 6.24-2.72a1.17 1.17 0 0 1 1.52 0C14.51 3.81 17 5 19 5a1 1 0 0 1 1 1z"></path>
            </svg>
            <div className="font-bold text-[#286efb] dark:text-[#A9C5FF]  text-base xs:text-lg lg:text-xl mb-2 mt-4 md:my-4">
              Boost your brand authority
            </div>
            <p className="text-sm lg:text-base text-secondary-foreground w-[260px] ">
              Work with tools your clients will thank you for. Add credibility
              and trust by aligning with proven tech.
            </p>
          </div>

          <div className="text-center flex flex-col items-center py-6 flex-1">
            <svg
              xmlns="http://www.w3.org/2000/svg"
              width="44"
              height="44"
              viewBox="0 0 24 24"
              fill="none"
              stroke="currentColor"
              strokeWidth="2"
              strokeLinecap="round"
              strokeLinejoin="round"
              className="lucide lucide-chart-line  bg-gray-100 dark:bg-[#141414] rounded-2xl p-2"
            >
              <path d="M3 3v16a2 2 0 0 0 2 2h16"></path>
              <path d="m19 9-5 5-4-4-3 3"></path>
            </svg>
            <div className="font-bold text-[#286efb] dark:text-[#A9C5FF]  text-base xs:text-lg lg:text-xl mb-2 mt-4 md:my-4">
              Unlock new revenue lines
            </div>
            <p className="text-sm lg:text-base text-secondary-foreground w-[260px] ">
              Resell, consult, train, or build. Our stack opens the door to
              scalable services and products.
            </p>
          </div>

          <div className="text-center flex flex-col items-center py-6 flex-1">
            <svg
              xmlns="http://www.w3.org/2000/svg"
              width="44"
              height="44"
              viewBox="0 0 24 24"
              fill="none"
              stroke="currentColor"
              strokeWidth="2"
              strokeLinecap="round"
              strokeLinejoin="round"
              className="lucide lucide-users  bg-gray-100 dark:bg-[#141414] rounded-2xl p-2"
            >
              <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"></path>
              <circle cx="9" cy="7" r="4"></circle>
              <path d="M22 21v-2a4 4 0 0 0-3-3.87"></path>
              <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
            </svg>
            <div className="font-bold text-[#286efb] dark:text-[#A9C5FF]  text-base xs:text-lg lg:text-xl mb-2 mt-4 md:my-4">
              Expand your reach and exposure
            </div>
            <p className="text-sm lg:text-base text-secondary-foreground w-[260px] ">
              We promote top partners, showcase case studies, and co-market to a
              growing audience of SaaS and Organizations.
            </p>
          </div>
        </div>
      </section>

      <section className="my-10 md:my-20">
        <div className="relative py-10 px-4 lg:px-8 overflow-hidden md:py-10 text-base lg:text-xl text-secondary-foreground">
          <div className="relative mx-auto max-w-2xl md:max-w-[85rem]">
            <div className="md:mx-10">
              <div
                className={`relative grid h-full border-0 md:border ${
                  theme === "dark"
                    ? "md:border-[#ffffff3a]"
                    : "md:border-[#d2d5db]"
                }`}
              >
                <div
                  className={`border md:border-l ${
                    theme === "dark" ? "border-[#ffffff3a]" : "border-[#d2d5db]"
                  }`}
                >
                  <div className="grid grid-cols-1 lg:grid-cols-2 md:items-center">
                    <div
                      className={`space-y-8 p-8 xl:px-16 md:py-4 h-full flex flex-col justify-center lg:order-2 border-l md:border-l ${
                        theme === "dark"
                          ? "border-l-[#ffffff3a]"
                          : "border-l-[#d2d5db]"
                      }`}
                    >
                      <svg
                        xmlns="http://www.w3.org/2000/svg"
                        width="46"
                        height="26"
                        fill="none"
                        viewBox="0 0 46 26"
                        className="text-white"
                      >
                        <g clipPath="url(#a)">
                          <path
                            fill="currentColor"
                            d="M18.712.001c0 .601.047 1.105-.022 1.591-.03.207-.27.43-.469.554-.961.61-2.004 1.097-2.9 1.797-2.9 2.267-4.617 5.25-4.711 9.126-.026 1.1.379 1.376 1.302.946 2.668-1.237 5.538-.511 7.068 1.787 1.67 2.51 1.435 5.85-.566 8.041-2.555 2.797-6.76 2.882-9.66.208-1.737-1.601-2.562-3.668-2.768-6.02-.69-7.877 3.26-14.37 10.453-17.223.712-.282 1.44-.513 2.273-.807Z"
                          ></path>
                        </g>
                        <g clipPath="url(#b)">
                          <path
                            fill="currentColor"
                            d="M38.212.001c0 .601.047 1.105-.022 1.591-.03.207-.27.43-.469.554-.961.61-2.004 1.097-2.9 1.797-2.9 2.267-4.617 5.25-4.711 9.126-.026 1.1.379 1.376 1.302.946 2.668-1.237 5.538-.511 7.068 1.787 1.67 2.51 1.435 5.85-.566 8.041-2.555 2.797-6.76 2.882-9.66.208-1.737-1.601-2.562-3.668-2.768-6.02-.69-7.877 3.26-14.37 10.453-17.223.712-.282 1.44-.513 2.273-.807Z"
                          ></path>
                        </g>
                        <defs>
                          <clipPath id="a">
                            <path fill="#fff" d="M26 26H0V0h26z"></path>
                          </clipPath>
                          <clipPath id="b">
                            <path fill="#fff" d="M45.5 26h-26V0h26z"></path>
                          </clipPath>
                        </defs>
                      </svg>
                      <p>
                        I came in looking for affiliate commissions. I stayed
                        because of the co-marketing, the inbound leads, and the
                        support. Total game-changer. Easy to demo. Easy to
                        deploy. And they sell themselves. It&apos;s a no-brainer
                        if you work with SaaS.
                      </p>
                      <div className="text-base">
                        <div className="font-medium lg:text-lg">
                          Bonds miller
                        </div>
                        <p>Founder at HowWorks</p>
                      </div>
                    </div>
                    <div
                      className={`p-4 md:p-6 border-t border-[${
                        theme === "dark" ? "#ffffff3a" : "#d2d5db"
                      }] lg:border-t-0 h-full flex items-center justify-center`}
                    >
                      <Image
                        alt="Jake Thomas"
                        loading="lazy"
                        width="591"
                        height="394"
                        decoding="async"
                        data-nimg="1"
                        className="rounded-md"
                        style={{ color: "transparent" }}
                        src={bondsmiller}
                      />
                    </div>
                  </div>
                </div>
                <div className="text-(--border-muted) hidden md:block">
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="24"
                    height="24"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="currentColor"
                    strokeWidth="2"
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    className="lucide lucide-plus absolute p-1 z-1 -top-3 -right-3"
                    aria-hidden="true"
                    style={{
                      color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                    }}
                  >
                    <path d="M5 12h14"></path>
                    <path d="M12 5v14"></path>
                  </svg>
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="24"
                    height="24"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="currentColor"
                    strokeWidth="2"
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    className="lucide lucide-plus absolute p-1 z-1 -top-3 -left-3"
                    aria-hidden="true"
                    style={{
                      color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                    }}
                  >
                    <path d="M5 12h14"></path>
                    <path d="M12 5v14"></path>
                  </svg>
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="24"
                    height="24"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="currentColor"
                    strokeWidth="2"
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    className="lucide lucide-plus absolute p-1 z-1 -bottom-3 -left-3"
                    aria-hidden="true"
                    style={{
                      color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                    }}
                  >
                    <path d="M5 12h14"></path>
                    <path d="M12 5v14"></path>
                  </svg>
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="24"
                    height="24"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="currentColor"
                    strokeWidth="2"
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    className="lucide lucide-plus absolute p-1 z-1 -bottom-3 -right-3"
                    aria-hidden="true"
                    style={{
                      color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                    }}
                  >
                    <path d="M5 12h14"></path>
                    <path d="M12 5v14"></path>
                  </svg>
                </div>
                <div className="text-border">
                  <svg
                    width="1px"
                    height="80"
                    viewBox="0 0 1 120"
                    className="absolute hidden md:block -top-[80px] -left-[1px]"
                    aria-hidden="true"
                    style={{
                      color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                    }}
                  >
                    <path
                      d="M0.5 0V120"
                      stroke="currentColor"
                      strokeDasharray="5 5"
                    ></path>
                  </svg>
                  <svg
                    width="1px"
                    height="80"
                    viewBox="0 0 1 120"
                    className="absolute hidden md:block -top-[40px] -left-[40px] rotate-90"
                    aria-hidden="true"
                    style={{
                      color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                    }}
                  >
                    <path
                      d="M0.5 0V120"
                      stroke="currentColor"
                      strokeDasharray="5 5"
                    ></path>
                  </svg>
                  <svg
                    width="1px"
                    height="80"
                    viewBox="0 0 1 120"
                    className="absolute hidden md:block -top-[80px] -right-[1px]"
                    aria-hidden="true"
                    style={{
                      color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                    }}
                  >
                    <path
                      d="M0.5 0V120"
                      stroke="currentColor"
                      strokeDasharray="5 5"
                    ></path>
                  </svg>
                  <svg
                    width="1px"
                    height="80"
                    viewBox="0 0 1 120"
                    className="absolute hidden md:block -top-[40px] -right-[40px] rotate-90"
                    aria-hidden="true"
                    style={{
                      color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                    }}
                  >
                    <path
                      d="M0.5 0V120"
                      stroke="currentColor"
                      strokeDasharray="5 5"
                    ></path>
                  </svg>
                  <svg
                    width="1px"
                    height="80"
                    viewBox="0 0 1 120"
                    className="absolute hidden md:block -bottom-[80px] -left-[1px]"
                    aria-hidden="true"
                    style={{
                      color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                    }}
                  >
                    <path
                      d="M0.5 0V120"
                      stroke="currentColor"
                      strokeDasharray="5 5"
                    ></path>
                  </svg>
                  <svg
                    width="1px"
                    height="80"
                    viewBox="0 0 1 120"
                    className="absolute hidden md:block -bottom-[40px] -left-[40px] rotate-90"
                    aria-hidden="true"
                    style={{
                      color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                    }}
                  >
                    <path
                      d="M0.5 0V120"
                      stroke="currentColor"
                      strokeDasharray="5 5"
                    ></path>
                  </svg>
                  <svg
                    width="1px"
                    height="80"
                    viewBox="0 0 1 120"
                    className="absolute hidden md:block -bottom-[80px] -right-[1px]"
                    aria-hidden="true"
                    style={{
                      color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                    }}
                  >
                    <path
                      d="M0.5 0V120"
                      stroke="currentColor"
                      strokeDasharray="5 5"
                    ></path>
                  </svg>
                  <svg
                    width="1px"
                    height="80"
                    viewBox="0 0 1 120"
                    className="absolute hidden md:block -bottom-[40px] -right-[40px] rotate-90"
                    aria-hidden="true"
                    style={{
                      color: `${theme == "dark" ? "#ffffff3a" : "#d2d5db"} `,
                    }}
                  >
                    <path
                      d="M0.5 0V120"
                      stroke="currentColor"
                      strokeDasharray="5 5"
                    ></path>
                  </svg>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      <section className="container my-10 md:my-20 max-w-[600px] mx-auto  px-6">
        <h2 className="font-medium  text-4xl xs:text-5xl lg:text-6xl leading-[1.2] -tracking-[2.4px] text-center mb-16">
          <span className="text-[#286efb] dark:text-[#A9C5FF]">Earn cash </span>{" "}
          by sharing great products today
        </h2>

        <div className="flex gap-4 w-full flex-col md:flex-row">
          <div className="grid gap-2 flex-1">
            <div className="border border-gray-300 dark:border-[#575662] flex items-center bg-white rounded-md text-black focus-visible:outline-none disabled:cursor-not-allowed disabled:opacity-50">
              <svg
                xmlns="http://www.w3.org/2000/svg"
                width="24"
                height="24"
                viewBox="0 0 24 24"
                fill="none"
                stroke="currentColor"
                strokeWidth="2"
                strokeLinecap="round"
                strokeLinejoin="round"
                className="lucide lucide-mail flex-shrink-0 mx-4 text-gray-400"
              >
                <rect width="20" height="16" x="2" y="4" rx="2"></rect>
                <path d="m22 7-8.97 5.7a1.94 1.94 0 0 1-2.06 0L2 7"></path>
              </svg>
              <input
                className="file:border-0 file:bg-transparent file:text-sm file:font-medium placeholder:text-muted-foreground/60 focus-visible:outline-none disabled:cursor-not-allowed disabled:opacity-50 flex w-full rounded-md border border-input py-1 transition-colors text-base bg-white h-[48px] flex-1 border-none px-0 !ring-0 focus-visible:!ring-0 shadow-none focus-visible:ring-ring"
                placeholder="Enter your email"
                name="email_address"
                value=""
              />
            </div>
          </div>
          <Link href="/affiliate-program/join">
            <button
              type="submit"
              className="px-6 py-[14px] bg-[#25272c] dark:bg-[#286efb]  text-white font-medium rounded-lg transition w-full sm:w-auto"
            >
              Join the Team
            </button>
          </Link>
        </div>

        <ul className="mt-5 flex gap-5 justify-center flex-col md:flex-row items-center">
          <li className="flex gap-2 items-center">
            <span className="text-[#286efb] dark:text-[#A9C5FF]">
              <svg
                xmlns="http://www.w3.org/2000/svg"
                width="16"
                height="16"
                viewBox="0 0 24 24"
                fill="none"
                stroke="currentColor"
                strokeWidth="2"
                strokeLinecap="round"
                strokeLinejoin="round"
                className="lucide lucide-check"
              >
                <path d="M20 6 9 17l-5-5"></path>
              </svg>
            </span>
            Free to join
          </li>
          <li className="flex gap-2 items-center">
            <span className="text-[#286efb] dark:text-[#A9C5FF]">
              <svg
                xmlns="http://www.w3.org/2000/svg"
                width="16"
                height="16"
                viewBox="0 0 24 24"
                fill="none"
                stroke="currentColor"
                strokeWidth="2"
                strokeLinecap="round"
                strokeLinejoin="round"
                className="lucide lucide-check"
              >
                <path d="M20 6 9 17l-5-5"></path>
              </svg>{" "}
            </span>
            Fast payouts
          </li>
          <li className="flex gap-2 items-center">
            <span className="text-[#286efb] dark:text-[#A9C5FF]">
              <svg
                xmlns="http://www.w3.org/2000/svg"
                width="16"
                height="16"
                viewBox="0 0 24 24"
                fill="none"
                stroke="currentColor"
                strokeWidth="2"
                strokeLinecap="round"
                strokeLinejoin="round"
                className="lucide lucide-check"
              >
                <path d="M20 6 9 17l-5-5"></path>
              </svg>{" "}
            </span>
            Full support
          </li>
        </ul>
      </section>

      <Footer />
      <SidebarDrawer open={leftDrawerOpen} toggle={toggleLeftDrawer} />
    </div>
  );
}

export default PartnersPage;
