"use client";
import { FaArrowRight } from "react-icons/fa";
import React from "react";
import arrow1 from "../../public/images/arrow-1.png";
import popImg from "../../public/images/pop-img.png";
import {
  ActivityIcon,
  ArrowDown,
  BellIcon,
  Ellipsis,
  HeartIcon,
  LayersIcon,
  LayoutDashboardIcon,
  LineChartIcon,
  MessageSquareIcon,
  Share2Icon,
  StarIcon,
  ThumbsUpIcon,
  TrendingUpIcon,
  WorkflowIcon,
  ZapIcon,
} from "lucide-react";
import { useState } from "react";
import { ArrowUpRightIcon } from "lucide-react";
import { Button } from "../components/button";
import { Card, CardContent, CardHeader } from "../components/card";
import { Separator } from "../components/separator";
import { Switch } from "../components/switch";
import { FaStar } from "react-icons/fa";
import { IoIosArrowBack, IoIosArrowForward } from "react-icons/io";
import { ArrowRightIcon } from "lucide-react";
import BGLine from "../../public/images/BGLine.png";
import ctaimage from "../../public/images/ctaWhite.png";
import ctaBlack from "../../public/images/ctaBlack.png";
import { Logs } from "lucide-react";
import { useEffect, useRef } from "react";
import logosDark from "../../public/images/logosDark.png";
import logosLight from "../../public/images/logosLight.png";
import LeftDark from "../../public/images/LeftDark.png";
import Star from "../../public/images/star.png";
import {
  BarChart3Icon,
  RefreshCwIcon,
  SmileIcon,
  UsersIcon,
} from "lucide-react";
import custom1 from "../../public/images/crmpic1.png";
import custom2 from "../../public/images/crmpic2.png";
import custom3 from "../../public/images/crmpic3.png";
import custom4 from "../../public/images/crmpic4.png";
import { useTheme } from "../atoms/theme";
import { MacWindowCarousel } from "@/components/MacWindowCarousel";
import ThemeSwitch from "../components/themeSwitch";
import ShadowVector from "../../public/images/vectorshadow.png";
import illustration from "../../public/images/new2.png";
import SidebarDrawer from "../components/sidebarDrawer";
import AfterHeroSection from "../../public/images/crm_user_pic.jpeg";
import appstir from "../../public/images/zairlabs.png";
import {
  FileTextIcon,
  LayoutIcon,
  ShieldCheckIcon,
  SendIcon,
  HeadphonesIcon,
  HandshakeIcon,
  PaletteIcon,
} from "lucide-react";
import { apps } from "../constants/products";
import AppsSection from "../components/appsSection";
import { footerColumns } from "../constants/footerText";
import Link from "next/link";
import Image from "next/image";
import esigndark from "../../public/images/crmdark.png";
import esignlight from "../../public/images/crmlight.png";
import AnnouncementBar from "../components/AnnouncementBar";
import { getCookie } from "../utils/cookies";
import someee from "../../public/images/someee.jpeg";
import emmar from "../../public/images/emmar.jpeg";
import sarah from "../../public/images/Sarah.webp";
import jamesCarter from "../../public/images/james-carter.jpg";
import ayesha from "../../public/images/Ayesha.jpg";
import deniel from "../../public/images/deniel.png";
import linda from "../../public/images/linda.jpg";
import user11 from "../../public/images/user11.jpeg";
import rightArrow from "../../public/images/right-arrow.png";
import TabbedFeature from "../components/TabbedFeature";
import avam from "../../public/images/avam.jpeg";
import { IoHeartCircle } from "react-icons/io5";
import FeaturedPic from "../components/FeaturedPic";
import { getEncodedReferrer } from "@/utils/utils";
import ClikkleLogo from "@/components/ClikkleLogo";

const CrmHome: React.FC = () => {
  const { theme } = useTheme();
  const [scrolled, setScrolled] = useState(false);
  useEffect(() => {
    const handleScroll = () => {
      setScrolled(window.scrollY > 0);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const [leftDrawerOpen, setLeftDrawerOpen] = useState(false);
  const toggleLeftDrawer = () => setLeftDrawerOpen((prev) => !prev);

  const tabFeatures = [
    {
      id: "overview",
      label: "Overview",
      icon: <LayoutDashboardIcon className="w-4 h-4" />,
      lightImage: esignlight,
      darkImage: esigndark,
    },
    {
      id: "pipeline",
      label: "Pipeline",
      icon: <TrendingUpIcon className="w-4 h-4" />,
      lightImage: esignlight,
      darkImage: esigndark,
    },
    {
      id: "contacts",
      label: "Contacts",
      icon: <UsersIcon className="w-4 h-4" />,
      lightImage: esignlight,
      darkImage: esigndark,
    },
    {
      id: "deals",
      label: "Deals",
      icon: <HandshakeIcon className="w-4 h-4" />,
      lightImage: esignlight,
      darkImage: esigndark,
    },
    {
      id: "reports",
      label: "Reports",
      icon: <BarChart3Icon className="w-4 h-4" />,
      lightImage: esignlight,
      darkImage: esigndark,
    },
  ];

  const features1 = [
    {
      icon: (
        <BarChart3Icon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Analytics",
      description: "Track customer interactions and sales patterns",
    },
    {
      icon: <UsersIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Engagement",
      description: "Build stronger relationships with automated follow-ups",
    },
    {
      icon: (
        <RefreshCwIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Efficiency",
      description: "Streamline sales processes with workflow automation",
    },
    {
      icon: <SmileIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Satisfaction",
      description: "Improve customer experience with personalized service",
    },
  ];

  const features2 = [
    {
      icon: (
        <LineChartIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Insights",
      description: "Monitor sales pipeline and conversion rates",
    },
    {
      icon: <BellIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Alerts",
      description: "Instant notifications for important customer activities",
    },
    {
      icon: <ZapIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Performance",
      description: "Automated workflows maximize team productivity",
    },
    {
      icon: (
        <ThumbsUpIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Success",
      description: "Close more deals with intelligent lead scoring",
    },
  ];

  const features3 = [
    {
      icon: (
        <ActivityIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Dashboard",
      description: "Real-time overview of sales and customer metrics",
    },
    {
      icon: (
        <MessageSquareIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Collaboration",
      description: "Team communication within customer records",
    },
    {
      icon: (
        <LayersIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Integration",
      description: "Connect with your favorite tools and platforms",
    },
    {
      icon: <StarIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Experience",
      description: "Customizable interface for optimal workflow",
    },
  ];
  const features4 = [
    {
      icon: (
        <TrendingUpIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Growth",
      description: "Scale your business with powerful CRM tools",
    },
    {
      icon: (
        <Share2Icon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Connectivity",
      description: "Sync data across teams and departments",
    },
    {
      icon: (
        <WorkflowIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Automation",
      description: "Reduce manual tasks with smart workflows",
    },
    {
      icon: <HeartIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Retention",
      description: "Build lasting customer relationships",
    },
  ];

  const [productsOpen, setProductsOpen] = useState(false);
  const productsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (
        productsRef.current &&
        !productsRef.current.contains(event.target as Node)
      ) {
        setProductsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);

  const testimonials = [
    {
      text: "This CRM has completely transformed how we manage customer relationships. The intuitive interface and powerful features have helped us increase sales by 35% since implementation. I can't imagine running our business without it now.",
      name: "Sarah Mitchell",
      title: "CEO at TechFlow Solutions",
      date: "Jul 5, 2025",
      logo: sarah,
      recommendNote: "Clikkle CRM is must recommended",
    },
    {
      text: "We've experienced a remarkable 50% increase in sales productivity thanks to Clikkle's seamless CRM workflows. The detailed customer insights give us complete visibility, while the mobile app ensures we can manage relationships anywhere. It has become an irreplaceable tool for our sales team.",
      name: "James Carter",
      title: "COO at FinStream Inc.",
      date: "Jun 20, 2025",
      logo: jamesCarter,
      recommendNote: "Highly recommended for sales teams",
    },
    {
      text: "Clikkle CRM has made customer management effortless for our entire organization. Our sales team now spends far less time on admin and far more time building relationships. The platform's reliability and integrated features have made it an invaluable asset for growth.",
      name: "Linda Park",
      title: "Head of Sales at NovaCorp",
      date: "May 30, 2025",
      logo: linda,
      recommendNote: "A game-changer for sales teams",
    },
    {
      text: "Thanks to Clikkle CRM, managing customer interactions has never been easier. The automated workflows streamline every touchpoint, while built-in analytics ensure we never miss an opportunity. Our team saves valuable time each week while delivering better service.",
      name: "Daniel Rose",
      title: "Sales Manager at BrightHire",
      date: "Apr 18, 2025",
      logo: deniel,
      recommendNote: "Perfect sales solution",
    },
    {
      text: "We're closing deals twice as fast since adopting Clikkle CRM. The intuitive interface, combined with powerful automation features, helps our team focus on what matters most - building relationships. It has truly transformed our sales process entirely.",
      name: "Ayesha Malik",
      title: "Sales Director at DealStream",
      date: "Mar 8, 2025",
      logo: ayesha,
      recommendNote: "Best tool for customer management",
    },
  ];

  const [idx, setIdx] = useState(0);
  const { text, name, title, date, logo, recommendNote } = testimonials[idx];

  const redirectToSignup = (planName: string, cycle: "monthly" | "annual") => {
    const base = "https://crm.clikkle.com/signup";
    const params = new URLSearchParams({
      theme: theme ?? "",
      plan: planName,
      cycle,
    });
    window.location.replace(`${base}?${params.toString()}`);
  };

  const prev = () =>
    setIdx((idx - 1 + testimonials.length) % testimonials.length);
  const next = () => setIdx((idx + 1) % testimonials.length);

  const [isAnnual, setIsAnnual] = useState(true);
  const monthlyPlans = [
    {
      name: "Basic",
      description: "Perfect For\nSmall Teams",
      price: "$29",
      buttonText: "Start With Basic",
      buttonVariant: "outline",
      features: [
        { icon: UsersIcon, text: "5", subtext: "Users" },
        {
          icon: FileTextIcon,
          text: "1000",
          subtext: "Contacts (CRUD & Search)",
        },
        { icon: BarChart3Icon, text: "", subtext: "Basic Sales Reporting" },
        {
          icon: ShieldCheckIcon,
          text: "",
          subtext: "Email Logging / Integration (basic)",
        },
        { icon: LayoutIcon, text: "", subtext: "Task & Follow-up Reminders" },
        { icon: LayersIcon, text: "", subtext: "Live Chat Sync" },
        {
          icon: HeadphonesIcon,
          text: "",
          subtext: "Basic Support & Ticketing",
        },
        {
          icon: HandshakeIcon,
          text: "",
          subtext: "Deal Tracking (Kanban - basic)",
        },
      ],
      highlighted: false,
    },
    {
      name: "Professional",
      description: "Best For\n1-10 Users",
      price: "$79",
      buttonText: "Start With Professional",
      buttonVariant: "primary",
      features: [
        { icon: UsersIcon, text: "10", subtext: "Users" },
        {
          icon: FileTextIcon,
          text: "",
          subtext: "5000 Contacts (advanced search & notes)",
        },
        {
          icon: BarChart3Icon,
          text: "",
          subtext: "Advanced Sales Reporting & Dashboards",
        },
        {
          icon: ShieldCheckIcon,
          text: "",
          subtext: "Priority Email Integration & Logging",
        },
        { icon: LayoutIcon, text: "10", subtext: "Custom Fields" },
        { icon: LayersIcon, text: "", subtext: "App & Live Chat Integrations" },
        { icon: SendIcon, text: "", subtext: "Bulk Email / Email Campaigns" },
        {
          icon: HeadphonesIcon,
          text: "",
          subtext: "Premium Support & Ticketing",
        },
        {
          icon: HandshakeIcon,
          text: "",
          subtext: "Kanban Deal Pipeline & Deal Management",
        },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Enterprise",
      description: "Good option For\nUnlimited Users",
      price: "$199",
      buttonText: "Start With Enterprise",
      buttonVariant: "outline",
      features: [
        { icon: UsersIcon, text: "Unlimited", subtext: "Users" },
        {
          icon: FileTextIcon,
          text: "Unlimited",
          subtext: "Contacts (enterprise-grade)",
        },
        {
          icon: BarChart3Icon,
          text: "",
          subtext: "Custom Analytics & Reports",
        },
        {
          icon: ShieldCheckIcon,
          text: "",
          subtext: "24/7 Email & Chat Integration",
        },
        { icon: LayoutIcon, text: "Unlimited", subtext: "Custom Fields" },
        { icon: LayersIcon, text: "", subtext: "API Access & Integrations" },
        {
          icon: SendIcon,
          text: "",
          subtext: "Advanced Email Automation & Logging",
        },
        {
          icon: HeadphonesIcon,
          text: "",
          subtext: "Dedicated Support Manager",
        },
        {
          icon: HandshakeIcon,
          text: "",
          subtext: "Full Sales Pipeline & Deal Management",
        },
        { icon: PaletteIcon, text: "", subtext: "Custom Branding" },
      ],
      highlighted: false,
    },
  ];

  const annualPlans = [
    {
      name: "Basic",
      description: "Perfect For\nSmall Teams",
      price: "$24",
      buttonText: "Start With Basic",
      buttonVariant: "outline",
      features: [
        { icon: UsersIcon, text: "5", subtext: "Users" },
        {
          icon: FileTextIcon,
          text: "1000",
          subtext: "Contacts (CRUD & Search)",
        },
        { icon: BarChart3Icon, text: "", subtext: "Basic Sales Reporting" },
        {
          icon: ShieldCheckIcon,
          text: "",
          subtext: "Email Logging / Integration (basic)",
        },
        { icon: LayoutIcon, text: "", subtext: "Task & Follow-up Reminders" },
        { icon: LayersIcon, text: "", subtext: "Live Chat Sync" },
        {
          icon: HeadphonesIcon,
          text: "",
          subtext: "Basic Support & Ticketing",
        },
        {
          icon: HandshakeIcon,
          text: "",
          subtext: "Deal Tracking (Kanban - basic)",
        },
      ],
      highlighted: false,
    },
    {
      name: "Professional",
      description: "Best For\n1-10 Users",
      price: "$59",
      buttonText: "Start With Professional",
      buttonVariant: "primary",
      features: [
        { icon: UsersIcon, text: "10", subtext: "Users" },
        {
          icon: FileTextIcon,
          text: "",
          subtext: "5000 Contacts (advanced search & notes)",
        },
        {
          icon: BarChart3Icon,
          text: "",
          subtext: "Advanced Sales Reporting & Dashboards",
        },
        {
          icon: ShieldCheckIcon,
          text: "",
          subtext: "Priority Email Integration & Logging",
        },
        { icon: LayoutIcon, text: "10", subtext: "Custom Fields" },
        { icon: LayersIcon, text: "", subtext: "App & Live Chat Integrations" },
        { icon: SendIcon, text: "", subtext: "Bulk Email / Email Campaigns" },
        {
          icon: HeadphonesIcon,
          text: "",
          subtext: "Premium Support & Ticketing",
        },
        {
          icon: HandshakeIcon,
          text: "",
          subtext: "Kanban Deal Pipeline & Deal Management",
        },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Enterprise",
      description: "Good option For\nUnlimited Users",
      price: "$149",
      buttonText: "Start With Enterprise",
      buttonVariant: "outline",
      features: [
        { icon: UsersIcon, text: "Unlimited", subtext: "Users" },
        {
          icon: FileTextIcon,
          text: "Unlimited",
          subtext: "Contacts (enterprise-grade)",
        },
        {
          icon: BarChart3Icon,
          text: "",
          subtext: "Custom Analytics & Reports",
        },
        {
          icon: ShieldCheckIcon,
          text: "",
          subtext: "24/7 Email & Chat Integration",
        },
        { icon: LayoutIcon, text: "Unlimited", subtext: "Custom Fields" },
        { icon: LayersIcon, text: "", subtext: "API Access & Integrations" },
        {
          icon: SendIcon,
          text: "",
          subtext: "Advanced Email Automation & Logging",
        },
        {
          icon: HeadphonesIcon,
          text: "",
          subtext: "Dedicated Support Manager",
        },
        {
          icon: HandshakeIcon,
          text: "",
          subtext: "Full Sales Pipeline & Deal Management",
        },
        { icon: PaletteIcon, text: "", subtext: "Custom Branding" },
      ],
      highlighted: false,
    },
  ];

  const [openFAQ, setOpenFAQ] = useState<number | null>(0);

  const faqs = [
    {
      question: "How do I get started with CRM?",
      answer: `Getting started is quick. Create an account, import your contacts, and set up your sales pipeline. We provide an onboarding guide, tutorial videos, and in-app tooltips to walk you through the setup. If you prefer, our support team can help configure your first workflows and automation.`,
    },
    {
      question: "What payment methods do you accept?",
      answer:
        "We accept major credit and debit cards (Visa, Mastercard, American Express) and PayPal for individual and small-business subscriptions. For enterprise customers we offer invoiced billing and direct bank transfers — contact sales to enable invoicing or arrange custom payment terms.",
    },
    {
      question: "Can I change or cancel my plan anytime?",
      answer:
        "Yes — you can upgrade, downgrade, or cancel your subscription from the billing page at any time. Changes take effect immediately or at the start/end of the next billing period depending on the action; enterprise contracts follow the terms in your agreement. For questions about proration or refunds, contact support.",
    },
    {
      question: "Is my customer data secure?",
      answer:
        "Security is our top priority. Customer data is protected with industry-standard encryption in transit (TLS) and at rest. We run regular backups and maintain strict access controls. If you have specific compliance needs (e.g., SOC 2, GDPR), we can discuss options and enterprise-level agreements.",
    },
    {
      question: "Can I integrate with other tools?",
      answer:
        "Yes — our CRM includes a REST API and webhooks to sync data with your existing systems. We provide prebuilt integrations with common business tools (Google Workspace, Microsoft 365, Slack) and support for third-party automation platforms. Need a custom integration? Contact our developer team.",
    },
  ];

  const isDarkMode = theme === "dark";
  const [dotsOpen, setDotsOpen] = useState(false);
  const dotsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (dotsRef.current && !dotsRef.current.contains(event.target as Node)) {
        setDotsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);
  const [announcementOpen, setAnnouncementOpen] = useState(false);

  useEffect(() => {
    const checkHeight = () => {
      const el = document.querySelector("[data-announcement]") as HTMLElement;
      if (el && el.offsetHeight > 0) {
        setAnnouncementOpen(true);
      } else {
        setAnnouncementOpen(false);
      }
    };
    checkHeight();
    const observer = new MutationObserver(checkHeight);
    observer.observe(document.body, { childList: true, subtree: true });
    return () => observer.disconnect();
  }, []);

  useEffect(() => {
    const checkDismissedAnnouncements = () => {
      const dismissed = getCookie("dismissedAnnouncements");
      if (dismissed) {
        try {
          const dismissedIds = JSON.parse(dismissed);
          if (dismissedIds.length > 0) {
            setAnnouncementOpen(false);
          }
        } catch (error) {
          console.error("Error parsing dismissed announcements:", error);
        }
      }
    };

    checkDismissedAnnouncements();

    const interval = setInterval(checkDismissedAnnouncements, 1000);

    return () => clearInterval(interval);
  }, []);
  return (
    <div className="bg-white dark:bg-[#1a1a1a] flex flex-col items-center w-full min-h-screen">
      <div className="w-full max-w-[1540px] relative mx-auto flex flex-col items-center justify-center">
        <section className="w-full">
          <section className="relative w-full  md:min-h-[1038px]  overflow-hidden">
            <div
              className={`fixed top-0 inset-x-0 z-50 ${scrolled
                  ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1a1a]/90"
                  : productsOpen || dotsOpen
                    ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1a1a]/90"
                    : ""
                }`}
            >
              <div
                ref={(el) => {
                  if (el) {
                    const height = el.getBoundingClientRect().height;

                    if (height !== 0) {
                      setAnnouncementOpen(true);
                    }
                  }
                }}
              >
                <AnnouncementBar onClose={() => setAnnouncementOpen(false)} />
              </div>
              <div className="container max-w-[1233px] mx-auto max-[1300px]:px-14 max-[1100px]:px-4">
                <nav
                  className={`relative flex items-center justify-between py-4`}
                >
                  <ClikkleLogo />
                  <div className="flex md:hidden items-center">
                    <div
                      className="flex items-center gap-0 rounded-xl border border-gray-300 dark:border-[#ffffff3a] p-[8px] shadow-sm"
                      onClick={toggleLeftDrawer}
                    >
                      <p className="text-sm font-medium text-gray-900 dark:text-white">
                        <Logs className="w-5 h-5 text-gray-900 dark:text-white mr-3" />
                      </p>

                      <p className="flex items-center  rounded-xl text-sm font-bold ">
                        Menu
                      </p>
                    </div>
                  </div>

                  <div className="hidden md:flex items-center gap-12  font-inter font-medium text-[18px]">
                    <Link
                      href="#features"
                      className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                    >
                      Features
                    </Link>
                    <Link
                      href="#pricing"
                      className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                    >
                      Pricing
                    </Link>
                    <Link
                      href="/blogs"
                      className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                    >
                      Blog
                    </Link>
                    <div className="flex flex-row justify-center items-center">
                      <div className="relative" ref={productsRef}>
                        <button
                          onClick={() => setProductsOpen((o) => !o)}
                          className="cursor-pointer flex items-center gap-1 text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                        >
                          Products
                        </button>
                        {productsOpen && (
                          <div
                            className={`fixed ${announcementOpen ? "top-[115px]" : "top-[75px]"
                              } 
              left-1/2 transform -translate-x-1/2 w-full bg-white/90 dark:bg-[#1a1a1a]/90 backdrop-blur-md 
              shadow-lg p-6 border-b-2 border-gray-300 dark:border-[#575662] z-50 flex justify-center items-center pb-0`}
                          >
                            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                              <div className="flex flex-col gap-3">
                                {apps
                                  .slice(0, Math.ceil(apps.length / 2))
                                  .map((product) => (
                                    <Link
                                      key={product.id}
                                      href={product.route}
                                      className="flex items-center gap-4 p-[0.35rem] rounded-lg hover:bg-gray-100 dark:hover:bg-white/10 transition"
                                    >
                                      <div>
                                        <Image
                                          src={product.image}
                                          alt={product.title}
                                          className="w-[26px]"
                                          width={26}
                                          height={26}
                                        />
                                      </div>
                                      <div>
                                        <p className="font-bold text-gray-900 dark:text-white text-sm">
                                          {product.title}
                                        </p>
                                        <p className="text-xs text-gray-600 dark:text-gray-300">
                                          {product.description}
                                        </p>
                                      </div>
                                    </Link>
                                  ))}
                              </div>

                              <div className="flex flex-col gap-3">
                                {apps
                                  .slice(
                                    Math.ceil(apps.length / 2),
                                    Math.ceil(apps.length / 2) + 2,
                                  )
                                  .map((product) => (
                                    <Link
                                      key={product.id}
                                      href={product.route}
                                      className="flex items-center gap-4 p-[0.35rem] rounded-lg hover:bg-gray-100 dark:hover:bg-white/10 transition"
                                    >
                                      <div>
                                        <Image
                                          src={product.image}
                                          alt={product.title}
                                          className="w-[26px]"
                                          width={26}
                                          height={26}
                                        />
                                      </div>
                                      <div>
                                        <p className="font-bold text-gray-900 dark:text-white text-sm">
                                          {product.title}
                                        </p>
                                        <p className="text-xs text-gray-600 dark:text-gray-300">
                                          {product.description}
                                        </p>
                                      </div>
                                    </Link>
                                  ))}
                                <Link href="/products">
                                  <Button
                                    style={{ marginTop: "5px" }}
                                    variant="ghost"
                                    className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                  >
                                    View all products
                                    <ArrowRightIcon className="h-2 w-2 dark:text-white" />
                                  </Button>
                                </Link>
                              </div>
                              <div className="hidden lg:flex flex-row items-center justify-center text-center gap-3">
                                <Image
                                  src={illustration}
                                  alt="Illustration"
                                  className="w-auto h-[175px]"
                                />
                                <div className="flex flex-col justify-center items-center h-full">
                                  <p className="text-sm text-gray-700 dark:text-gray-300 max-w-[200px] pb-5 ">
                                    Get started today the modern solution to
                                    power your business.
                                  </p>
                                  <Button
                                    variant="ghost"
                                    onClick={() => {
                                      window.location.replace(
                                        "https://crm.clikkle.com/signup?theme=" +
                                        theme +
                                        "&referralApp=" +
                                        getEncodedReferrer()
                                      );
                                    }}
                                    className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                  >
                                    Get Started Today
                                    <ArrowRightIcon
                                      className={`h-2 w-2 dark:text-white`}
                                    />
                                  </Button>
                                </div>
                              </div>
                            </div>
                          </div>
                        )}
                      </div>

                      <div className="relative" ref={dotsRef}>
                        <Ellipsis
                          onClick={() => setDotsOpen((o) => !o)}
                          className="w-8 h-6 rounded-full p-[1px] cursor-pointer"
                        />
                        {dotsOpen && (
                          <div
                            className={`fixed ${announcementOpen ? "top-[115px]" : "top-[75px]"
                              } left-1/2 transform -translate-x-1/2 w-full 
    bg-white/90 dark:bg-[#1a1a1a]/90 backdrop-blur-md 
    shadow-lg border-b-2 border-gray-300 dark:border-[#575662] 
    z-50 flex justify-center`}
                          >
                            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 py-6">
                              <div className="flex flex-col md:flex-row justify-between items-start gap-12">
                                <div className="space-y-12">
                                  <div className="max-w-[285px] space-y-2 mb-0">
                                    <h3 className="font-instrument-sans font-medium text-[18px] leading-[20px] text-gray-900 dark:text-[#eeeef0]">
                                      Get Started For Free
                                    </h3>
                                    <p className="font-body-medium text-[#51515E] dark:text-[#eeeef0]">
                                      Streamline your Business with our Apps.
                                      Effortlessly for every team.
                                    </p>
                                  </div>
                                  <Button
                                    style={{ marginTop: "20px" }}
                                    variant="ghost"
                                    onClick={() => {
                                      window.location.replace(
                                        "https://crm.clikkle.com/signup?theme=" +
                                        theme +
                                        "&referralApp=" +
                                        getEncodedReferrer()
                                      );
                                    }}
                                    className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                  >
                                    See How It Works
                                    <ArrowRightIcon
                                      className={`h-2 w-2 dark:text-white`}
                                    />
                                  </Button>
                                </div>

                                <div className="flex flex-wrap gap-x-14 gap-y-8 text-xs sm:text-sm">
                                  {footerColumns.map((column, index) => (
                                    <div
                                      key={index}
                                      className="flex flex-col gap-5"
                                    >
                                      <h4 className="font-label-medium text-gray-900 dark:text-white">
                                        {column.title}
                                      </h4>
                                      <ul className="flex flex-col gap-4">
                                        {column.links.map((link, linkIndex) => (
                                          <li key={linkIndex}>
                                            <div className="flex items-start gap-3">
                                              <Link
                                                href={link.url}
                                                target={
                                                  link.url.startsWith("http")
                                                    ? "_blank"
                                                    : "_self"
                                                }
                                                rel={
                                                  link.url.startsWith("http")
                                                    ? "noopener noreferrer"
                                                    : undefined
                                                }
                                                className="font-body-medium text-[#51515E] dark:text-[#d7d7de] hover:text-gray-900 dark:hover:text-white transition-colors whitespace-nowrap flex items-center gap-2"
                                              >
                                                {link.text}
                                                {column.title === "Social" && (
                                                  <FaArrowRight className="w-2 h-2" />
                                                )}
                                              </Link>

                                              {link.isNew && (
                                                <div className="hidden md:flex items-center gap-2">
                                                  <div className="w-4 h-4 flex items-center justify-center">
                                                    <div className="w-[13px] h-[13px] bg-[#c3e6ff] rounded-[6.67px] flex items-center justify-center">
                                                      <div className="w-1 h-1 bg-[#286efb] rounded-sm" />
                                                    </div>
                                                  </div>
                                                  <span className="font-body-medium text-gray-900 dark:text-white whitespace-nowrap">
                                                    New
                                                  </span>
                                                </div>
                                              )}
                                            </div>
                                          </li>
                                        ))}
                                      </ul>
                                    </div>
                                  ))}
                                </div>
                              </div>
                            </div>
                          </div>
                        )}
                      </div>
                    </div>
                  </div>

                  <div className="hidden md:flex items-center gap-4">
                    <div className="hidden md:flex items-center gap-4">
                      <div className="w-6">
                        <ThemeSwitch />
                      </div>
                      <div className="flex items-center gap-2 rounded-xl border border-gray-300 dark:border-[#ffffff3a] p-1 shadow-sm">
                        <button
                          className="cursor-pointer px-3 py-1 text-sm font-medium text-gray-900 dark:text-white"
                          onClick={() => {
                            window.location.replace(
                              "https://crm.clikkle.com/login?theme=" +
                              theme +
                              "&referralApp=" +
                              getEncodedReferrer()
                            );
                          }}
                        >
                          Login
                        </button>

                        <button
                          className="cursor-pointer flex items-center gap-1 rounded-xl bg-[#286efb] hover:bg-[#3367d6] px-4 py-1.5 text-sm font-medium text-white transition"
                          onClick={() => {
                            window.location.replace(
                              "https://crm.clikkle.com/signup?theme=" + theme +
                              "&referralApp=" +
                              getEncodedReferrer()
                            );
                          }}
                        >
                          Try for free
                          <span>
                            <ArrowRightIcon className="w-4" />
                          </span>
                        </button>
                      </div>
                    </div>
                  </div>
                </nav>
              </div>
            </div>

            <div
              className={`z-10 flex flex-col items-center text-center ${announcementOpen ? "pt-[140px]" : "pt-[110px]"
                } px-6 relative`}
            >
              <div className="absolute h-full w-full top-0 right-0 ">
                <Image
                  src={ShadowVector}
                  alt="Shadow vector"
                  className="w-full h-full"
                />
              </div>
              <div className="flex items-center justify-center gap-2 mb-2 font-semibold py-4">
                <Link href="/">
                  <div className="flex items-center justify-center md:w-[245px] w-auto">
                    <Image
                      className="h-[32px] md:h-[40px] w-auto"
                      alt="Clikkle Crm logo"
                      width={114}
                      height={40}
                      src={
                        isDarkMode
                          ? "https://cdn.clikkle.com/images/crm/2025/Clikkle%20crm%20Blue%20(%20White%20Text).png"
                          : "https://cdn.clikkle.com/images/crm/2025/Clikkle%20crm%20Blue%20(%20Black%20Text).png"
                      }
                    />
                  </div>
                </Link>
              </div>
              <h1 className="font-inter font-black text-[40px] lg:text-7xl text-gray-900 dark:text-[#fff] mb-3 md:mb-[0.5rem] max-w-5xl leading-[1.1] md:leading-[1]">
                <span className={`dark:text-[#A9C5FF] text-[#286efb]`}>
                  Enhance your <br className="hidden sm:block" />
                </span>{" "}
                Customer Care
              </h1>

              <span className="relative font-small text-[14px] md:text-[18px] text-[#3D3D3D] dark:text-[#EEEEF0] mb-8 max-w-3xl ">
                Streamline customer management with our CRM platform. Automated{" "}
                <br className="hidden sm:block" /> workflows, sales tracking,
                insights. Join now.
                {/*<img
                    src={"/images/arrow-1.png"}
                    alt="arrow"
                    className="hidden sm:block absolute right-[-112px] top-[0px] rotate-[330deg]"
                  />*/}
                {/*<div className="absolute right-[-280px] top-[40px] hidden sm:block">
             <p className="text-[#51515E] dark:text-[#d7d7de] text-[24px] font-black font-caveat">
                    $  24.00 / month <br />
                    for Clikkle CRM
                  </p>
                </div>*/}
              </span>

              <div className="flex flex-col sm:flex-row items-center !gap-[8px] sm:gap-4 mb-4 w-full max-w-lg z-10">
                <input
                  type="email"
                  placeholder="Enter Your Email"
                  className="flex-1 px-4 py-3 rounded-lg bg-white  text-gray-900  placeholder-gray-500 dark:placeholder-gray-400 focus:outline-none w-full border border-gray-300 dark:border-[#575662] shadow-sm dark:shadow-none"
                />
                <button
                  onClick={() => {
                    window.location.replace(
                      "https://crm.clikkle.com/signup?theme=" + theme +
                      "&referralApp=" +
                      getEncodedReferrer()
                    );
                  }}
                  type="submit"
                  className="cursor-pointer px-6 py-[14px] bg-[#25272c] dark:bg-[#286efb]  text-white font-medium rounded-lg transition w-full sm:w-auto"
                >
                  Try for Free
                </button>
              </div>
              <p className="text-[#51515E] dark:text-[#d7d7de] text-sm mb-[0.5rem] z-10">
                No credit card required.{" "}
                <Link
                  href={`${"https://worksuite.clikkle.com/signup?theme=" + theme +
                    "&referralApp=" +
                    getEncodedReferrer()
                    }`}
                  className="text-black dark:text:white dark:text-white underline hover:no-underline hover:cursor-pointer"
                >
                  Sign Up for no cost
                </Link>
              </p>
              <div className="flex flex-col sm:flex-row items-center gap-2 md:gap-16">
                {/*<span className="text-[#51515E] dark:text-[#D7D7DE] text-sm">
                  Trusted by{" "}
                  <span className="dark:text-[#A9C5FF] text-[#286efb]">
                    10k+
                  </span>{" "}
                  companies
                </span>*/}
                <div className="flex items-center gap-8">
                  {/*<Image
                    src={theme === "dark" ? logosDark : logosLight}
                    alt="Logos"
                    className="h-[36px] w-[242px]"
                    width={162}
                    height={36}
                  />*/}
                </div>
              </div>
            </div>
            <div className="flex items-center justify-center pb-8 mt-8 rounded-lg w-full">
              <div className="relative w-full max-w-[1200px]">
                {/*<img
                  src={popImg.src}
                  alt="popImg"
                  className="hidden sm:block absolute w-[120px] left-[-70px] top-[-74px]"
                />*/}
                <MacWindowCarousel initialProduct="crm" />
              </div>
            </div>
            {/* <div className="flex items-center justify-center pb-8 mt-8 rounded-lg w-full md:w-auto">
              <div className="relative w-full flex justify-center">
                <TabbedFeature
                  tabs={tabFeatures}
                  decorator={
                    <Image
                      src={popImg}
                      alt="popImg"
                      className="hidden sm:block absolute w-[120px] left-[-70px] top-[-74px] z-10"
                      width={120}
                      height={120}
                    />
                  }
                />
              </div>
            </div> */}
          </section>
        </section>

        <section className="w-full max-w-[1240px] text-gray-900 dark:text-white py-16 px-4 md:px-8 lg:px-16 m-auto">
          <div className="mx-auto text-center">
            <h2 className="text-sm md:text-base font-semibold text-[#286efb] dark:text-[#adc4fb] mb-4">
              Why Clikkle CRM?
            </h2>

            <h1 className="text-4xl md:text-5xl font-black mb-4 ">
              Manage relationships, close deals{" "}
              <br className="hidden md:block" /> effortlessly
            </h1>

            <p className="text-lg md:text-xl text-gray-600 dark:text-gray-300 mb-12">
              From contact management to sales automation, everything you{" "}
              <br className="hidden md:block" />
              need to grow your business in one place.
            </p>

            <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8 mb-16">
              <div className="flex flex-col items-center">
                <div className="bg-gray-100 dark:bg-[#141414] rounded-2xl p-4 mb-4">
                  <svg
                    className="w-8 h-8 text-gray-600 dark:text-gray-300"
                    fill="none"
                    stroke="currentColor"
                    viewBox="0 0 24 24"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <path
                      strokeLinecap="round"
                      strokeLinejoin="round"
                      strokeWidth="2"
                      d="M16 11V7a4 4 0 10-8 0v4M7 11h10a2 2 0 012 2v5a2 2 0 01-2 2H7a2 2 0 01-2-2v-5a2 2 0 012-2z"
                    />
                  </svg>
                </div>
                <h2 className="text-xl font-semibold mb-2">Organized</h2>
                <p className="text-gray-600 dark:text-gray-400 text-center">
                  Centralize customer data so you&apos;re always informed.
                </p>
              </div>

              <div className="flex flex-col items-center">
                <div className="bg-gray-100 dark:bg-[#141414] rounded-2xl p-4 mb-4">
                  <svg
                    className="w-8 h-8 text-gray-600 dark:text-gray-300"
                    fill="none"
                    stroke="currentColor"
                    viewBox="0 0 24 24"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <path
                      strokeLinecap="round"
                      strokeLinejoin="round"
                      strokeWidth="2"
                      d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"
                    />
                  </svg>
                </div>
                <h2 className="text-xl font-semibold mb-2">Reliable</h2>
                <p className="text-gray-600 dark:text-gray-400 text-center">
                  Access customer information securely from anywhere.
                </p>
              </div>

              <div className="flex flex-col items-center">
                <div className="bg-gray-100 dark:bg-[#141414] rounded-2xl p-4 mb-4">
                  <svg
                    className="w-8 h-8 text-gray-600 dark:text-gray-300"
                    fill="none"
                    stroke="currentColor"
                    viewBox="0 0 24 24"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <path
                      strokeLinecap="round"
                      strokeLinejoin="round"
                      strokeWidth="2"
                      d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"
                    />
                  </svg>
                </div>
                <h2 className="text-xl font-semibold mb-2">Real-time</h2>
                <p className="text-gray-600 dark:text-gray-400 text-center">
                  Receive instant updates on customer activities and deals.
                </p>
              </div>

              <div className="flex flex-col items-center">
                <div className="bg-gray-100 dark:bg-[#141414] rounded-2xl p-4 mb-4">
                  <svg
                    className="w-8 h-8 text-gray-600 dark:text-gray-300"
                    fill="none"
                    stroke="currentColor"
                    viewBox="0 0 24 24"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <path
                      strokeLinecap="round"
                      strokeLinejoin="round"
                      strokeWidth="2"
                      d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"
                    />
                  </svg>
                </div>
                <h2 className="text-xl font-semibold mb-2">Intuitive</h2>
                <p className="text-gray-600 dark:text-gray-400 text-center">
                  Easy-to-use interface that requires minimal training.
                </p>
              </div>
            </div>
            <div className="md:mt-36 font-bold border-gray-300 dark:border-[#575662] max-w-[1120px] mx-auto bg-[#20253a] text-white min-h-[35px] dark:bg-[#141414] rounded-2xl p-6 shadow-lg flex flex-col md:flex-row items-center gap-6 overflow-visible relative">
              <Image
                src={AfterHeroSection}
                alt="Crystal Dionysopoulos"
                className="md:w-[260px] md:h-[330px] w-full h-auto rounded-lg md:object-cover md:ml-[1.7rem] md:mt-[-5.3rem] md:transform md:-rotate-3 md:scale-110 shadow-2xl md:z-20"
              />

              <div className="text-left md:p-[60px]">
                <p className="text-lg md:text-2xl !text-[1.40rem] mb-4 leading-normal">
                  I&apos;ve been a happy CRM customer since 2019.{" "}
                  <br className="hidden sm:block" />
                  <span className="bg-[#3d0ebf] font-semibold">
                    Clikkle CRM has helped me manage customer relationships
                    effortlessly.
                  </span>{" "}
                  My team loves it too - they feel more organized and productive
                  than ever before.
                </p>
                <div className="flex items-center gap-2">
                  <Image
                    src={appstir}
                    alt="appstir Logo"
                    className="w-8 h-8 rounded-sm"
                  />
                  <div>
                    <p className="font-semibold">ZairLabs</p>
                    <p className="text-sm">Founder, Lead Developer</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>

        <section className="w-full max-w-[1480]">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-[#1a1a1a]"
            id="features"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center sm:gap-[8rem]">
                <div className="space-y-8 justify-self-start">
                  <div className="space-y-4">
                    {" "}
                    <span className="hidden md:block text-[#286efb] dark:text-[#A9C5FF] text-[16px] font-bold">
                      Feature
                    </span>
                    <h2 className="text-[1.6rem] md:text-5xl text-gray-900 mt-4 md:mt-0  dark:text-white !leading-[1.2]  font-inter font-[900]  ">
                      Smart{" "}
                      <span className="text-[#286efb] dark:text-[#A9C5FF]">
                        Relationship
                      </span>{" "}
                      Management
                    </h2>
                    <p className="text-gray-600 dark:text-[#d7d7de] max-w-lg font-inter font-normal text-[16px] md:text-[18px]     ">
                      Manage leads with automated follow-ups and smart scoring
                      to boost customer relationships.
                    </p>
                  </div>

                  <div className="grid grid-cols-2 gap-6 max-w-[529px]">
                    {features1.map((feature, index) => (
                      <div key={index} className="md:space-y-1">
                        <div className="flex items-center gap-3">
                          <div className="w-4 h-4 rounded-lg flex items-center justify-center text-gray-600 dark:text-[#d7d7de]">
                            {feature.icon}
                          </div>
                          <h3 className="text-gray-900 dark:text-[#d7d7de] text-lg font-open-sauce font-black text-[1.16rem]  ">
                            {feature.title}
                          </h3>
                        </div>
                        <p className="text-gray-600 dark:text-[#d7d7de] text-[14px] leading-[20px] pl-[1.75rem] mt-0 font-inter font-normal">
                          {feature.description}
                        </p>
                      </div>
                    ))}
                  </div>
                  <div className="flex flex-row md:justify-start  gap-4 pt-4">
                    <Button
                      onClick={() => {
                        window.location.replace(
                          "https://crm.clikkle.com/signup?theme=" + theme +
                          "&referralApp=" +
                          getEncodedReferrer()
                        );
                      }}
                      className="bg-[#286efb] hover:bg-[#3367d6] text-white px-8 py-3 h-[40px]"
                    >
                      Get Started
                    </Button>
                    <div className="pl-4 rounded-lg  font-light md:block hidden text-gray-600 dark:text-[#d7d7de] ">
                      <p className="text-sm leading-relaxed font-inter">
                        <span className="text-[#ff4b5c]">&rdquo;</span>Super
                        easy to use and helped us increase sales by 40%!
                        <span className="text-[#ff4b5c]">&rdquo;</span>
                      </p>
                      <div className="flex items-center gap-3 mt-[0.4rem]">
                        <Image
                          src={avam}
                          alt="Batu K."
                          width={24}
                          height={24}
                          className="w-6 h-6 rounded-full"
                        />
                        <div>
                          <p className="font-semibold text-sm">Batu K.</p>
                          <p className="text-xs text-gray-400">
                            Marketing Strategist
                          </p>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px]  justify-center md:justify-end order-first lg:order-none">
                  <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <FeaturedPic>
                    <Image
                      src={
                        theme === "dark"
                          ? "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/chat%20app-darkmode.png"
                          : "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/chat%20app-daymode.png"
                      }
                      className="rounded-lg shadow-lg mt-5 relative z-10  md:min-h-[345px]"
                      alt="Files picture"
                      width={600}
                      height={600}
                    />
                  </FeaturedPic>
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-[#1a1a1a]"
            id="features2-2"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center">
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px]  justify-center md:justify-start order-first lg:order-first">
                  <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <FeaturedPic>
                    <Image
                      src={
                        theme === "dark"
                          ? "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/chat%20app-darkmode.png"
                          : "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/chat%20app-daymode.png"
                      }
                      className="rounded-lg shadow-lg mt-5 relative z-10  md:min-h-[345px]"
                      alt="Files picture"
                      width={600}
                      height={600}
                    />
                  </FeaturedPic>
                </div>
                <div className="space-y-8 flex flex-col items-center md:items-end">
                  <div className="space-y-4">
                    {" "}
                    <span className="hidden md:block text-[#286efb] dark:text-[#A9C5FF] text-[16px] font-bold">
                      Feature
                    </span>
                    <h2 className="text-left  text-[1.6rem] md:text-5xl text-gray-900 mt-4 md:mt-0  dark:text-white !leading-[1.2]  font-inter font-[900]  ">
                      <span className="text-[#286efb] dark:text-[#A9C5FF]">
                        Streamline Sales
                      </span>{" "}
                      <br className="hidden sm:block" />
                      Pipeline with Ease
                    </h2>
                    <p className="text-left text-gray-600 dark:text-[#d7d7de] max-w-lg font-inter font-normal text-[16px] md:text-[18px]     ">
                      Track deals and manage your sales pipeline with instant
                      alerts and seamless integrations.
                    </p>
                  </div>

                  <div className="grid grid-cols-2 gap-6 max-w-[517px]">
                    {features2.map((feature, index) => (
                      <div key={index} className="md:space-y-1">
                        <div className="flex items-center gap-3">
                          <div className="w-4 h-4 rounded-lg flex items-center justify-center text-gray-600 dark:text-[#d7d7de]">
                            {feature.icon}
                          </div>
                          <h3 className="text-gray-900 dark:text-[#d7d7de] text-lg font-open-sauce font-black text-[1.16rem]  ">
                            {feature.title}
                          </h3>
                        </div>
                        <p className="text-gray-600 dark:text-[#d7d7de] text-[14px] leading-[20px] pl-[1.75rem] mt-0 font-inter font-normal">
                          {feature.description}
                        </p>
                      </div>
                    ))}

                    <div className="flex items-start gap-6 pt-4">
                      <div className="flex flex-row sm:flex-row sm:items-center gap-4">
                        <Button
                          onClick={() => {
                            window.location.replace(
                              "https://crm.clikkle.com/signup?theme=" + theme +
                              "&referralApp=" +
                              getEncodedReferrer()
                            );
                          }}
                          className="bg-[#286efb] hover:bg-[#3367d6] text-white px-8 py-3 h-[40px]"
                          style={{
                            boxShadow: `
          0px 0.25px 0.25px 0px rgba(0,0,0,0.24),
          0px 0.75px 0.75px 0px rgba(0,0,0,0.12),
          0px 1px 1.5px -0.5px rgba(0,0,0,0.12),
          0px 2px 4px -1px rgba(0,0,0,0.12),
          0px 4px 8px -4px rgba(0,0,0,0.12),
          0px 8px 12px -4px rgba(0,0,0,0.06)
        `,
                          }}
                        >
                          Get Started
                        </Button>
                      </div>

                      <div className="pl-4 rounded-lg text-gray-600 dark:text-[#d7d7de] font-light hidden md:block max-w-[280px]">
                        <p className="text-sm leading-relaxed font-inter w-60">
                          <span className="text-[#ff4b5c]">&rdquo;</span>
                          Organized and efficient — exactly what our sales team
                          needed.
                          <span className="text-[#ff4b5c]">&rdquo;</span>
                        </p>

                        <div className="flex items-center gap-3 mt-2">
                          <Image
                            src={emmar}
                            alt="Ava M."
                            width={24}
                            height={24}
                            className="w-6 h-6 rounded-full"
                          />
                          <div>
                            <p className="font-semibold text-sm">Emma R.</p>
                            <p className="text-xs text-gray-400">
                              Sales Director
                            </p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-[#1a1a1a]"
            id="features3-3"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center sm:gap-[8rem]">
                <div className="space-y-8 justify-self-start">
                  <div className="space-y-4">
                    {" "}
                    <span className="hidden md:block text-[#286efb] dark:text-[#A9C5FF] text-[16px] font-bold">
                      Feature
                    </span>
                    <h2 className="text-[1.6rem] md:text-5xl text-gray-900 mt-4 md:mt-0  dark:text-white !leading-[1.2]  font-inter font-[900]  ">
                      Custom Dashboards, <br className="hidden sm:block" />
                      <span className="text-[#286efb] dark:text-[#A9C5FF]">
                        Automated
                      </span>{" "}
                      Reporting
                    </h2>
                    <p className="text-gray-600 dark:text-[#d7d7de] max-w-lg font-inter font-normal text-[16px] md:text-[18px]     ">
                      Create custom sales dashboards, automate reports, and
                      collaborate in real time to boost productivity.
                    </p>
                  </div>

                  <div className="grid grid-cols-2 gap-6 max-w-[529px]">
                    {features3.map((feature, index) => (
                      <div key={index} className="md:space-y-1">
                        <div className="flex items-center gap-3">
                          <div className="w-4 h-4 rounded-lg flex items-center justify-center text-gray-600 dark:text-[#d7d7de]">
                            {feature.icon}
                          </div>
                          <h3 className="text-gray-900 dark:text-[#d7d7de] text-lg font-open-sauce font-black text-[1.16rem]  ">
                            {feature.title}
                          </h3>
                        </div>
                        <p className="text-gray-600 dark:text-[#d7d7de] text-[14px] leading-[20px] pl-[1.75rem] mt-0 font-inter font-normal">
                          {feature.description}
                        </p>
                      </div>
                    ))}
                  </div>
                  <div className="flex flex-row md:justify-start  gap-4 pt-4">
                    <Button
                      onClick={() => {
                        window.location.replace(
                          "https://crm.clikkle.com/signup?theme=" + theme +
                          "&referralApp=" +
                          getEncodedReferrer()
                        );
                      }}
                      className="bg-[#286efb] hover:bg-[#3367d6] text-white px-8 py-3 h-[40px]"
                    >
                      Get Started
                    </Button>
                    <div className="pl-4 rounded-lg text-gray-600 dark:text-[#d7d7de] font-light md:block hidden">
                      <p className="text-sm leading-relaxed font-inter">
                        <span className="text-[#ff4b5c]">&rdquo;</span>The best
                        CRM tool I&apos;ve used for sales analytics!
                        <span className="text-[#ff4b5c]">&rdquo;</span>
                      </p>
                      <div className="flex items-center gap-3 mt-[0.4rem]">
                        <Image
                          src={someee}
                          alt="Batu K."
                          width={24}
                          height={24}
                          className="w-6 h-6 rounded-full"
                        />
                        <div>
                          <p className="font-semibold text-sm">Liam S.</p>
                          <p className="text-xs text-gray-400">Sales Analyst</p>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px]  justify-center md:justify-end order-first lg:order-none">
                  <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <FeaturedPic>
                    <Image
                      src={
                        theme === "dark"
                          ? "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/chat%20app-darkmode.png"
                          : "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/chat%20app-daymode.png"
                      }
                      className="rounded-lg shadow-lg mt-5 relative z-10  md:min-h-[345px]"
                      alt="Files picture"
                      width={600}
                      height={600}
                    />
                  </FeaturedPic>
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-[#1a1a1a]"
            id="features4-4"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center">
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px]  justify-center md:justify-start order-first lg:order-first">
                  <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <FeaturedPic>
                    <Image
                      src={
                        theme === "dark"
                          ? "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/chat%20app-darkmode.png"
                          : "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/chat%20app-daymode.png"
                      }
                      className="rounded-lg shadow-lg mt-5 relative z-10  md:min-h-[345px]"
                      alt="Files picture"
                      width={600}
                      height={600}
                    />
                  </FeaturedPic>
                </div>
                <div className="space-y-8 flex flex-col items-center md:items-end">
                  <div className="space-y-4">
                    {" "}
                    <span className="hidden md:block text-[#286efb] dark:text-[#A9C5FF] text-[16px] font-bold">
                      Feature
                    </span>
                    <h2 className="text-left  text-[1.6rem] md:text-5xl text-gray-900 mt-4 md:mt-0  dark:text-white !leading-[1.2]  font-inter font-[900]  ">
                      <span className="text-[#286efb] dark:text-[#A9C5FF]">
                        Transform
                      </span>{" "}
                      Your Sales <br className="hidden sm:block" /> with Smart
                      CRM
                    </h2>
                    <p className="text-left text-gray-600 dark:text-[#d7d7de] max-w-lg font-inter font-normal text-[16px] md:text-[18px]     ">
                      Manage customers and track deals efficiently with smart,
                      collaborative CRM tools anywhere.
                    </p>
                  </div>

                  <div className="grid grid-cols-2 gap-6 max-w-[517px]">
                    {features4.map((feature, index) => (
                      <div key={index} className="md:space-y-1">
                        <div className="flex items-center gap-3">
                          <div className="w-4 h-4 rounded-lg flex items-center justify-center text-gray-600 dark:text-[#d7d7de]">
                            {feature.icon}
                          </div>
                          <h3 className="text-gray-900 dark:text-[#d7d7de] text-lg font-open-sauce font-black text-[1.16rem]  ">
                            {feature.title}
                          </h3>
                        </div>
                        <p className="text-gray-600 dark:text-[#d7d7de] text-[14px] leading-[20px] pl-[1.75rem] mt-0 font-inter font-normal">
                          {feature.description}
                        </p>
                      </div>
                    ))}
                    <div className="flex items-start gap-6 pt-4">
                      <div className="flex flex-row sm:flex-row sm:items-center gap-4">
                        <Button
                          onClick={() => {
                            window.location.replace(
                              "https://crm.clikkle.com/signup?theme=" + theme +
                              "&referralApp=" +
                              getEncodedReferrer()
                            );
                          }}
                          className="bg-[#286efb] hover:bg-[#3367d6] text-white px-8 py-3 h-[40px]"
                          style={{
                            boxShadow: `
          0px 0.25px 0.25px 0px rgba(0,0,0,0.24),
          0px 0.75px 0.75px 0px rgba(0,0,0,0.12),
          0px 1px 1.5px -0.5px rgba(0,0,0,0.12),
          0px 2px 4px -1px rgba(0,0,0,0.12),
          0px 4px 8px -4px rgba(0,0,0,0.12),
          0px 8px 12px -4px rgba(0,0,0,0.06)
        `,
                          }}
                        >
                          Get Started
                        </Button>
                      </div>

                      <div className="pl-4 rounded-lg text-gray-600 dark:text-[#d7d7de] font-light hidden md:block max-w-[280px]">
                        <p className="text-sm leading-relaxed font-inter w-60">
                          <span className="text-[#ff4b5c]">&rdquo;</span>
                          Quick setup and our team was productive immediately!
                          <span className="text-[#ff4b5c]">&rdquo;</span>
                        </p>

                        <div className="flex items-center gap-3 mt-2">
                          <Image
                            src={sarah}
                            alt="Ava M."
                            width={24}
                            height={24}
                            className="w-6 h-6 rounded-full"
                          />
                          <div>
                            <p className="font-semibold text-sm">Ava M.</p>
                            <p className="text-xs text-gray-400">
                              Sales Manager
                            </p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <AppsSection />
        </section>

        <section className="w-full min-h-[510px]">
          <div className="bg-white dark:bg-[#1a1a1a] py-12 md:py-32 px-4 md:px-0">
            <div className="max-w-3xl mx-auto text-center flex flex-col justify-center items-center">
              <h2 className="text-[34px] md:text-5xl  font-inter leading-[48px]  [text-stroke:1px_#000] font-bold  text-gray-900 dark:text-white text-center">
                See what our <br className="hidden sm:block" />
                <span className="text-[#286efb] dark:text-[#a9c5ff]  [text-stroke:1px_#000] font-bold">
                  customers
                </span>{" "}
                are saying
              </h2>
              <p className="mt-4 text-gray-600 dark:text-gray-300 text-sm md:text-base font-inter font-normal text-[14px] leading-[20px] tracking-[0em] text-center max-w-[508px]">
                Don&apos;t just take our word for it. See what our valued
                customers have to say about their experience with our platform
                and how it has transformed their sales operations.
              </p>
            </div>

            <div className="max-w-2xl mx-auto mt-8 md:px-0">
              <div className="flex justify-center space-x-1">
                {Array(5)
                  .fill(0)
                  .map((_, i) => (
                    <FaStar key={i} className="text-yellow-400" />
                  ))}
              </div>

              <div className="mt-6 flex items-center justify-center">
                <button
                  onClick={prev}
                  className="cursor-pointer p-2 md:p-4 rounded-full border border-gray-300 dark:border-gray-500"
                >
                  <IoIosArrowBack
                    size={18}
                    className="text-gray-900 dark:text-white"
                  />
                </button>

                <p className="mx-4 md:mx-8 text-gray-900 dark:text-white text-sm md:text-lg font-inter font-normal md:font-medium text-[24px] leading-[23px] md:leading-[25px]   text-center md:min-w-[700px]">
                  {text}
                </p>

                <button
                  onClick={next}
                  className="cursor-pointer p-2 md:p-4 rounded-full border border-gray-300 dark:border-gray-500"
                >
                  <IoIosArrowForward
                    size={18}
                    className="text-gray-900 dark:text-white"
                  />
                </button>
              </div>

              <div className="mt-4 text-center text-sm text-gray-600 dark:text-gray-400">
                <span className="text-red-500">*</span>
                {recommendNote}
              </div>

              <div className="mt-6 flex flex-col items-center">
                <Image
                  src={logo}
                  alt="Company Logo"
                  className="h-16 w-16 rounded-full object-cover"
                  width={64}
                  height={64}
                />
                <p className="mt-2 font-medium text-gray-900 dark:text-white">
                  {name}
                </p>
                <p className="text-gray-600 dark:text-gray-400 text-sm">
                  {title}
                </p>
                <p className="text-gray-500 dark:text-gray-500 text-xs mt-1">
                  {date}
                </p>
              </div>
            </div>
          </div>
        </section>

        <section className="w-full" id="moreInfo">
          <section
            className="relative py-16 bg-white dark:bg-[#1a1a1a] overflow-hidden"
            id="pricing"
          >
            <div className="container mx-auto px-4 py-12">
              <div className="flex flex-col md:flex-row items-center justify-center gap-12 md:gap-24">
                <div className="relative w-full md:w-auto flex justify-center">
                  <Image
                    src="/images/free-dog.png"
                    alt="Free forever"
                    width={400}
                    height={400}
                    className="object-contain max-w-[200px] md:max-w-[300px]"
                  />
                </div>

                <div className="w-full md:w-auto text-center md:text-start mx-auto md:mx-0">
                  <h2 className="text-4xl md:text-5xl font-bold text-gray-900 dark:text-white mb-6">
                    Free forever!
                  </h2>
                  <div className="w-full md:w-auto flex justify-center items-center md:block">
                    <ul className="space-y-3 mb-6 text-start">
                      {[
                        "Unlimited Users",
                        "Unlimited Contacts",
                        "Unlimited Lists",
                      ].map((item, index) => (
                        <li
                          key={index}
                          className="flex items-center justify-start text-lg text-gray-700 dark:text-gray-300"
                        >
                          <svg
                            className="w-5 h-5 text-blue-500 mr-3 flex-shrink-0"
                            fill="none"
                            stroke="currentColor"
                            viewBox="0 0 24 24"
                          >
                            <path
                              strokeLinecap="round"
                              strokeLinejoin="round"
                              strokeWidth="2"
                              d="M5 13l4 4L19 7"
                            />
                          </svg>
                          {item}
                        </li>
                      ))}
                    </ul>
                  </div>

                  <Link
                    href="https://clikkle.com/offers/crm"
                    className="text-blue-500 hover:text-blue-600 font-medium inline-flex items-center text-lg transition-colors group"
                  >
                    See upgrades
                    <span className="ml-2 transform group-hover:translate-x-1 transition-transform">
                      <ArrowRightIcon className="w-5 h-5" />
                    </span>
                  </Link>
                  <br />
                  <Button
                    onClick={() => {
                      window.location.replace(
                        "https://crm.clikkle.com/signup?theme=" + theme +
                        "&referralApp=" +
                        getEncodedReferrer()
                      );
                    }}
                    className="bg-[#286efb] hover:bg-[#3367d6] text-white px-8 py-3 h-[40px] mt-4"
                  >
                    Try for free
                  </Button>
                </div>
              </div>
            </div>
          </section>
        </section>
        <section className="w-full">
          <section className="w-full py-20 md:py-32 bg-white dark:bg-[#1a1a1a]">
            <div className="container max-w-[694px] mx-auto px-4  text-center">
              <span className="text-gray-900 dark:text-white text-center font-bold text-sm">
                FAQS SECTION
              </span>
              <div className="text-center mb-24 mt-8">
                <h2 className="text-[32px]  [text-stroke:1px_#000] font-boldmd:text-5xl font-medium text-gray-900 dark:text-white mb-6 font-paragraph-inter-m-regular">
                  Frequently Asked Questions
                </h2>
              </div>
              <div className="space-y-4 border border-gray-300 dark:border-[#5e5e69] rounded-xl overflow-hidden transition-colors bg-gray-100 dark:bg-[#141414] p-2">
                {faqs.map((faq, index) => {
                  const isOpen = openFAQ === index;
                  return (
                    <React.Fragment key={index}>
                      <div
                        className={`rounded-xl overflow-hidden transition-colors !mt-[0px] ${isOpen
                            ? "bg-white dark:bg-[#1a1a1a]"
                            : "bg-gray-100 dark:bg-[#141414]"
                          }`}
                      >
                        <button
                          className="w-full px-4 py-5 text-left flex items-center justify-between hover:bg-white dark:hover:bg-[#1a1a1a] transition-colors"
                          onClick={() => setOpenFAQ(isOpen ? null : index)}
                        >
                          <h3 className="text-lg font-[400] text-gray-900 dark:text-white pr-4">
                            {faq.question}
                          </h3>
                          <ArrowDown
                            className={`w-6 h-6 text-black bg-gray-300 dark:bg-[#d7d7de] rounded-full p-1 font-bold transition-transform ${isOpen ? "rotate-180" : ""
                              }`}
                          />
                        </button>

                        {isOpen && (
                          <div className="pr-8 pl-4 pb-6">
                            <p className="text-[#51515E] dark:text-[#EEEEF0] text-start font-[300] text-md">
                              {faq.answer}
                            </p>
                          </div>
                        )}
                      </div>
                      {index < 4 && (
                        <hr className="h-px bg-gray-300 dark:bg-[#5e5e69] border-0 !m-[5px]" />
                      )}
                    </React.Fragment>
                  );
                })}
              </div>
            </div>
          </section>
        </section>
        <section className="w-full flex justify-center items-center">
          <div className="bg-[#edeef1] dark:bg-[#141414] p-10 md:pt-10 pt-16 rounded-[20px] border-2 border-dashed border-gray-300 dark:border-[#575662] my-24 mx-[1.2rem] md:mx-[50px] md:max-w-[1062px] relative overflow-hidden md:overflow-visible">
            <div className="flex flex-col-reverse md:flex-row items-center md:items-start h-full">
              <div className="w-full text-center md:text-left flex flex-col justify-between gap-4 h-full md:w-[1062px] pt-36 md:pt-0">
                <div>
                  <h2 className="!text-[30px] md:!text-[55px] leading-none font-bold text-gray-900 dark:text-white">
                    Streamlined{" "}
                    <span className="text-[#286efb] dark:text-[#a9c5ff]">
                      Customer
                    </span>
                  </h2>
                  <h3 className="!text-[30px] md:!text-[55px] font-bold text-gray-900 dark:text-white leading-tight">
                    Relationship Management
                  </h3>
                </div>

                <p className="mt-4 text-gray-600 dark:text-gray-300 text-base md:text-lg">
                  Manage customers and close deals efficiently, with advanced
                  features and <br className="hidden sm:block" />
                  sales automation. Build stronger relationships, anywhere,
                  anytime
                </p>

                <div className="mt-6 w-full max-w-xl flex flex-col items-center md:items-start gap-4">
                  <div className="flex flex-col sm:flex-row items-center sm:items-stretch gap-3 w-full">
                    <input
                      type="email"
                      placeholder="Enter Your Email"
                      className="flex-1 px-4 py-3 rounded-lg bg-white text-gray-900 placeholder-gray-500 dark:placeholder-gray-400 focus:outline-none w-full border border-gray-300 dark:border-[#575662] shadow-sm dark:shadow-none"
                    />
                    <button
                      onClick={() => {
                        window.location.replace(
                          "https://crm.clikkle.com/signup?theme=" + theme +
                          "&referralApp=" +
                          getEncodedReferrer()
                        );
                      }}
                      className="cursor-pointer px-6 py-3 bg-black dark:bg-[#286efb] text-white font-medium rounded-lg transition w-full sm:w-auto"
                    >
                      Get Started for Free
                    </button>
                  </div>

                  <div className="flex items-start gap-2 text-sm text-gray-600 dark:text-gray-300">
                    <label className="relative flex items-center cursor-pointer">
                      <input
                        type="checkbox"
                        id="terms"
                        defaultChecked
                        className="peer appearance-none h-4 w-4 border-2 border-blue-500 rounded-full bg-white dark:bg-gray-800 checked:bg-[#286efb] checked:border-blue-500 checked:ring-2 checked:ring-blue-300 transition duration-200"
                      />
                      <span className="absolute left-0 top-0 h-4 w-4 flex items-center justify-center pointer-events-none peer-checked:before:content-['✓'] peer-checked:before:text-white peer-checked:before:text-sm peer-checked:before:font-bold"></span>
                    </label>

                    <span className="ml-1 leading-5">
                      I agree with the{" "}
                      <Link
                        href="/terms-of-service"
                        className="underline text-gray-900 dark:text-gray-100 hover:text-[#51515E] dark:hover:text-white"
                        target="_blank"
                        rel="noopener noreferrer"
                      >
                        Terms and Conditions
                      </Link>
                    </span>
                  </div>
                </div>
              </div>

              <div className="w-full md:w-1/2 md:h-full md:self-end flex md:justify-end md:items-end justify-center items-center relative">
                <Image
                  src={theme === "dark" ? ctaBlack : ctaimage}
                  alt="CRM Illustration"
                  className="w-[11.5rem] sm:w-[13rem] md:w-[340px] absolute left-1/2 md:left-auto top-[-48px] md:top-auto md:bottom-[-42px] md:right-[-35px] -translate-x-1/2 md:translate-x-0 z-10 pointer-events-none"
                />
              </div>
            </div>
          </div>
        </section>
      </div>

      <footer className="w-full">
        <footer className="w-full bg-white dark:bg-[#1a1a1a] border-t border-gray-300 dark:border-[#9c989c] pt-6 md:pt-16">
          <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 mx-auto px-4">
            <div className="flex flex-col md:flex-row justify-between gap-12">
              <div className="space-y-12">
                {/* <Link href="/">
                  <div className="flex items-center justify-start md:w-[245px] w-auto">
                    <Image
                      className="h-[32px] md:h-[40px] w-auto"
                      alt="Clikkle Crm logo"
                      width={114}
                      height={40}
                      src={
                        isDarkMode
                          ? "https://cdn.clikkle.com/images/crm/2025/Clikkle%20crm%20Blue%20(%20White%20Text).png"
                          : "https://cdn.clikkle.com/images/crm/2025/Clikkle%20crm%20Blue%20(%20Black%20Text).png"
                      }
                    />
                  </div>
                </Link> */}
                <ClikkleLogo />
                <div className="max-w-[285px] space-y-1 md:space-y-2 mt-[48px]">
                  <h3 className="font-instrument-sans font-medium text-[18px] leading-[20px] tracking-[0em] font-headline-small text-gray-900 dark:text-[#eeeef0]">
                    Get Started For Free
                  </h3>
                  <p className="font-body-medium text-[#51515E] dark:text-[#eeeef0] text-[length:var(--body-medium-font-size)] tracking-[var(--body-medium-letter-spacing)] leading-[var(--body-medium-line-height)]">
                    Transform your customer management with our CRM platform.
                    Streamlined sales for all teams
                  </p>
                </div>
              </div>

              <div className="flex flex-nowrap justify-between gap-y-8 space-x-2 min-[340px]:space-x-5 md:space-x-14 mt-4 text-[10px] min-[360px]:text-xs sm:text-sm overflow-hidden">
                {footerColumns.map((column, index) => (
                  <div key={`column-${index}`} className="flex flex-col gap-5">
                    <h4 className="font-label-medium text-gray-900 dark:text-white text-[length:var(--label-medium-font-size)] tracking-[var(--label-medium-letter-spacing)] leading-[var(--label-medium-line-height)]">
                      {column.title}
                    </h4>
                    <ul className="flex flex-col gap-4">
                      {column.links.map((link, linkIndex) => (
                        <li key={`link-${index}-${linkIndex}`}>
                          <div className="flex items-start gap-3">
                            <Link
                              href={link.url}
                              target={
                                link.url.startsWith("http") ? "_blank" : "_self"
                              }
                              rel={
                                link.url.startsWith("http")
                                  ? "noopener noreferrer"
                                  : undefined
                              }
                              className="font-body-medium text-[#51515E] dark:text-[#d7d7de] text-[length:var(--body-medium-font-size)] tracking-[var(--body-medium-letter-spacing)] leading-[var(--body-medium-line-height)] whitespace-nowrap hover:text-gray-900 dark:hover:text-white transition-colors"
                            >
                              <span className="flex justify-center items-center gap-2">
                                {link.text}{" "}
                                {column.title === "Social" && (
                                  <FaArrowRight className="w-2 h-2 text-[#51515E] dark:text-[#d7d7de]" />
                                )}
                              </span>
                            </Link>
                            {link.isNew && (
                              <div className="hidden md:flex items-center gap-2 ">
                                <div className="relative w-4 h-4">
                                  <div className="relative w-[13px] h-[13px] top-px left-px bg-[#c3e6ff] rounded-[6.67px]">
                                    <div className="relative w-1 h-1 top-[5px] left-[5px] bg-[#286efb] rounded-sm" />
                                  </div>
                                </div>
                                <span className="font-body-medium text-gray-900 dark:text-white text-[length:var(--body-medium-font-size)] tracking-[var(--body-medium-letter-spacing)] leading-[var(--body-medium-line-height)] whitespace-nowrap">
                                  New
                                </span>
                              </div>
                            )}
                          </div>
                        </li>
                      ))}
                    </ul>
                  </div>
                ))}
              </div>
            </div>
          </div>

          <div className="w-full h-10 bg-gray-100 dark:bg-[#141414] mt-12 flex items-center justify-center">
            <p className="font-body-small text-gray-900 dark:text-white text-[length:var(--body-small-font-size)] tracking-[var(--body-small-letter-spacing)] leading-[var(--body-small-line-height)]">
              ©{new Date().getFullYear()} Clikkle All Rights Reserved.
            </p>
          </div>
        </footer>
      </footer>
      <SidebarDrawer open={leftDrawerOpen} toggle={toggleLeftDrawer} />
    </div>
  );
};

export default CrmHome;
