"use client";
import React, { useEffect, useRef, useState } from "react";
import {
  Mail,
  Phone,
  MapPin,
  ArrowRight,
  MessageSquare,
  Users,
  Newspaper,
  ArrowRightIcon,
  Logs,
  Ellipsis,
  Send,
} from "lucide-react";
import { useTheme } from "../atoms/theme";
import AnnouncementBar from "../components/AnnouncementBar";
import Link from "next/link";
import Image from "next/image";
import SidebarDrawer from "../components/sidebarDrawer";
import { footerColumns } from "../constants/footerText";
import {
  FaArrowRight,
  FaLinkedin,
  FaInstagram,
  FaFacebook,
  FaYoutube,
} from "react-icons/fa";
import { getCookie } from "../utils/cookies";
import { apps } from "../constants/products";
import { Button } from "../components/button";
import illustration from "../../public/images/banner.png";
import ThemeSwitch from "../components/themeSwitch";
import { motion, AnimatePresence } from "framer-motion";
import Footer from "@/components/Footer";
import ClikkleLogo from "@/components/ClikkleLogo";
import { getEncodedReferrer } from "@/utils/utils";

const Contact: React.FC = () => {
  const [leftDrawerOpen, setLeftDrawerOpen] = useState(false);
  const toggleLeftDrawer = () => setLeftDrawerOpen((prev) => !prev);
  const { theme } = useTheme();

  const [productsOpen, setProductsOpen] = useState(false);
  const [dotsOpen, setDotsOpen] = useState(false);
  const productsRef = useRef<HTMLDivElement>(null);
  const dotsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (
        productsRef.current &&
        !productsRef.current.contains(event.target as Node)
      ) {
        setProductsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (dotsRef.current && !dotsRef.current.contains(event.target as Node)) {
        setDotsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);
  const [scrolled, setScrolled] = useState(false);
  useEffect(() => {
    const handleScroll = () => {
      setScrolled(window.scrollY > 0);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);
  const [announcementOpen, setAnnouncementOpen] = useState(false);

  useEffect(() => {
    const checkHeight = () => {
      const el = document.querySelector("[data-announcement]") as HTMLElement;
      if (el && el.offsetHeight > 0) {
        setAnnouncementOpen(true);
      } else {
        setAnnouncementOpen(false);
      }
    };
    checkHeight();
    const observer = new MutationObserver(checkHeight);
    observer.observe(document.body, { childList: true, subtree: true });
    return () => observer.disconnect();
  }, []);
  const [subject, setSubject] = useState<string>("General Inquiry");
  const [fullName, setFullName] = useState<string>("");
  const [email, setEmail] = useState<string>("");
  const [phone, setPhone] = useState<string>("");
  const [message, setMessage] = useState<string>("");
  const [submitting, setSubmitting] = useState<boolean>(false);
  const [submitError, setSubmitError] = useState<string>("");

  const messages = [
    "How can we help you?",
    "Request a demo for Worksuite",
    "Ask about pricing for your team",
    "Report an issue or bug",
    "Media & press inquiry",

    "I can't log into my Worksuite dashboard",
    "How do I reset my account password?",
    "My team is not receiving email notifications",
    "How can I upgrade my subscription plan?",
    "How do I add more users to my organization?",

    "How can I export reports from Worksuite?",
    "Error uploading files in Projects",
    "How do I customize company branding settings?",
    "Where can I download the mobile app?",
    "My invoices are not generating properly",

    "How can I integrate Clikkle Chat with other tools?",
    "Why am I not receiving verification emails?",
    "How do I set up payment gateways in Store?",
    "How do I invite new team members?",
    "How can I submit feedback or feature requests?",
  ];

  const [msgIndex, setMsgIndex] = useState(0);
  const [msg, setMsg] = useState(messages[0]);
  const [placeholderPaused, setPlaceholderPaused] = useState(false);
  const [messageValue, setMessageValue] = useState("");
  const [focused, setFocused] = useState(false);
  useEffect(() => {
    if (placeholderPaused) return;
    const id = setInterval(() => {
      setMsgIndex((i) => (i + 1) % messages.length);
    }, 2000);
    return () => clearInterval(id);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [placeholderPaused]);
  useEffect(() => {
    setMsg(messages[msgIndex]);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [msgIndex]);

  useEffect(() => {
    const checkDismissedAnnouncements = () => {
      const dismissed = getCookie("dismissedAnnouncements");
      if (dismissed) {
        try {
          const dismissedIds = JSON.parse(dismissed);
          if (dismissedIds.length > 0) {
            setAnnouncementOpen(false);
          }
        } catch (error) {
          console.error("Error parsing dismissed announcements:", error);
        }
      }
    };

    checkDismissedAnnouncements();

    const interval = setInterval(checkDismissedAnnouncements, 1000);

    return () => clearInterval(interval);
  }, []);
  const tryOpenChat = () => {
    const chatBtn = document.querySelector(
      'button[title="Open chat"]'
    ) as HTMLButtonElement;
    if (chatBtn) {
      chatBtn.click();
    } else {
      setTimeout(tryOpenChat, 500);
    }
  };
  return (
    <div className={`min-h-screen bg-white dark:bg-[#1a1a1a] mx-auto`}>
      <section className="w-full">
        <section className="relative w-full h-28 overflow-hidden">
          <div
            className={`fixed top-0 inset-x-0 z-50 ${
              scrolled
                ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1a1a]/90"
                : productsOpen || dotsOpen
                ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1a1a]/90"
                : ""
            }`}
          >
            <div
              ref={(el) => {
                if (el) {
                  const height = el.getBoundingClientRect().height;

                  if (height !== 0) {
                    setAnnouncementOpen(true);
                  }
                }
              }}
            >
              <AnnouncementBar onClose={() => setAnnouncementOpen(false)} />
            </div>
            <div className="container max-w-[1233px] mx-auto max-[1300px]:px-14 max-[1100px]:px-4">
              <nav
                className={`relative flex items-center justify-between py-4`}
              >
                <ClikkleLogo />

                <div className="flex md:hidden items-center">
                  <div
                    className="flex items-center gap-0 rounded-xl border border-gray-300 dark:border-[#ffffff3a] p-[8px] shadow-sm"
                    onClick={toggleLeftDrawer}
                  >
                    <p className="text-sm font-medium text-gray-900 dark:text-white">
                      <Logs className="w-5 h-5 text-gray-900 dark:text-white mr-3" />
                    </p>

                    <p className="flex items-center  rounded-xl text-sm font-bold ">
                      Menu
                    </p>
                  </div>
                </div>

                <div className="hidden md:flex items-center gap-12 font-inter font-medium text-[18px]">
                  <Link
                    href="https://clikkle.com#features"
                    className="text-gray-900 dark:text-white hover:text-gray-900 dark:hover:text-[#d7d7de] transition-colors"
                  >
                    Features
                  </Link>
                  <Link
                    href="https://clikkle.com/#pricing"
                    className="text-gray-900 dark:text-white hover:text-gray-900 dark:hover:text-[#d7d7de] transition-colors"
                  >
                    Pricing
                  </Link>
                  <Link
                    href="/blogs"
                    className="text-gray-900 dark:text-white hover:text-gray-900 dark:hover:text-[#d7d7de] transition-colors"
                  >
                    Blog
                  </Link>
                  <div className="flex flex-row justify-center items-center">
                    <div className="relative" ref={productsRef}>
                      <button
                        onClick={() => setProductsOpen((o) => !o)}
                        className="cursor-pointer flex items-center gap-1 text-gray-900 dark:text-white hover:text-gray-900 dark:hover:text-[#d7d7de] transition-colors"
                      >
                        Products
                      </button>
                      {productsOpen && (
                        <div
                          className={`fixed $${
                            announcementOpen ? "top-[115px]" : "top-[75px]"
                          } 
              left-1/2 transform -translate-x-1/2 w-full bg-white dark:bg-[#1a1a1a] 
              shadow-lg p-6 border-b-2 border-gray-300 dark:border-[#575662] z-50 flex justify-center items-center pb-0`}
                        >
                          <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                       <div className="flex flex-col gap-3">
                              {apps
                                .slice(0, Math.ceil(apps.length / 2))
                                .map((product) => (
                                  <Link
                                    key={product.id}
                                    href={product.route}
                                    className="flex items-center gap-4 p-[0.35rem] rounded-lg hover:bg-gray-100 dark:hover:bg-white/10 transition"
                                  >
                                    <div>
                                      <Image
                                        src={product.image}
                                        alt={product.title}
                                        className="w-[26px]"
                                        width={26}
                                        height={26}
                                      />
                                    </div>
                                    <div>
                                      <p className="font-bold text-gray-900 dark:text-white text-sm">
                                        {product.title}
                                      </p>
                                      <p className="text-xs text-gray-600 dark:text-gray-300">
                                        {product.description}
                                      </p>
                                    </div>
                                  </Link>
                                ))}
                            </div>

                            <div className="flex flex-col gap-3">
                              {apps
                                .slice(
                                  Math.ceil(apps.length / 2),
                                  Math.ceil(apps.length / 2) + 2,
                                )
                                .map((product) => (
                                  <Link
                                    key={product.id}
                                    href={product.route}
                                    className="flex items-center gap-4 p-[0.35rem] rounded-lg hover:bg-gray-100 dark:hover:bg-white/10 transition"
                                  >
                                    <div>
                                      <Image
                                        src={product.image}
                                        alt={product.title}
                                        className="w-[26px]"
                                        width={26}
                                        height={26}
                                      />
                                    </div>
                                    <div>
                                      <p className="font-bold text-gray-900 dark:text-white text-sm">
                                        {product.title}
                                      </p>
                                      <p className="text-xs text-gray-600 dark:text-gray-300">
                                        {product.description}
                                      </p>
                                    </div>
                                  </Link>
                                ))}
                              <Link href="/products">
                                <Button
                                  style={{ marginTop: "5px" }}
                                  variant="ghost"
                                  className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                >
                                  View all products
                                  <ArrowRightIcon className="h-2 w-2 dark:text-white" />
                                </Button>
                              </Link>
                            </div>
                            <div className="hidden lg:flex flex-row items-center justify-center text-center gap-3">
                              <Image
                                src={illustration}
                                alt="Illustration"
                                className="w-auto h-[175px]"
                                width={400}
                                height={175}
                              />
                              <div className="flex flex-col justify-center items-center h-full">
                                <p className="text-sm text-gray-700 dark:text-gray-100 max-w-[200px] pb-5">
                                  Get started today the modern solution to power
                                  your business.
                                </p>
                                <Button
                                  variant="ghost"
                                  onClick={() => {
                                    window.location.replace(
                                      `https://worksuite.clikkle.com/signup?theme=${theme}&referralApp=${getEncodedReferrer()}`
                                    );
                                  }}
                                  className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                >
                                  Get Started Today
                                  <ArrowRightIcon
                                    className={`h-2 w-2 dark:text-white`}
                                  />
                                </Button>
                              </div>
                            </div>
                          </div>
                        </div>
                      )}
                    </div>

                    <div className="relative" ref={dotsRef}>
                      <Ellipsis
                        onClick={() => setDotsOpen((o) => !o)}
                        className="w-8 h-6 rounded-full p-[1px] cursor-pointer"
                      />
                      {dotsOpen && (
                        <div
                          className={`fixed ${
                            announcementOpen ? "top-[115px]" : "top-[75px]"
                          }  left-1/2 transform -translate-x-1/2 w-full 
    bg-white dark:bg-[#1a1a1a] 
    shadow-lg border-b-2 border-gray-300 dark:border-[#575662] 
    z-50 flex justify-center`}
                        >
                          <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 py-6">
                            <div className="flex flex-col md:flex-row justify-between items-start gap-12">
                              <div className="space-y-12">
                                <div className="max-w-[285px] space-y-2 mb-0">
                                  <h3 className="font-instrument-sans font-medium text-[18px] leading-[20px] text-gray-900 dark:text-[#eeeef0]">
                                    Get Started For Free
                                  </h3>
                                  <p className="font-body-medium text-[#51515E] dark:text-[#eeeef0]">
                                    Streamline your Business with our Apps.
                                    Effortlessly for every team.
                                  </p>
                                </div>
                                <Button
                                  style={{ marginTop: "20px" }}
                                  variant="ghost"
                                  onClick={() => {
                                    window.location.replace(
                                      `https://worksuite.clikkle.com/signup?theme=${theme}&referralApp=${getEncodedReferrer()}`
                                    );
                                  }}
                                  className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                >
                                  See How It Works
                                  <ArrowRightIcon
                                    className={`h-2 w-2 dark:text-white`}
                                  />
                                </Button>
                              </div>

                              <div className="flex flex-wrap gap-x-14 gap-y-8 text-xs sm:text-sm">
                                {footerColumns.map((column, index) => (
                                  <div
                                    key={index}
                                    className="flex flex-col gap-5"
                                  >
                                    <h4 className="font-label-medium text-gray-900 dark:text-white">
                                      {column.title}
                                    </h4>
                                    <ul className="flex flex-col gap-4">
                                      {column.links.map((link, linkIndex) => (
                                        <li key={linkIndex}>
                                          <div className="flex items-start gap-3">
                                            <Link
                                              href={link.url}
                                              target={
                                                link.url.startsWith("http")
                                                  ? "_blank"
                                                  : "_self"
                                              }
                                              rel={
                                                link.url.startsWith("http")
                                                  ? "noopener noreferrer"
                                                  : undefined
                                              }
                                              className="font-body-medium text-[#51515E] dark:text-[#d7d7de] hover:text-gray-900 dark:hover:text-white transition-colors whitespace-nowrap flex items-center gap-2"
                                            >
                                              {link.text}
                                              {column.title === "Social" && (
                                                <FaArrowRight className="w-2 h-2" />
                                              )}
                                            </Link>

                                            {link.isNew && (
                                              <div className="hidden md:flex items-center gap-2">
                                                <div className="w-4 h-4 flex items-center justify-center">
                                                  <div className="w-[13px] h-[13px] bg-[#c3e6ff] rounded-[6.67px] flex items-center justify-center">
                                                    <div className="w-1 h-1 bg-[#286efb] rounded-sm" />
                                                  </div>
                                                </div>
                                                <span className="font-body-medium text-gray-900 dark:text-white whitespace-nowrap">
                                                  New
                                                </span>
                                              </div>
                                            )}
                                          </div>
                                        </li>
                                      ))}
                                    </ul>
                                  </div>
                                ))}
                              </div>
                            </div>
                          </div>
                        </div>
                      )}
                    </div>
                  </div>
                </div>

                <div className="hidden md:flex items-center gap-4">
                  <div className="hidden md:flex items-center gap-4">
                    <div className="w-6">
                      <ThemeSwitch />
                    </div>
                    <div className="flex items-center gap-2 rounded-xl border border-gray-300 dark:border-[#ffffff3a] p-1 shadow-sm">
                      <button
                        className="cursor-pointer px-3 py-1 text-sm font-medium text-gray-900 dark:text-white"
                        onClick={() => {
                          window.location.replace(
                            `https://worksuite.clikkle.com/login?theme=${theme}&referralApp=${getEncodedReferrer()}`
                          );
                        }}
                      >
                        Login
                      </button>

                      <button
                        className="cursor-pointer flex items-center gap-1 rounded-xl bg-[#286efb] hover:bg-[#3367d6] px-4 py-1.5 text-sm font-medium text-white transition"
                        onClick={() => {
                          window.location.replace(
                            `https://worksuite.clikkle.com/signup?theme=${theme}&referralApp=${getEncodedReferrer()}`
                          );
                        }}
                      >
                        Try for free
                        <span>
                          <ArrowRightIcon className="w-4" />
                        </span>
                      </button>
                    </div>
                  </div>
                </div>
              </nav>
            </div>
          </div>
        </section>
      </section>
      <div className="relative pb-20 max-w-[1233px] mx-auto">
        <div className="container mx-auto md:px-0 px-4">
          <div
            className={`max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 ${
              announcementOpen ? "pt-6" : ""
            } py-16 pt-4`}
          >
            <div className="text-center">
              <h1
                className={`text-4xl md:text-5xl font-bold text-[#286efb] dark:text-[#A9C5FF] mb-4`}
              >
                Contact us
              </h1>
              <p
                className={`text-xl ${
                  theme === "dark" ? "text-gray-300" : "text-gray-600"
                } max-w-3xl mx-auto`}
              >
                Have a question or need assistance? Start a chat, open a support
                ticket, or send us a message and our team will be happy to help.
              </p>
            </div>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-3 gap-6 mb-16">
            <div className="rounded-2xl bg-[#edeef1] dark:bg-[#141414] border-2 border-dashed border-gray-300 dark:border-[#575662] p-6 flex flex-col items-center justify-center">
              <div className="mx-auto flex h-12 w-12 items-center justify-center rounded-xl border-2 border-dashed border-gray-300 dark:border-[#575662] bg-white dark:bg-[#1a1a1a]">
                <Users className="h-6 w-6" />
              </div>
              <h3 className="mt-4 text-lg font-semibold">Help & Support</h3>
              <p className="mt-2 text-sm opacity-80 text-center">
                Get assistance with setup, features, or troubleshooting.
              </p>
              <Button
                onClick={() => {
                  tryOpenChat();
                }}
                className="cursor-pointer mt-5 inline-flex bg-[#286efb] hover:bg-[#3367d6] text-white items-center gap-2 rounded-xl px-4 py-2 text-sm"
              >
                Contact support <ArrowRight className="h-4 w-4" />
              </Button>
            </div>
            <div className="rounded-2xl bg-[#edeef1] dark:bg-[#141414] border-2 border-dashed border-gray-300 dark:border-[#575662] p-6 flex flex-col items-center justify-center">
              <div className="mx-auto flex h-12 w-12 items-center justify-center rounded-xl border-2 border-dashed border-gray-300 dark:border-[#575662] bg-white dark:bg-[#1a1a1a]">
                <MessageSquare className="h-6 w-6" />
              </div>

              <h3 className="mt-4 text-lg font-semibold">
                Create or Manage Tickets
              </h3>

              <p className="mt-2 text-sm opacity-80 text-center">
                Submit a new support request or track the status of your
                existing tickets.
              </p>

              <Button
                onClick={() => {
                  window.location.replace(
                    "https://support.clikkle.com/?category=Tickets"
                  );
                }}
                className="cursor-pointer mt-5 inline-flex bg-[#286efb] hover:bg-[#3367d6] text-white items-center gap-2 rounded-xl px-4 py-2 text-sm"
              >
                Open Support Portal <ArrowRight className="h-4 w-4" />
              </Button>
            </div>

            <div className="rounded-2xl bg-[#edeef1] dark:bg-[#141414] border-2 border-dashed border-gray-300 dark:border-[#575662] p-6 flex flex-col items-center justify-center">
              <div className="mx-auto flex h-12 w-12 items-center justify-center rounded-xl border-2 border-dashed border-gray-300 dark:border-[#575662] bg-white dark:bg-[#1a1a1a]">
                <Newspaper className="h-6 w-6" />
              </div>
              <h3 className="mt-4 text-lg font-semibold">Knowledge Base</h3>
              <p className="mt-2 text-sm opacity-80 text-center">
                Find answers to common questions and learn how to use Clikkle.
              </p>
              <Button
                onClick={() => {
                  window.location.replace(
                    "https://support.clikkle.com/?category=Knowledge"
                  );
                }}
                className="cursor-pointer mt-5 inline-flex bg-[#286efb] hover:bg-[#3367d6] text-white items-center gap-2 rounded-xl px-4 py-2 text-sm"
              >
                Knowledge base <ArrowRight className="h-4 w-4" />
              </Button>
            </div>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 gap-8 items-start ">
            <div className="flex flex-col justify-between rounded-2xl h-full bg-[#edeef1] dark:bg-[#141414] border-2 border-dashed border-gray-300 dark:border-[#575662] p-8">
              <div>
                <h2 className="text-2xl font-semibold bg-[#edeef1] dark:bg-[#141414]">
                  Contact Information
                </h2>
                <p className="mt-2 text-sm opacity-80">
                  Help when you need it — our support portal and team are here.
                </p>
                <div className="mt-10 space-y-4 ">
                  <p
                    onClick={() => {
                      tryOpenChat();
                    }}
                    className="flex items-center gap-3 cursor-pointer"
                  >
                    <Phone className="h-5 w-5" />
                    <span className="text-sm">
                      Live chat with our support team
                    </span>
                  </p>
                  <a
                    href="mailto:support@clikkle.com"
                    className="flex items-center gap-3"
                  >
                    <Mail className="h-5 w-5" />
                    <span className="text-sm">support@clikkle.com</span>
                  </a>
                  <div className="flex items-center gap-3">
                    <MapPin className="h-5 w-5" />
                    <span className="text-sm">
                      6-470 king st west suite 255 Oshawa ON L1J 2K9 Canada
                    </span>
                  </div>
                </div>
              </div>

              <div className="mt-8 flex items-center gap-3">
                <a
                  href="https://www.linkedin.com/company/clikkle"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="h-14 w-14 rounded-full bg-white dark:bg-[#1a1a1a] border-2 border-dashed border-gray-300 dark:border-[#575662] flex items-center justify-center"
                  aria-label="LinkedIn"
                >
                  <FaLinkedin className="w-4 h-4" />
                </a>
                <a
                  href="https://instagram.com/myclikkle"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="h-14 w-14 rounded-full bg-white dark:bg-[#1a1a1a] border-2 border-dashed border-gray-300 dark:border-[#575662] flex items-center justify-center"
                  aria-label="Instagram"
                >
                  <FaInstagram className="w-4 h-4" />
                </a>
                <a
                  href="https://facebook.com/clikkle"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="h-14 w-14 rounded-full bg-white dark:bg-[#1a1a1a] border-2 border-dashed border-gray-300 dark:border-[#575662] flex items-center justify-center"
                  aria-label="Facebook"
                >
                  <FaFacebook className="w-4 h-4" />
                </a>
                <a
                  href="https://youtube.com/clikkle"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="h-14 w-14 rounded-full bg-white dark:bg-[#1a1a1a] border-2 border-dashed border-gray-300 dark:border-[#575662] flex items-center justify-center"
                  aria-label="YouTube"
                >
                  <FaYoutube className="w-4 h-4" />
                </a>
              </div>
            </div>

            <div className="relative">
              <div className="rounded-2xl border-2 border-dashed border-gray-300 dark:border-[#575662] bg-[#edeef1] dark:bg-[#141414]">
                <div className="rounded-[1rem] bg-[#edeef1] dark:bg-[#141414] p-6 md:p-8">
                  <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div className="space-y-2">
                      <label className="text-sm pl-3">Full Name</label>
                      <input
                        className="w-full bg-white dark:bg-[#1a1a1a] rounded-lg border-b-2 border-dashed border-gray-300 dark:border-[#575662] px-3 py-3 text-sm outline-none"
                        placeholder="John Doe"
                        value={fullName}
                        onChange={(e) => setFullName(e.target.value)}
                      />
                    </div>
                    <div className="space-y-2">
                      <label className="text-sm pl-3">Email</label>
                      <input
                        className="w-full bg-white dark:bg-[#1a1a1a] rounded-lg border-b-2 border-dashed border-gray-300 dark:border-[#575662] px-3 py-3 text-sm outline-none"
                        placeholder="johndoe@example.com"
                        value={email}
                        onChange={(e) => setEmail(e.target.value)}
                      />
                    </div>
                    <div className="space-y-2">
                      <label className="text-sm pl-3">Phone Number</label>
                      <input
                        className="w-full bg-white dark:bg-[#1a1a1a] rounded-lg border-b-2 border-dashed border-gray-300 dark:border-[#575662] px-3 py-3 text-sm outline-none"
                        placeholder="+1 012 3456 789"
                        value={phone}
                        onChange={(e) => setPhone(e.target.value)}
                      />
                    </div>
                  </div>
                  <div className="mt-6">
                    <p className="text-sm font-medium">Select Subject</p>
                    <div className="mt-3 flex flex-wrap items-center gap-4">
                      <label className="flex items-center gap-2 text-xs">
                        <input
                          type="radio"
                          name="subject"
                          className="accent-[#007bff] dark:accent-[#286efb]"
                          checked={subject === "General Inquiry"}
                          onChange={() => setSubject("General Inquiry")}
                        />
                        General Inquiry
                      </label>
                      <label className="flex items-center gap-2 text-xs">
                        <input
                          type="radio"
                          name="subject"
                          className="accent-[#007bff] dark:accent-[#286efb]"
                          checked={subject === "Sales & Partnerships"}
                          onChange={() => setSubject("Sales & Partnerships")}
                        />
                        Sales & Partnerships
                      </label>
                      <label className="flex items-center gap-2 text-xs">
                        <input
                          type="radio"
                          name="subject"
                          className="accent-[#007bff] dark:accent-[#286efb]"
                          checked={subject === "Technical Support"}
                          onChange={() => setSubject("Technical Support")}
                        />
                        Technical Support
                      </label>
                      <label className="flex items-center gap-2 text-xs">
                        <input
                          type="radio"
                          name="subject"
                          className="accent-[#007bff] dark:accent-[#286efb]"
                          checked={subject === "Billing & Account"}
                          onChange={() => setSubject("Billing & Account")}
                        />
                        Billing & Account
                      </label>
                      <label className="flex items-center gap-2 text-xs">
                        <input
                          type="radio"
                          name="subject"
                          className="accent-[#007bff] dark:accent-[#286efb]"
                          checked={subject === "Product Demo"}
                          onChange={() => setSubject("Product Demo")}
                        />
                        Product Demo
                      </label>
                    </div>
                  </div>
                  <div className="mt-6 space-y-2">
                    <label className="text-sm">Message</label>
                    <div className="relative">
                      <textarea
                        className="min-h-[140px] w-full bg-white dark:bg-[#1a1a1a] rounded-lg border-2 border-dashed border-gray-300 dark:border-[#575662] px-4 py-3 text-sm outline-none"
                        placeholder=""
                        onFocus={() => {
                          setPlaceholderPaused(true);
                          setFocused(true);
                        }}
                        onBlur={() => {
                          setPlaceholderPaused(false);
                          setFocused(false);
                        }}
                        value={message}
                        onChange={(e) => {
                          setMessageValue(e.target.value);
                          setMessage(e.target.value);
                        }}
                      />
                      {!focused && messageValue.length === 0 && (
                        <AnimatePresence mode="wait">
                          <motion.span
                            key={msg}
                            className="pointer-events-none absolute left-4 top-3 text-sm text-gray-300"
                            initial={{ opacity: 0, y: 2 }}
                            animate={{ opacity: 1, y: 0 }}
                            exit={{ opacity: 0, y: -2 }}
                            transition={{ duration: 0.25 }}
                          >
                            {msg}
                          </motion.span>
                        </AnimatePresence>
                      )}
                    </div>
                  </div>
                  <div className="mt-6 flex flex-col gap-3">
                    {submitError && (
                      <div className="text-red-600 text-sm">{submitError}</div>
                    )}
                    <div className="flex flex-col gap-3">
                      <div className="flex justify-end">
                        <Button
                          className="inline-flex items-center gap-2 rounded-xl bg-[#007bff] text-white hover:bg-[#0056b3] px-6 py-3 text-sm"
                          onClick={async () => {
                            if (submitting) return;
                            setSubmitError("");
                            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                            if (!fullName.trim()) {
                              setSubmitError("Please enter your full name.");
                              return;
                            }
                            if (!emailRegex.test(email)) {
                              setSubmitError(
                                "Please enter a valid email address."
                              );
                              return;
                            }
                            if (!message.trim() || message.trim().length < 10) {
                              setSubmitError(
                                "Message should be at least 10 characters."
                              );
                              return;
                            }

                            setSubmitting(true);

                            try {
                              let recipientEmail = "support@clikkle.com";
                              switch (subject) {
                                case "General Inquiry":
                                  recipientEmail = "hi@clikkle.com";
                                  break;
                                case "Billing & Account":
                                  recipientEmail = "billing@clikkle.com";
                                  break;
                                case "Technical Support":
                                  recipientEmail = "support@clikkle.com";
                                  break;
                                case "Sales & Partnerships":
                                case "Product Demo":
                                default:
                                  recipientEmail = "sales@clikkle.com";
                                  break;
                              }

                              const mailtoLink = `mailto:${recipientEmail}?subject=${encodeURIComponent(
                                subject
                              )}&body=${encodeURIComponent(
                                `Full Name: ${fullName.trim()}\n\nEmail: ${email.trim()}\n\nPhone Number: ${
                                  phone.trim() || "Not provided"
                                }\n\nMessage:\n${message.trim()}`
                              )}`;

                              const link = document.createElement("a");
                              link.href = mailtoLink;
                              link.style.display = "none";
                              document.body.appendChild(link);
                              link.click();
                              document.body.removeChild(link);

                              setFullName("");
                              setEmail("");
                              setPhone("");
                              setMessage("");
                              setMessageValue("");
                            } catch {
                              setSubmitError(
                                "Failed to open email client. Please manually email support@clikkle.com"
                              );
                            } finally {
                              setSubmitting(false);
                            }
                          }}
                          disabled={submitting}
                        >
                          {submitting ? "Opening Email..." : "Send Message"}{" "}
                          <Send className="w-6 h-6" />
                        </Button>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <SidebarDrawer open={leftDrawerOpen} toggle={toggleLeftDrawer} />
      <Footer />
    </div>
  );
};

export default Contact;
