"use client";
import { FaArrowRight } from "react-icons/fa";
import React from "react";
import {
  Bolt,
  BoltIcon,
  ChartBar,
  Ellipsis,
  ClockIcon,
  FileTextIcon,
  Globe,
  GlobeIcon,
  HeartIcon,
  LayoutDashboardIcon,
  MessageCircle,
  PhoneIcon,
  SearchIcon,
  ShieldCheckIcon,
  Smartphone,
  SparklesIcon,
  TrendingUpIcon,
  UserCogIcon,
  Users,
  WorkflowIcon,
  ArrowDown,
} from "lucide-react";
import arrow1 from "../../public/images/arrow-1.png";
import popImg from "../../public/images/pop-img.png";
import { useState } from "react";
import { ArrowUpRightIcon } from "lucide-react";
import { Button } from "../components/button";
import { Card, CardContent, CardHeader } from "../components/card";
import { Separator } from "../components/separator";
import { Switch } from "../components/switch";
import { FaStar } from "react-icons/fa";
import { IoIosArrowBack, IoIosArrowForward } from "react-icons/io";
import { ArrowRightIcon } from "lucide-react";
import BGLine from "../../public/images/BGLine.png";
import ctaimage from "../../public/images/ctaWhite.png";
import ctaBlack from "../../public/images/ctaBlack.png";
import { Logs } from "lucide-react";
import { useEffect, useRef } from "react";
import logosDark from "../../public/images/logosDark.png";
import logosLight from "../../public/images/logosLight.png";
import LeftDark from "../../public/images/LeftDark.png";
import Star from "../../public/images/star.png";
import { UsersIcon } from "lucide-react";
import { useTheme } from "../atoms/theme";
import { MacWindowCarousel } from "@/components/MacWindowCarousel";
import ThemeSwitch from "../components/themeSwitch";
import ShadowVector from "../../public/images/vectorshadow.png";
import illustration from "../../public/images/new1.png";
import SidebarDrawer from "../components/sidebarDrawer";
import AfterHeroSection from "../../public/images/user26.jpeg";
import wsj from "../../public/images/logogg.jpg";
import illustration2 from "../../public/images/new2.png";
import {
  CheckCircle2,
  User,
  Building,
  MessageSquare,
  History,
  Infinity,
} from "lucide-react";
import { apps } from "../constants/products";
import AppsSection from "../components/appsSection";
import { footerColumns } from "../constants/footerText";
import chat5 from "../../public/images/chat5.png";
import Link from "next/link";
import Image from "next/image";
import rightArrow from "../../public/images/right-arrow.png";
import chat2 from "../../public/images/chat2.jpeg";
import chat1 from "../../public/images/chat1.jpeg";
import chat3 from "../../public/images/chat3.jpeg";
import chat4 from "../../public/images/chat4.jpeg";
import chatdark from "../../public/images/chatdark.png";
import chatlight from "../../public/images/chatlight.png";
import AnnouncementBar from "../components/AnnouncementBar";
import { getCookie } from "../utils/cookies";
import TabbedFeature from "../components/TabbedFeature";
import { BsGridFill } from "react-icons/bs";
import { FaCode } from "react-icons/fa";
import { PiChatTeardropText } from "react-icons/pi";

import chatDashboardDay from "../../public/images/chat/chat widget dashbaord-daymode.png";
import chatDashboardDark from "../../public/images/chat/chat widget dashbaord-darkmode.png";
import chatConfigDay from "../../public/images/chat/chat widget config-daymode.png";
import chatConfigDark from "../../public/images/chat/chat widget config-darkmode.png";
import chatMessagesDay from "../../public/images/chat/chat widget messages-daymode.png";
import chatMessagesDark from "../../public/images/chat/chat widget messages-darkmode.png";
import { IoHeartCircle } from "react-icons/io5";
import { MdChat, MdForum, MdPersonAdd, MdSettings } from "react-icons/md";
import FeaturedPic from "@/components/FeaturedPic";
import { getEncodedReferrer } from "@/utils/utils";
import ClikkleLogo from "@/components/ClikkleLogo";

const ChatHome: React.FC = () => {
  const { theme } = useTheme();
  const [scrolled, setScrolled] = useState(false);
  useEffect(() => {
    const handleScroll = () => {
      setScrolled(window.scrollY > 0);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const [leftDrawerOpen, setLeftDrawerOpen] = useState(false);
  const toggleLeftDrawer = () => setLeftDrawerOpen((prev) => !prev);

  const tabFeatures = [
    {
      id: "chat-app",
      label: "Chat App",
      icon: <MdChat className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/chat%20app-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/chat%20app-darkmode.png",
    },
    {
      id: "live-chat",
      label: "Live Chat",
      icon: <MdForum className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/live%20chat-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/live%20chat-darkmode.png",
    },
    {
      id: "invite-agent",
      label: "Invite Agent",
      icon: <MdPersonAdd className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/invite%20agent-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/invite%20agent-darkmode.png",
    },
    {
      id: "widget-config",
      label: "Widget Config",
      icon: <MdSettings className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/widget%20config-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/widget%20config-darkmode.png",
    },
  ];

  const features1 = [
    {
      icon: (
        <MessageCircle className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "AI Chatbot",
      description:
        "Autonomously answers common customer queries using advanced LLMs.",
    },
    {
      icon: (
        <SparklesIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Auto Resolutions",
      description:
        "Resolve routine issues instantly to cut support load in half.",
    },
    {
      icon: (
        <FileTextIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Smart KB",
      description:
        "Leverage knowledge base content for fast, accurate replies.",
    },
    {
      icon: (
        <SearchIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Contextual Answers",
      description: "Provide responses that use customer context for relevance.",
    },
  ];

  const features2 = [
    {
      icon: (
        <LayoutDashboardIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Automation Builder",
      description: "Visual, no-code builder to create automations and bots.",
    },
    {
      icon: <BoltIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Triggers & Rules",
      description:
        "Fire actions based on events, conditions, and user behavior.",
    },
    {
      icon: (
        <WorkflowIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Reusable Flows",
      description: "Build and reuse automation blocks across teams and sites.",
    },
    {
      icon: <UsersIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Team Automations",
      description:
        "Automate handoffs, routing and agent workflows for efficiency.",
    },
  ];

  const features3 = [
    {
      icon: <ClockIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "24/7 Availability",
      description: "Answer customers anytime with always-on bots and queues.",
    },
    {
      icon: <GlobeIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Omnichannel",
      description:
        "Support web, mobile, and messaging channels from one inbox.",
    },
    {
      icon: <PhoneIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Global Reach",
      description:
        "Operate across time zones, languages and regions seamlessly.",
    },
    {
      icon: (
        <Smartphone className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Mobile & Web",
      description: "Agents respond on mobile or desktop with full context.",
    },
  ];

  const features4 = [
    {
      icon: <HeartIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Higher CSAT",
      description:
        "Faster replies and accurate answers boost customer satisfaction.",
    },
    {
      icon: (
        <TrendingUpIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Improved Efficiency",
      description:
        "Automation reduces manual work and speeds up resolution times.",
    },
    {
      icon: (
        <ShieldCheckIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Security & 2FA",
      description: "Protect access and data with two-factor authentication.",
    },
    {
      icon: (
        <UserCogIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Access Controls",
      description:
        "Role-based permissions ensure only authorized access to files.",
    },
  ];

  const [productsOpen, setProductsOpen] = useState(false);
  const productsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (
        productsRef.current &&
        !productsRef.current.contains(event.target as Node)
      ) {
        setProductsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);

  const testimonials = [
    {
      text: "Clikkle Chat transformed our customer support — response times dropped 70% and conversion from chat increased by 18%. The agent mobile app means we never miss a lead. Highly recommended for any customer-facing team.",
      name: "Lucas C.",
      title: "Head of Techincal Team",
      date: "Jul 5, 2025",
      logo: chat1,
      recommendNote: "Boosted conversions & CSAT",
    },
    {
      text: "Automated routing and saved replies let our small support team handle 4x more chats without hiring. Integrations with our CRM keep customer context synced and agents love the intuitive UI.",
      name: "Olivia B.",
      title: "Support Ops Manager at ApexFlow",
      date: "Jun 20, 2025",
      logo: chat2,
      recommendNote: "Essential for scaling support",
    },
    {
      text: "Clikkle Chat made multi-site chat management effortless. We consolidated widgets across 7 sites, unified histories, and now run targeted chat campaigns that drive engagement.",
      name: "Maya Chen",
      title: "Growth Lead at NextWave",
      date: "May 30, 2025",
      logo: chat3,
      recommendNote: "Great for multi-site growth",
    },
    {
      text: "Onboarding new agents is quick — predefined workflows, role permissions, and real-time coaching mean ramp time dropped dramatically. Chat analytics give us actionable insights every week.",
      name: "Lucas Grant",
      title: "Customer Experience Manager at GrowthEdge",
      date: "Apr 18, 2025",
      logo: chat4,
      recommendNote: "Perfect for fast-growing teams",
    },
    {
      text: "Our support KPIs improved across the board: first response time halved and customer satisfaction jumped. Centralized transcripts and exportable reports make auditing and training simple.",
      name: "Sofia Ramirez",
      title: "Director of CX at BuildSphere",
      date: "Mar 8, 2025",
      logo: chat5,
      recommendNote: "Top choice for CX teams",
    },
  ];

  const [idx, setIdx] = useState(0);
  const { text, name, title, date, logo, recommendNote } = testimonials[idx];

  const prev = () =>
    setIdx((idx - 1 + testimonials.length) % testimonials.length);
  const next = () => setIdx((idx + 1) % testimonials.length);

  const [isAnnual, setIsAnnual] = useState(true);

  const [openFAQ, setOpenFAQ] = useState<number | null>(0);
  const faqs = [
    {
      question: "How do I implement the chat software?",
      answer: `It’s quick to get started — create an account, add a website, and drop the widget script into your site header. We provide a step-by-step setup guide, video walkthroughs, and sample snippets for common CMSs. If you prefer, our onboarding team can configure your first website and chat flow for you.`,
    },
    {
      question: "Can I integrate the chat with my CRM or helpdesk?",
      answer:
        "Yes — the chat app integrates with popular CRMs, helpdesk platforms, and analytics tools. Use our built-in connectors or webhooks to forward conversations, create tickets, and sync contact data in real time.",
    },
    {
      question: "How is chat data secured and backed up?",
      answer:
        "We use industry-standard encryption in transit and at rest, role-based access controls, and regular backups. You can export transcripts and audit logs on demand. We also support enterprise requirements such as single sign-on (SSO) and IP allow-listing.",
    },
    {
      question: "Can I customize the widget and routing rules?",
      answer:
        "Absolutely. Customize the widget’s look and behavior (branding, position, languages), set routing rules by department or skill, create automated responses, and configure escalation/workflow rules to match your support model.",
    },
    {
      question: "Is there a mobile app for agents and managers?",
      answer:
        "Yes — agents can respond from our mobile apps (iOS and Android) or the web dashboard. Managers can view real-time dashboards, monitor active chats, and receive push notifications for high-priority events.",
    },
    {
      question: "How long is chat history retained and can I export it?",
      answer:
        "Retention depends on your plan (e.g. 30 days to 15 years). You can export conversation history as CSV or JSON, or set up automated exports to your storage service for long-term archiving.",
    },
    {
      question: "What support and SLA come with the plan?",
      answer:
        "All plans include email support and knowledge base access. Higher tiers get priority support, phone/SLAs, and a dedicated onboarding specialist. For enterprise customers we offer custom SLAs and 24/7 support options.",
    },
  ];

  const isDarkMode = theme === "dark";

  const monthlyPlans = [
    {
      name: "Starter",
      description: "Starts from",
      price: "$25",
      pricePeriod: "per month",
      buttonText: "Start Starter",
      buttonVariant: "outline",
      badge: null,
      features: [
        { icon: CheckCircle2, text: "", subtext: "All Features Included" },
        { icon: User, text: "", subtext: "1 Seat" },
        { icon: User, text: "", subtext: "1 Agent" },
        { icon: Building, text: "", subtext: "0 Depts" },
        { icon: Globe, text: "", subtext: "Unlimited Websites" },
        { icon: MessageSquare, text: "", subtext: "Unlimited Chats" },
        { icon: History, text: "", subtext: "30 day Chat History" },
      ],
      highlighted: false,
    },
    {
      name: "Basic",
      description: "Starts from",
      price: "$50",
      pricePeriod: "per month",
      buttonText: "Start Basic",
      buttonVariant: "primary",
      badge: "BEST VALUE",
      features: [
        { icon: CheckCircle2, text: "", subtext: "All Features Included" },
        { icon: Users, text: "", subtext: "10 Seats + $8 per additional seat" },
        { icon: Infinity, text: "", subtext: "Unlimited Agents" },
        { icon: Building, text: "", subtext: "0 Depts" },
        { icon: Globe, text: "", subtext: "Unlimited Websites" },
        { icon: MessageSquare, text: "", subtext: "Unlimited Chats" },
        { icon: History, text: "", subtext: "5 Year Chat History" },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Enterprise",
      description: "Starts from",
      price: "$79",
      pricePeriod: "per month",
      buttonText: "Start Enterprise",
      buttonVariant: "outline",
      badge: null,
      features: [
        { icon: CheckCircle2, text: "", subtext: "All Features Included" },
        { icon: Users, text: "", subtext: "10 Seats + $8 per additional seat" },
        { icon: Infinity, text: "", subtext: "Unlimited Agents" },
        { icon: Building, text: "", subtext: "Unlimited Depts" },
        { icon: Globe, text: "", subtext: "Unlimited Websites" },
        { icon: MessageSquare, text: "", subtext: "Unlimited Chats" },
        { icon: History, text: "", subtext: "15 Year Chat History" },
      ],
      highlighted: false,
    },
  ];
  const annualPlans = [
    {
      name: "Starter",
      description: "Starts from",
      price: "$12.50",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start Starter",
      buttonVariant: "outline",
      badge: null,
      features: [
        { icon: CheckCircle2, text: "", subtext: "All Features Included" },
        { icon: User, text: "", subtext: "1 Seat" },
        { icon: User, text: "", subtext: "1 Agent" },
        { icon: Building, text: "", subtext: "0 Depts" },
        { icon: Globe, text: "", subtext: "Unlimited Websites" },
        { icon: MessageSquare, text: "", subtext: "Unlimited Chats" },
        { icon: History, text: "", subtext: "30 day Chat History" },
      ],
      highlighted: false,
    },
    {
      name: "Basic",
      description: "Starts from",
      price: "$25",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start Basic",
      buttonVariant: "primary",
      badge: "BEST VALUE",
      features: [
        { icon: CheckCircle2, text: "", subtext: "All Features Included" },
        { icon: Users, text: "", subtext: "10 Seats + $8 per additional seat" },
        { icon: Infinity, text: "", subtext: "Unlimited Agents" },
        { icon: Building, text: "", subtext: "0 Depts" },
        { icon: Globe, text: "", subtext: "Unlimited Websites" },
        { icon: MessageSquare, text: "", subtext: "Unlimited Chats" },
        { icon: History, text: "", subtext: "5 Year Chat History" },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Enterprise",
      description: "Starts from",
      price: "$49.50",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start Enterprise",
      buttonVariant: "outline",
      badge: null,
      features: [
        { icon: CheckCircle2, text: "", subtext: "All Features Included" },
        { icon: Users, text: "", subtext: "10 Seats + $8 per additional seat" },
        { icon: Infinity, text: "", subtext: "Unlimited Agents" },
        { icon: Building, text: "", subtext: "Unlimited Depts" },
        { icon: Globe, text: "", subtext: "Unlimited Websites" },
        { icon: MessageSquare, text: "", subtext: "Unlimited Chats" },
        { icon: History, text: "", subtext: "15 Year Chat History" },
      ],
      highlighted: false,
    },
  ];

  const [dotsOpen, setDotsOpen] = useState(false);
  const dotsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (dotsRef.current && !dotsRef.current.contains(event.target as Node)) {
        setDotsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);
  const redirectToSignup = (planName: string, cycle: "monthly" | "annual") => {
    const base = "https://chat.clikkle.com/signup";
    const params = new URLSearchParams({
      theme: theme ?? "",
      plan: planName,
      cycle,
    });
    window.location.replace(`${base}?${params.toString()}`);
  };
  const [announcementOpen, setAnnouncementOpen] = useState(false);

  useEffect(() => {
    const checkHeight = () => {
      const el = document.querySelector("[data-announcement]") as HTMLElement;
      if (el && el.offsetHeight > 0) {
        setAnnouncementOpen(true);
      } else {
        setAnnouncementOpen(false);
      }
    };
    checkHeight();
    const observer = new MutationObserver(checkHeight);
    observer.observe(document.body, { childList: true, subtree: true });
    return () => observer.disconnect();
  }, []);

  useEffect(() => {
    const checkDismissedAnnouncements = () => {
      const dismissed = getCookie("dismissedAnnouncements");
      if (dismissed) {
        try {
          const dismissedIds = JSON.parse(dismissed);
          if (dismissedIds.length > 0) {
            setAnnouncementOpen(false);
          }
        } catch (error) {
          console.error("Error parsing dismissed announcements:", error);
        }
      }
    };

    checkDismissedAnnouncements();

    const interval = setInterval(checkDismissedAnnouncements, 1000);

    return () => clearInterval(interval);
  }, []);
  return (
    <div className="bg-white dark:bg-[#1a1a1a] flex flex-col items-center w-full min-h-screen">
      <div className="w-full max-w-[1540px] relative mx-auto flex flex-col items-center justify-center">
        <section className="w-full">
          <section className="relative w-full  md:min-h-[1038px]  overflow-hidden">
            <div
              className={`fixed top-0 inset-x-0 z-50 ${scrolled
                  ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1a1a]/90"
                  : productsOpen || dotsOpen
                    ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1a1a]/90"
                    : ""
                }`}
            >
              <div
                ref={(el) => {
                  if (el) {
                    const height = el.getBoundingClientRect().height;

                    if (height !== 0) {
                      setAnnouncementOpen(true);
                    }
                  }
                }}
              >
                <AnnouncementBar onClose={() => setAnnouncementOpen(false)} />
              </div>
              <div className="container max-w-[1233px] mx-auto max-[1300px]:px-14 max-[1100px]:px-4">
                <nav
                  className={`relative flex items-center justify-between py-4`}
                >
                  <ClikkleLogo />
                  <div className="flex md:hidden items-center">
                    <div
                      className="flex items-center gap-0 rounded-xl border border-gray-300 dark:border-[#ffffff3a] p-[8px] shadow-sm"
                      onClick={toggleLeftDrawer}
                    >
                      <p className="text-sm font-medium text-gray-900 dark:text-white">
                        <Logs className="w-5 h-5 text-gray-900 dark:text-white mr-3" />
                      </p>

                      <p className="flex items-center  rounded-xl text-sm font-bold ">
                        Menu
                      </p>
                    </div>
                  </div>

                  <div className="hidden md:flex items-center gap-12  font-inter font-medium text-[18px]">
                    <Link
                      href="#features"
                      className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                    >
                      Features
                    </Link>
                    <Link
                      href="#pricing"
                      className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                    >
                      Pricing
                    </Link>
                    <Link
                      href="/blogs"
                      className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                    >
                      Blog
                    </Link>
                    <div className="flex flex-row justify-center items-center">
                      <div className="relative" ref={productsRef}>
                        <button
                          onClick={() => setProductsOpen((o) => !o)}
                          className="cursor-pointer flex items-center gap-1 text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                        >
                          Products
                        </button>
                        {productsOpen && (
                          <div
                            className={`fixed ${announcementOpen ? "top-[115px]" : "top-[75px]"
                              } 
              left-1/2 transform -translate-x-1/2 w-full bg-white/90 dark:bg-[#1a1a1a]/90 backdrop-blur-md 
              shadow-lg p-6 border-b-2 border-gray-300 dark:border-[#575662] z-50 flex justify-center items-center pb-0`}
                          >
                            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                              <div className="flex flex-col gap-3">
                                {apps
                                  .slice(0, Math.ceil(apps.length / 2))
                                  .map((product) => (
                                    <Link
                                      key={product.id}
                                      href={product.route}
                                      className="flex items-center gap-4 p-[0.35rem] rounded-lg hover:bg-gray-100 dark:hover:bg-white/10 transition"
                                    >
                                      <div>
                                        <Image
                                          src={product.image}
                                          alt={product.title}
                                          className="w-[26px]"
                                          width={26}
                                          height={26}
                                        />
                                      </div>
                                      <div>
                                        <p className="font-bold text-gray-900 dark:text-white text-sm">
                                          {product.title}
                                        </p>
                                        <p className="text-xs text-gray-600 dark:text-gray-300">
                                          {product.description}
                                        </p>
                                      </div>
                                    </Link>
                                  ))}
                              </div>

                              <div className="flex flex-col gap-3">
                                {apps
                                  .slice(
                                    Math.ceil(apps.length / 2),
                                    Math.ceil(apps.length / 2) + 2,
                                  )
                                  .map((product) => (
                                    <Link
                                      key={product.id}
                                      href={product.route}
                                      className="flex items-center gap-4 p-[0.35rem] rounded-lg hover:bg-gray-100 dark:hover:bg-white/10 transition"
                                    >
                                      <div>
                                        <Image
                                          src={product.image}
                                          alt={product.title}
                                          className="w-[26px]"
                                          width={26}
                                          height={26}
                                        />
                                      </div>
                                      <div>
                                        <p className="font-bold text-gray-900 dark:text-white text-sm">
                                          {product.title}
                                        </p>
                                        <p className="text-xs text-gray-600 dark:text-gray-300">
                                          {product.description}
                                        </p>
                                      </div>
                                    </Link>
                                  ))}
                                <Link href="/products">
                                  <Button
                                    style={{ marginTop: "5px" }}
                                    variant="ghost"
                                    className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                  >
                                    View all products
                                    <ArrowRightIcon className="h-2 w-2 dark:text-white" />
                                  </Button>
                                </Link>
                              </div>

                              <div className="hidden lg:flex flex-row items-center justify-center text-center gap-3">
                                <Image
                                  src={illustration}
                                  alt="Illustration"
                                  className="w-auto h-[175px]"
                                  width={300}
                                  height={175}
                                />
                                <div className="flex flex-col justify-center items-center h-full">
                                  <p className="text-sm text-gray-700 dark:text-gray-300 max-w-[200px] pb-5 ">
                                    Get started today the modern solution to
                                    power your business.
                                  </p>
                                  <Button
                                    variant="ghost"
                                    onClick={() => {
                                      window.location.replace(
                                        "https://chat.clikkle.com/signup?theme=" +
                                        theme +
                                        "&referralApp=" +
                                        getEncodedReferrer(),
                                      );
                                    }}
                                    className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                  >
                                    Get Started Today
                                    <ArrowRightIcon
                                      className={`h-2 w-2 dark:text-white`}
                                    />
                                  </Button>
                                </div>
                              </div>
                            </div>
                          </div>
                        )}
                      </div>

                      <div className="relative" ref={dotsRef}>
                        <Ellipsis
                          onClick={() => setDotsOpen((o) => !o)}
                          className="w-8 h-6 rounded-full p-[1px] cursor-pointer"
                        />
                        {dotsOpen && (
                          <div
                            className={`fixed ${announcementOpen ? "top-[115px]" : "top-[75px]"
                              }  left-1/2 transform -translate-x-1/2 w-full 
    bg-white/90 dark:bg-[#1a1a1a]/90 backdrop-blur-md 
    shadow-lg border-b-2 border-gray-300 dark:border-[#575662] 
    z-50 flex justify-center`}
                          >
                            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 py-6">
                              <div className="flex flex-col md:flex-row justify-between items-start gap-12">
                                <div className="space-y-12">
                                  <div className="max-w-[285px] space-y-2 mb-0">
                                    <h3 className="font-instrument-sans font-medium text-[18px] leading-[20px] text-gray-900 dark:text-[#eeeef0]">
                                      Get Started For Free
                                    </h3>
                                    <p className="font-body-medium text-[#51515E] dark:text-[#eeeef0]">
                                      Streamline your Business with our Apps.
                                      Effortlessly for every team.
                                    </p>
                                  </div>
                                  <Button
                                    style={{ marginTop: "20px" }}
                                    variant="ghost"
                                    onClick={() => {
                                      window.location.replace(
                                        "https://chat.clikkle.com/signup?theme=" +
                                        theme +
                                        "&referralApp=" +
                                        getEncodedReferrer(),
                                      );
                                    }}
                                    className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                  >
                                    See How It Works
                                    <ArrowRightIcon
                                      className={`h-2 w-2 dark:text-white`}
                                    />
                                  </Button>
                                </div>

                                <div className="flex flex-wrap gap-x-14 gap-y-8 text-xs sm:text-sm">
                                  {footerColumns.map((column, index) => (
                                    <div
                                      key={index}
                                      className="flex flex-col gap-5"
                                    >
                                      <h4 className="font-label-medium text-gray-900 dark:text-white">
                                        {column.title}
                                      </h4>
                                      <ul className="flex flex-col gap-4">
                                        {column.links.map((link, linkIndex) => (
                                          <li key={linkIndex}>
                                            <div className="flex items-start gap-3">
                                              <Link
                                                href={link.url}
                                                target={
                                                  link.url.startsWith("http")
                                                    ? "_blank"
                                                    : "_self"
                                                }
                                                rel={
                                                  link.url.startsWith("http")
                                                    ? "noopener noreferrer"
                                                    : undefined
                                                }
                                                className="font-body-medium text-[#51515E] dark:text-[#d7d7de] hover:text-gray-900 dark:hover:text-white transition-colors whitespace-nowrap flex items-center gap-2"
                                              >
                                                {link.text}
                                                {column.title === "Social" && (
                                                  <FaArrowRight className="w-2 h-2" />
                                                )}
                                              </Link>

                                              {link.isNew && (
                                                <div className="hidden md:flex items-center gap-2">
                                                  <div className="w-4 h-4 flex items-center justify-center">
                                                    <div className="w-[13px] h-[13px] bg-[#c3e6ff] rounded-[6.67px] flex items-center justify-center">
                                                      <div className="w-1 h-1 bg-[#286efb] rounded-sm" />
                                                    </div>
                                                  </div>
                                                  <span className="font-body-medium text-gray-900 dark:text-white whitespace-nowrap">
                                                    New
                                                  </span>
                                                </div>
                                              )}
                                            </div>
                                          </li>
                                        ))}
                                      </ul>
                                    </div>
                                  ))}
                                </div>
                              </div>
                            </div>
                          </div>
                        )}
                      </div>
                    </div>
                  </div>

                  <div className="hidden md:flex items-center gap-4">
                    <div className="hidden md:flex items-center gap-4">
                      <div className="w-6">
                        <ThemeSwitch />
                      </div>
                      <div className="flex items-center gap-2 rounded-xl border border-gray-300 dark:border-[#ffffff3a] p-1 shadow-sm">
                        <button
                          className="cursor-pointer px-3 py-1 text-sm font-medium text-gray-900 dark:text-white"
                          onClick={() => {
                            window.location.replace(
                              "https://chat.clikkle.com/login?theme=" +
                              theme +
                              "&referralApp=" +
                              getEncodedReferrer(),
                            );
                          }}
                        >
                          Login
                        </button>

                        <button
                          className="cursor-pointer flex items-center gap-1 rounded-xl bg-[#286efb] hover:bg-[#3367d6] px-4 py-1.5 text-sm font-medium text-white transition"
                          onClick={() => {
                            window.location.replace(
                              "https://chat.clikkle.com/signup?theme=" +
                              theme +
                              "&referralApp=" +
                              getEncodedReferrer(),
                            );
                          }}
                        >
                          Try for free
                          <span>
                            <ArrowRightIcon className="w-4" />
                          </span>
                        </button>
                      </div>
                    </div>
                  </div>
                </nav>
              </div>
            </div>

            <div
              className={`z-10 flex flex-col items-center text-center ${announcementOpen ? "pt-[140px]" : "pt-[110px]"
                } px-6 relative`}
            >
              <div className="absolute h-full w-full top-0 right-0 ">
                <Image
                  src={ShadowVector}
                  alt="Shadow vector"
                  className="w-full h-full"
                />
              </div>
              <div className="flex items-center justify-center gap-2 mb-2 font-semibold py-4">
                <Link href="/">
                  <div className="flex items-center justify-center md:w-[245px] w-auto">
                    <Image
                      className="h-[32px] md:h-[40px] w-auto"
                      alt="Clikkle Chat logo"
                      width={114}
                      height={40}
                      src={
                        isDarkMode
                          ? "https://cdn.clikkle.com/images/chat/logo/2025/Clikkle%20Chat%20Blue%20(%20White%20Text).png"
                          : "https://cdn.clikkle.com/images/chat/logo/2025/Clikkle%20Chat%20Blue%20(%20Black%20Text).png"
                      }
                    />
                  </div>
                </Link>
              </div>
              <h1 className="font-inter font-black text-[40px] lg:text-7xl text-gray-900 dark:text-[#fff] mb-3 md:mb-[0.5rem] max-w-5xl leading-[1.1] md:leading-[1]">
                <span className={`dark:text-[#A9C5FF] text-[#286efb]`}>
                  Engage Users
                </span>{" "}
                with
                <br className="hidden sm:block" /> Clikkle Chat{" "}
              </h1>
              <span className="relative font-small text-[14px] md:text-[18px] text-[#3D3D3D] dark:text-[#EEEEF0] mb-8 max-w-3xl">
                Clikkle chat resolves issues fast, boosting team efficiency.
                <br className="hidden sm:block" /> Customers feel heard and
                satisfied.
                {/*<img
                  src={"/images/arrow-1.png"}
                  alt="arrow"
                  className="hidden sm:block absolute right-[-112px] top-[0px] rotate-[330deg]"
                />*/}
                {/*<div className="absolute right-[-280px] top-[40px] hidden sm:block">
                  <p className="text-[#51515E] dark:text-[#d7d7de] text-[24px] font-black font-caveat">
                    $ 12.50 / month <br />
                    for Clikkle Chat
                  </p>
                </div>*/}
              </span>
              <div className="flex flex-col sm:flex-row items-center !gap-[8px] sm:gap-4 mb-4 w-full max-w-lg z-10">
                <input
                  type="email"
                  placeholder="Enter Your Email"
                  className="flex-1 px-4 py-3 rounded-lg bg-white  text-gray-900  placeholder-gray-500 dark:placeholder-gray-400 focus:outline-none w-full border border-gray-300 dark:border-[#575662] shadow-sm dark:shadow-none"
                />
                <button
                  onClick={() => {
                    window.location.replace(
                      "https://chat.clikkle.com/signup?theme=" +
                      theme +
                      "&referralApp=" +
                      getEncodedReferrer(),
                    );
                  }}
                  type="submit"
                  className="cursor-pointer px-6 py-[14px] bg-[#25272c] dark:bg-[#286efb]  text-white font-medium rounded-lg transition w-full sm:w-auto"
                >
                  Try for Free
                </button>
              </div>{" "}
              <p className="text-[#51515E] dark:text-[#d7d7de] text-sm mb-[0.5rem] z-10">
                No credit card required.{" "}
                <Link
                  href={`${"https://worksuite.clikkle.com/signup?theme=" + theme +
                    "&referralApp=" +
                    getEncodedReferrer()
                    }`}
                  className="text-black dark:text:white dark:text-white underline hover:no-underline hover:cursor-pointer"
                >
                  Sign Up for no cost
                </Link>
              </p>
              <div className="flex flex-col sm:flex-row items-center gap-2 md:gap-16">
                {/*<span className="text-[#51515E] dark:text-[#D7D7DE] text-sm">
                  Trusted by{" "}
                  <span className="dark:text-[#A9C5FF] text-[#286efb]">
                    7K+
                  </span>{" "}
                  companies
                </span>*/}
                <div className="flex items-center gap-8">
                  {/*<Image
                    src={theme === "dark" ? logosDark : logosLight}
                    alt="Logos"
                    className="h-[36px] w-[242px]"
                    width={162}
                    height={36}
                  />*/}
                </div>
              </div>
            </div>
            <div className="flex items-center justify-center pb-8 mt-8 rounded-lg w-full">
              <div className="relative w-full max-w-[1200px]">
                {/*<img
                  src={popImg.src}
                  alt="popImg"
                  className="hidden sm:block absolute w-[120px] left-[-70px] top-[-74px]"
                />*/}
                <MacWindowCarousel initialProduct="chat" />
              </div>
            </div>
            {/* <div className="flex items-center justify-center pb-8 mt-8 rounded-lg w-full md:w-auto">
              <div className="relative w-full flex justify-center">
                <TabbedFeature
                  tabs={tabFeatures}
                  decorator={
                    <Image
                      src={popImg}
                      alt="popImg"
                      className="hidden sm:block absolute w-[120px] left-[-70px] top-[-74px] z-10"
                      width={120}
                      height={120}
                    />
                  }
                />
              </div>
            </div> */}
          </section>
        </section>
        <section className="w-full max-w-[1240px] text-gray-900 dark:text-white py-16 px-4 md:px-8 lg:px-16 m-auto">
          <div className="mx-auto text-center">
            <h2 className="text-sm md:text-base font-semibold text-[#286efb] dark:text-[#adc4fb] mb-4">
              Why Clikkle Chat?
            </h2>

            <h1 className="text-4xl md:text-5xl font-black mb-4 ">
              Automate, optimize, and transform{" "}
              <br className="hidden md:block" /> customer experience
            </h1>

            <p className="text-lg md:text-xl text-gray-600 dark:text-gray-300 mb-12">
              Manage chats, leads, routing, and analytics
              <br className="hidden md:block" />
              in one unified platform.
            </p>

            <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8 mb-16">
              <div className="flex flex-col items-center">
                <div className="bg-gray-100 dark:bg-[#141414] rounded-2xl p-4 mb-4">
                  <MessageCircle className="w-8 h-8 text-gray-600 dark:text-gray-300" />
                </div>
                <h2 className="text-xl font-semibold mb-2">
                  Live Chat & Widget
                </h2>
                <p className="text-gray-600 dark:text-gray-400 text-center">
                  Fast embeddable widget for real-time conversations.
                </p>
              </div>

              <div className="flex flex-col items-center">
                <div className="bg-gray-100 dark:bg-[#141414] rounded-2xl p-4 mb-4">
                  <Globe className="w-8 h-8 text-gray-600 dark:text-gray-300" />
                </div>
                <h2 className="text-xl font-semibold mb-2">
                  Multi-site & Channels
                </h2>
                <p className="text-gray-600 dark:text-gray-400 text-center">
                  Manage chats across websites, apps and messaging channels.
                </p>
              </div>

              <div className="flex flex-col items-center">
                <div className="bg-gray-100 dark:bg-[#141414] rounded-2xl p-4 mb-4">
                  <Bolt className="w-8 h-8 text-gray-600 dark:text-gray-300" />
                </div>
                <h2 className="text-xl font-semibold mb-2">
                  Automation & Routing
                </h2>
                <p className="text-gray-600 dark:text-gray-400 text-center">
                  Smart routing, auto-replies, and workflows to accelerate
                  responses.
                </p>
              </div>

              <div className="flex flex-col items-center">
                <div className="bg-gray-100 dark:bg-[#141414] rounded-2xl p-4 mb-4">
                  <ChartBar className="w-8 h-8 text-gray-600 dark:text-gray-300" />
                </div>
                <h2 className="text-xl font-semibold mb-2">Analytics</h2>
                <p className="text-gray-600 dark:text-gray-400 text-center">
                  Real-time dashboards, transcripts and exportable reports.
                </p>
              </div>
            </div>

            <div className="md:mt-36 font-bold border-gray-300 dark:border-[#575662] max-w-[1120px] mx-auto bg-[#20253a] text-white min-h-[35px] dark:bg-[#141414] rounded-2xl p-6 shadow-lg flex flex-col md:flex-row items-center gap-6 overflow-visible relative">
              <Image
                src={AfterHeroSection}
                alt="Use case preview"
                className="md:w-[260px] md:h-[330px] w-full h-auto rounded-lg md:object-cover md:ml-[1.7rem] md:mt-[-5.3rem] md:transform md:-rotate-3 md:scale-110 shadow-2xl md:z-20"
              />

              <div className="text-left md:p-[60px]">
                <p className="text-lg md:text-2xl !text-[1.40rem] mb-4 leading-normal">
                  Clikkle Chat revamped our support operations since 2020.
                  <br className="hidden sm:block" />
                  <span className="bg-[#3d0ebf] font-semibold">
                    Response times dropped 70% and chat-driven conversions
                    increased 18%.
                  </span>{" "}
                  The platform is now essential for our customer-facing teams.
                </p>
                <div className="flex items-center gap-2">
                  <Image
                    src={wsj}
                    alt="partner logo"
                    className="w-8 h-8 rounded-sm"
                    width={80}
                    height={80}
                  />
                  <div>
                    <p className="font-semibold">Radiant Retail</p>
                    <p className="text-sm">Head of Customer Support</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-[#1a1a1a]"
            id="features"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center sm:gap-[8rem]">
                <div className="space-y-8 justify-self-start">
                  <div className="space-y-4">
                    {" "}
                    <span className="hidden md:block text-[#286efb] dark:text-[#A9C5FF] text-[16px] font-bold">
                      Feature
                    </span>
                    <h2 className="text-[1.6rem] md:text-5xl text-gray-900 mt-4 md:mt-0  dark:text-white !leading-[1.2]  font-inter font-[900]">
                      Instantly resolve half of your
                      <span className="text-[#286efb] dark:text-[#A9C5FF]">
                        {" "}
                        support queries
                      </span>{" "}
                    </h2>
                    <p className="text-gray-600 dark:text-[#d7d7de] max-w-lg font-inter font-normal text-[16px] md:text-[18px]     ">
                      Our AI chatbot uses advanced language models to handle
                      customer queries automatically.
                    </p>
                  </div>

                  <div className="grid grid-cols-2 gap-6 max-w-[529px]">
                    {features1.map((feature, index) => (
                      <div key={index} className="md:space-y-1">
                        <div className="flex items-center gap-3">
                          <div className="w-4 h-4 rounded-lg flex items-center justify-center text-gray-600 dark:text-[#d7d7de]">
                            {feature.icon}
                          </div>
                          <h3 className="text-gray-900 dark:text-[#d7d7de] text-lg font-open-sauce font-black text-[1.16rem]  ">
                            {feature.title}
                          </h3>
                        </div>
                        <p className="text-gray-600 dark:text-[#d7d7de] text-[14px] leading-[20px] pl-[1.75rem] mt-0 font-inter font-normal">
                          {feature.description}
                        </p>
                      </div>
                    ))}
                  </div>
                  <div className="flex flex-row md:justify-start  gap-4 pt-4">
                    <Button
                      onClick={() => {
                        window.location.replace(
                          "https://chat.clikkle.com/signup?theme=" +
                          theme +
                          "&referralApp=" +
                          getEncodedReferrer(),
                        );
                      }}
                      className="bg-[#286efb] hover:bg-[#3367d6] text-white px-8 py-3 h-[40px]"
                    >
                      Get Started
                    </Button>
                    <div className="pl-4 rounded-lg font-light md:block hidden text-gray-600 dark:text-[#d7d7de]">
                      <p className="text-sm leading-relaxed font-inter">
                        <span className="text-[#ff4b5c]">&rdquo;</span>
                        The chatbot resolves half our queries instantly —
                        support load is way down.
                        <span className="text-[#ff4b5c]">&rdquo;</span>
                      </p>
                      <div className="flex items-center gap-3 mt-[0.4rem]">
                        <Image
                          src={chat2}
                          alt="Olivia B."
                          width={24}
                          height={24}
                          className="w-6 h-6 rounded-full"
                        />
                        <div>
                          <p className="font-semibold text-sm">Olivia B.</p>
                          <p className="text-xs text-gray-400">
                            Head of Customer Support
                          </p>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px]  justify-center md:justify-start order-first lg:order-none">
                  <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <FeaturedPic>
                    <Image
                      src={
                        theme === "dark"
                          ? "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/live%20chat-darkmode.png"
                          : "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/live%20chat-daymode.png"
                      }
                      className="rounded-lg shadow-lg mt-5 relative z-10  md:min-h-[345px]"
                      alt="Chat picture"
                      width={600}
                      height={600}
                    />
                  </FeaturedPic>
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-[#1a1a1a]"
            id="features2-2"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center">
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px]  justify-center md:justify-start order-first lg:order-none gap-2">
                  <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <FeaturedPic>
                    <Image
                      src={
                        theme === "dark"
                          ? "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/widget%20config-darkmode.png"
                          : "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/widget%20config-daymode.png"
                      }
                      className="rounded-lg shadow-lg mt-5 relative z-10  md:min-h-[345px]"
                      alt="Chat picture"
                      width={600}
                      height={600}
                    />
                  </FeaturedPic>
                </div>
                <div className="space-y-8 flex flex-col items-center md:items-end">
                  <div className="space-y-4">
                    {" "}
                    <span className="hidden md:block text-[#286efb] dark:text-[#A9C5FF] text-[16px] font-bold">
                      Feature
                    </span>
                    <h2 className="text-left  text-[1.6rem] md:text-5xl text-gray-900 mt-4 md:mt-0  dark:text-white !leading-[1.2]  font-inter font-[900]  ">
                      <span className="text-[#286efb] dark:text-[#A9C5FF]">
                        Streamline
                      </span>{" "}
                      Operations <br className="hidden sm:block" /> with Clikkle
                      Chat.
                    </h2>
                    <p className="text-left text-gray-600 dark:text-[#d7d7de] max-w-lg font-inter font-normal text-[16px] md:text-[18px]     ">
                      Automate tasks easily with no-code tools, empowering both
                      customers and teammates.
                    </p>
                  </div>

                  <div className="grid grid-cols-2 gap-6 max-w-[517px] justify-start items-start ">
                    {features2.map((feature, index) => (
                      <div key={index} className="md:space-y-1">
                        <div className="flex items-center gap-3">
                          <div className="w-4 h-4 rounded-lg flex items-center justify-center text-gray-600 dark:text-[#d7d7de]">
                            {feature.icon}
                          </div>
                          <h3 className="text-gray-900 dark:text-[#d7d7de] text-lg font-open-sauce font-black text-[1.16rem]  ">
                            {feature.title}
                          </h3>
                        </div>
                        <p className="text-gray-600 dark:text-[#d7d7de] text-[14px] leading-[20px] pl-[1.75rem] mt-0 font-inter font-normal">
                          {feature.description}
                        </p>
                      </div>
                    ))}

                    <div className="flex items-start gap-6 pt-4">
                      <div className="flex flex-row sm:flex-row sm:items-center gap-4">
                        <Button
                          onClick={() => {
                            window.location.replace(
                              "https://chat.clikkle.com/signup?theme=" +
                              theme +
                              "&referralApp=" +
                              getEncodedReferrer(),
                            );
                          }}
                          className="bg-[#286efb] hover:bg-[#3367d6] text-white px-8 py-3 h-[40px]"
                          style={{
                            boxShadow: `
          0px 0.25px 0.25px 0px rgba(0,0,0,0.24),
          0px 0.75px 0.75px 0px rgba(0,0,0,0.12),
          0px 1px 1.5px -0.5px rgba(0,0,0,0.12),
          0px 2px 4px -1px rgba(0,0,0,0.12),
          0px 4px 8px -4px rgba(0,0,0,0.12),
          0px 8px 12px -4px rgba(0,0,0,0.06)
        `,
                          }}
                        >
                          Get Started
                        </Button>
                      </div>
                      <div className="pl-4 rounded-lg text-gray-600 dark:text-[#d7d7de] font-light hidden md:block max-w-[280px]">
                        <p className="text-sm leading-relaxed font-inter w-60">
                          <span className="text-[#ff4b5c]">&rdquo;</span>
                          Automation builder saved our team hours — building
                          flows is simple.
                          <span className="text-[#ff4b5c]">&rdquo;</span>
                        </p>
                        <div className="flex items-center gap-3 mt-2">
                          <Image
                            src={chat2}
                            alt="Olivia B."
                            width={24}
                            height={24}
                            className="w-6 h-6 rounded-full"
                          />
                          <div>
                            <p className="font-semibold text-sm">Olivia B.</p>
                            <p className="text-xs text-gray-400">
                              Support Ops Manager
                            </p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-[#1a1a1a]"
            id="features3-3"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center sm:gap-[8rem]">
                <div className="space-y-8 justify-self-start">
                  <div className="space-y-4">
                    {" "}
                    <span className="hidden md:block text-[#286efb] dark:text-[#A9C5FF] text-[16px] font-bold">
                      Feature
                    </span>
                    <h2 className="text-[1.6rem] md:text-5xl text-gray-900 mt-4 md:mt-0  dark:text-white !leading-[1.2]  font-inter font-[900]  ">
                      <span className="text-[#286efb] dark:text-[#A9C5FF]">
                        {" "}
                        24/7 Accessibility
                      </span>{" "}
                      anywhere, anytime.{" "}
                    </h2>
                    <p className="text-gray-600 dark:text-[#d7d7de] max-w-lg font-inter font-normal text-[16px] md:text-[18px]     ">
                      Connect with customers anytime through the Intercom
                      platform across channels and applications.
                    </p>
                  </div>

                  <div className="grid grid-cols-2 gap-6 max-w-[529px]">
                    {features3.map((feature, index) => (
                      <div key={index} className="md:space-y-1">
                        <div className="flex items-center gap-3">
                          <div className="w-4 h-4 rounded-lg flex items-center justify-center text-gray-600 dark:text-[#d7d7de]">
                            {feature.icon}
                          </div>
                          <h3 className="text-gray-900 dark:text-[#d7d7de] text-lg font-open-sauce font-black text-[1.16rem]  ">
                            {feature.title}
                          </h3>
                        </div>
                        <p className="text-gray-600 dark:text-[#d7d7de] text-[14px] leading-[20px] pl-[1.75rem] mt-0 font-inter font-normal">
                          {feature.description}
                        </p>
                      </div>
                    ))}
                  </div>
                  <div className="flex flex-row md:justify-start  gap-4 pt-4">
                    <Button
                      onClick={() => {
                        window.location.replace(
                          "https://chat.clikkle.com/signup?theme=" +
                          theme +
                          "&referralApp=" +
                          getEncodedReferrer(),
                        );
                      }}
                      className="bg-[#286efb] hover:bg-[#3367d6] text-white px-8 py-3 h-[40px]"
                    >
                      Get Started
                    </Button>
                    <div className="pl-4 rounded-lg text-gray-600 dark:text-[#d7d7de] font-light md:block hidden">
                      <p className="text-sm leading-relaxed font-inter">
                        <span className="text-[#ff4b5c]">&rdquo;</span>
                        Always-on bots mean customers get help 24/7 — no more
                        missed leads.
                        <span className="text-[#ff4b5c]">&rdquo;</span>
                      </p>
                      <div className="flex items-center gap-3 mt-[0.4rem]">
                        <Image
                          src={chat3}
                          alt="Maya C."
                          width={24}
                          height={24}
                          className="w-6 h-6 rounded-full"
                        />
                        <div>
                          <p className="font-semibold text-sm">Maya C.</p>
                          <p className="text-xs text-gray-400">Growth Lead</p>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px]  justify-center md:justify-start order-first lg:order-none gap-[8rem]">
                  <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <FeaturedPic>
                    <Image
                      src={
                        theme === "dark"
                          ? "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/invite%20agent-darkmode.png"
                          : "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/invite%20agent-daymode.png"
                      }
                      className="rounded-lg shadow-lg mt-5 relative z-10  md:min-h-[345px]"
                      alt="Chat picture"
                      width={600}
                      height={600}
                    />
                  </FeaturedPic>
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-[#1a1a1a]"
            id="features4-4"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center">
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px]  justify-center md:justify-start order-first lg:order-none gap-2">
                  <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <FeaturedPic>
                    <Image
                      src={
                        theme === "dark"
                          ? "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/chat%20app-darkmode.png"
                          : "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/chat/dedicated%20chat%20app/chat%20app-daymode.png"
                      }
                      className="rounded-lg shadow-lg mt-5 relative z-10  md:min-h-[345px]"
                      alt="Chat picture"
                      width={600}
                      height={600}
                    />
                  </FeaturedPic>
                </div>
                <div className="space-y-8 flex flex-col items-center md:items-end">
                  <div className="space-y-4">
                    {" "}
                    <span className="hidden md:block text-[#286efb] dark:text-[#A9C5FF] text-[16px] font-bold">
                      Feature
                    </span>
                    <h2 className="text-left  text-[1.6rem] md:text-5xl text-gray-900 mt-4 md:mt-0  dark:text-white !leading-[1.2]  font-inter font-[900]  ">
                      Enhance Customer <br className="hidden sm:block" />
                      <span className="text-[#286efb] dark:text-[#A9C5FF]">
                        Satisfaction
                      </span>{" "}
                    </h2>
                    <p className="text-left text-gray-600 dark:text-[#d7d7de] max-w-lg font-inter font-normal text-[16px] md:text-[18px]     ">
                      Protect your data with two-factor authentication, ensuring
                      only authorized access to your files.
                    </p>
                  </div>

                  <div className="grid grid-cols-2 gap-6 max-w-[517px]">
                    {features4.map((feature, index) => (
                      <div key={index} className="md:space-y-1">
                        <div className="flex items-center gap-3">
                          <div className="w-4 h-4 rounded-lg flex items-center justify-center text-gray-600 dark:text-[#d7d7de]">
                            {feature.icon}
                          </div>
                          <h3 className="text-gray-900 dark:text-[#d7d7de] text-lg font-open-sauce font-black text-[1.16rem]  ">
                            {feature.title}
                          </h3>
                        </div>
                        <p className="text-gray-600 dark:text-[#d7d7de] text-[14px] leading-[20px] pl-[1.75rem] mt-0 font-inter font-normal">
                          {feature.description}
                        </p>
                      </div>
                    ))}
                    <div className="flex items-start gap-6 pt-4">
                      <div className="flex flex-row sm:flex-row sm:items-center gap-4">
                        <Button
                          onClick={() => {
                            window.location.replace(
                              "https://chat.clikkle.com/signup?theme=" +
                              theme +
                              "&referralApp=" +
                              getEncodedReferrer(),
                            );
                          }}
                          className="bg-[#286efb] hover:bg-[#3367d6] text-white px-8 py-3 h-[40px]"
                          style={{
                            boxShadow: `
          0px 0.25px 0.25px 0px rgba(0,0,0,0.24),
          0px 0.75px 0.75px 0px rgba(0,0,0,0.12),
          0px 1px 1.5px -0.5px rgba(0,0,0,0.12),
          0px 2px 4px -1px rgba(0,0,0,0.12),
          0px 4px 8px -4px rgba(0,0,0,0.12),
          0px 8px 12px -4px rgba(0,0,0,0.06)
        `,
                          }}
                        >
                          Get Started
                        </Button>
                      </div>
                      <div className="pl-4 rounded-lg text-gray-600 dark:text-[#d7d7de] font-light hidden md:block max-w-[280px]">
                        <p className="text-sm leading-relaxed font-inter w-60">
                          <span className="text-[#ff4b5c]">&rdquo;</span>
                          Mobile app keeps our agents responsive — excellent UX
                          and context.
                          <span className="text-[#ff4b5c]">&rdquo;</span>
                        </p>

                        <div className="flex items-center gap-3 mt-2">
                          <Image
                            src={chat4}
                            alt="Lucas G."
                            width={24}
                            height={24}
                            className="w-6 h-6 rounded-full"
                          />
                          <div>
                            <p className="font-semibold text-sm">Lucas G.</p>
                            <p className="text-xs text-gray-400">
                              Customer Experience Manager
                            </p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <AppsSection />
        </section>

        <section className="w-full min-h-[510px]">
          <div className="bg-white dark:bg-[#1a1a1a] py-12 md:py-32 px-4 md:px-0">
            <div className="max-w-3xl mx-auto text-center flex flex-col justify-center items-center">
              <h2 className="text-[34px] md:text-5xl  font-inter leading-[48px]  [text-stroke:1px_#000] font-bold  text-gray-900 dark:text-white text-center">
                See what our <br className="hidden sm:block" />
                <span className="text-[#286efb] dark:text-[#a9c5ff]  [text-stroke:1px_#000] font-bold">
                  Users
                </span>{" "}
                are saying
              </h2>
              <p className="mt-4 text-gray-600 dark:text-gray-300 text-sm md:text-base font-inter font-normal text-[14px] leading-[20px] tracking-[0em] text-center max-w-[508px]">
                Don&apos;t just take our word for it. See what our valued
                customers have to say about their experience with our platform
                and how it has transformed their business operations.
              </p>
            </div>

            <div className="max-w-2xl mx-auto mt-8 md:px-0">
              <div className="flex justify-center space-x-1">
                {Array(5)
                  .fill(0)
                  .map((_, i) => (
                    <FaStar key={i} className="text-yellow-400" />
                  ))}
              </div>

              <div className="mt-6 flex items-center justify-center">
                <button
                  onClick={prev}
                  className="cursor-pointer p-2 md:p-4 rounded-full border border-gray-300 dark:border-gray-500"
                >
                  <IoIosArrowBack
                    size={18}
                    className="text-gray-900 dark:text-white"
                  />
                </button>

                <p className="mx-4 md:mx-8 text-gray-900 dark:text-white text-sm md:text-lg font-inter font-normal md:font-medium text-[24px] leading-[23px] md:leading-[25px]   text-center md:min-w-[700px]">
                  {text}
                </p>

                <button
                  onClick={next}
                  className="cursor-pointer p-2 md:p-4 rounded-full border border-gray-300 dark:border-gray-500"
                >
                  <IoIosArrowForward
                    size={18}
                    className="text-gray-900 dark:text-white"
                  />
                </button>
              </div>

              <div className="mt-4 text-center text-sm text-gray-600 dark:text-gray-400">
                <span className="text-red-500">*</span>
                {recommendNote}
              </div>

              <div className="mt-6 flex flex-col items-center">
                <Image
                  src={logo}
                  alt="Company Logo"
                  className="h-16 w-16 rounded-full object-cover"
                  width={64}
                  height={64}
                />
                <p className="mt-2 font-medium text-gray-900 dark:text-white">
                  {name}
                </p>
                <p className="text-gray-600 dark:text-gray-400 text-sm">
                  {title}
                </p>
                <p className="text-gray-500 dark:text-gray-500 text-xs mt-1">
                  {date}
                </p>
              </div>
            </div>
          </div>
        </section>


        {/* <section className="w-full" id="moreInfo">
          <section
            className="relative w-full py-16 bg-white dark:bg-[#1a1a1a] overflow-hidden"
            id="pricing"
          >
            <div className="relative max-w-7xl mx-auto px-4">
              <Image
                className="absolute w-[574px] h-[566px] top-[-300px] right-0 z-0"
                alt="Background line"
                src={BGLine}
              />
              <Image
                className="absolute w-[701px] h-[695px] bottom-[-300px] left-0 z-0"
                alt="Background line"
                src={BGLine}
              />

              <div className="flex flex-col items-center gap-4 mb-12 relative z-10">
                <h2 className="text-[32px] md:text-5xl font-semibold  text-center tracking-[-0.96px] leading-[56px]">
                  <span className="text-gray-900 dark:text-white tracking-[-0.46px]">
                    Our{" "}
                  </span>
                  <span className="text-[#286efb] dark:text-[#A9C5FF] tracking-[-0.46px]">
                    Pricing
                  </span>
                  <span className="text-gray-900 dark:text-white tracking-[-0.46px]">
                    {" "}
                    Plans
                  </span>
                </h2>

                <p className="text-[#51515E] dark:text-[#eeeef0] text-base text-center leading-6 tracking-[-0.03px]">
                  Affordable solutions for businesses of all sizes{" "}
                  <br className="hidden sm:block" />
                  with a{" "}
                  <span className="font-bold text-[#286efb] dark:text-[#A9C5FF]">
                    7 day free
                  </span>{" "}
                  tier included
                </p>

                <div className="flex items-center gap-3 mt-4 flex-wrap relative">
                  <span className="text-[#51515E] dark:text-[#eeeef0] text-sm whitespace-nowrap">
                    Monthly
                  </span>

                  <Switch checked={isAnnual} onCheckedChange={setIsAnnual} />

                  <div className="flex items-center gap-2 text-sm">
                    <span className="text-[#51515E] dark:text-[#eeeef0] whitespace-nowrap leading-none">
                      Annually
                    </span>
                  </div>

                  <div className="hidden md:flex items-center gap-1 mt-[-1rem] absolute right-[-9.6rem] ">
                    <Image
                      src={rightArrow}
                      alt="save icon"
                      width={36}
                      height={36}
                      className="w-10 h-4 rotate-[5deg]"
                    />
                    <span className="text-[#4e85f0] text-sm relative -top-[1px]">
                      Save up to 50%
                    </span>
                  </div>
                </div>
              </div>

              <div className="flex flex-wrap justify-center gap-3 relative z-10">
                {(isAnnual ? annualPlans : monthlyPlans).map((plan, index) => (
                  <Card
                    key={index}
                    className={`rounded-3xl w-full border md:w-[348px] flex flex-col ${
                      plan.highlighted
                        ? "border-[3px] border-gray-300 dark:border-white shadow-[0px_10px_60.5px_rgba(0,0,0,0.25),0px_10px_60.5px_rgba(0,0,0,0.1)] dark:shadow-[0px_10px_60.5px_#ffffff40,0px_10px_60.5px_#ffffff1c] bg-[#1a1a1a] dark:bg-black"
                        : "border-gray-300 dark:border-[#5e5e69] bg-gray-100 dark:bg-[#141414]"
                    } ${
                      index === 1
                        ? "md:h-[755px] -my-7 mt-2"
                        : "md:h-[663px] mt-9"
                    }`}
                  >
                    <CardHeader className="p-0">
                      <div
                        className={`${
                          plan.highlighted ? "m-0" : "m-1"
                        } h-[136px] rounded-[20px] ${
                          plan.backgroundImage
                            ? "bg-[#141414] dark:bg-[#141414] bg-cover"
                            : "bg-gray-50 dark:bg-black"
                        } shadow-[0px_12px_12px_-3px_rgba(0,0,0,0.04),0px_1px_1px_-0.5px_rgba(0,0,0,0.03),0px_3px_3px_-1.5px_rgba(0,0,0,0.02),0px_6px_6px_-3px_rgba(0,0,0,0.02)]`}
                      >
                        <div className="p-7">
                          <h3
                            className={`${
                              plan.highlighted
                                ? "text-white"
                                : "dark:text-white"
                            }
                              text-gray-900 text-2xl font-medium tracking-[-0.48px] leading-8
                              `}
                          >
                            {plan.name}
                          </h3>
                          <p
                            className={`
                              ${
                                plan.highlighted
                                  ? "text-white"
                                  : "dark:text-[#d7d7de]"
                              }
                              text-gray-600 text-sm tracking-[-0.08px] leading-5 whitespace-pre-line`}
                          >
                            {plan.description}
                          </p>
                        </div>
                      </div>

                      <div className="px-9 pt-8 pb-4">
                        <div className="flex items-baseline">
                          <span
                            className={`
                              ${
                                plan.highlighted
                                  ? "text-white"
                                  : "dark:text-[#d7d7de]"
                              }
                              text-gray-900 text-5xl font-medium tracking-[-0.96px] leading-[56px]`}
                          >
                            {plan.price}
                          </span>
                          <span
                            className={`
                              ${
                                plan.highlighted
                                  ? "text-white"
                                  : "dark:text-[#d7d7de]"
                              }
                              text-gray-600 text-sm ml-2 tracking-[-0.08px] leading-5`}
                          >
                            / Month
                          </span>
                        </div>

                        <Button
                          onClick={() =>
                            redirectToSignup(
                              plan.name,
                              isAnnual ? "annual" : "monthly"
                            )
                          }
                          className={`w-full mt-6 rounded-lg text-white dark:text-white text-xs cursor-pointer  ${
                            plan.buttonVariant === "primary"
                              ? "bg-[#286efb] hover:bg-blue-600 text-white"
                              : "bg-[#272631] dark:bg-black border border-gray-300 dark:border-[#ffffff33] hover:text-white"
                          }`}
                        >
                          {plan.buttonText}
                        </Button>
                      </div>

                      <Separator className="mx-9 bg-gray-200 dark:bg-[#ffffff1a]" />
                    </CardHeader>

                    <CardContent className="px-9 pt-5">
                      <p
                        className={`
                          ${
                            plan.highlighted
                              ? "text-white"
                              : "dark:text-[#d7d7de]"
                          }
                          text-[#51515E] dark:text-[#eeeef0] text-xs font-semibold tracking-[0.12px] leading-5 mb-4`}
                      >
                        INCLUDES
                      </p>

                      <div className="flex flex-col gap-[0.575rem]">
                        {plan.features.map((feature, featureIndex) => (
                          <div
                            key={featureIndex}
                            className="flex items-start gap-3"
                          >
                            <feature.icon
                              className={`w-[15px]                                   ${
                                plan.highlighted
                                  ? "text-white"
                                  : "dark:text-[#d7d7de]"
                              }`}
                            />{" "}
                            <div className="flex items-start gap-1">
                              {feature.text && (
                                <span
                                  className={`
                                  ${
                                    plan.highlighted
                                      ? "text-white"
                                      : "dark:text-[#d7d7de]"
                                  }
                                  text-gray-900 dark:text-white text-sm font-medium tracking-[-0.08px] leading-5`}
                                >
                                  {feature.text}
                                </span>
                              )}
                              <span
                                className={`
                                  ${
                                    plan.highlighted
                                      ? "text-white"
                                      : "dark:text-[#d7d7de]"
                                  }
                                  text-gray-600 dark:text-[#d7d7de] text-sm tracking-[-0.08px] leading-5`}
                              >
                                {feature.subtext}
                              </span>
                            </div>
                          </div>
                        ))}
                      </div>
                    </CardContent>
                  </Card>
                ))}
              </div>

              <div className="flex flex-col items-center justify-center gap-3 mt-16 relative z-10">
                <div
                  className="p-3 bg-[#1759f3] rounded-[32px] hover:cursor-pointer"
                  onClick={() => {
                    window.location.replace(
                      "https://chat.clikkle.com/signup?theme=" + theme
                    );
                  }}
                >
                  <ArrowUpRightIcon className="w-4 h-4 text-white" />
                </div>
                <div className="text-center">
                  <h3 className="text-xl">
                    <span className="font-medium text-gray-900 dark:text-white">
                      Try for{" "}
                    </span>
                    <span className="font-semibold text-[#286efb] dark:text-[#A9C5FF]">
                      Free
                    </span>
                  </h3>
                  <p className="text-[#51515E] dark:text-[#eeeef0] text-sm leading-6">
                    Explore Basic Features at No Cost
                  </p>
                </div>
              </div>
            </div>
          </section>
        </section> */}
        <section className="w-full" id="moreInfo">
          <section
            className="relative py-16 bg-white dark:bg-[#1a1a1a] overflow-hidden"
            id="pricing"
          >
            <div className="container mx-auto px-4 py-12">
              <div className="flex flex-col md:flex-row items-center justify-center gap-12 md:gap-24">
                <div className="relative w-full md:w-auto flex justify-center">
                  <Image
                    src="/images/free-dog.png"
                    alt="Free forever"
                    width={400}
                    height={400}
                    className="object-contain max-w-[200px] md:max-w-[300px]"
                  />
                </div>

                <div className="w-full md:w-auto text-center md:text-start mx-auto md:mx-0">
                  <h2 className="text-4xl md:text-5xl font-bold text-gray-900 dark:text-white mb-6">
                    Free forever!
                  </h2>
                  <div className="w-full md:w-auto flex justify-center items-center md:block">
                    <ul className="space-y-3 mb-6 text-start">
                      {[
                        "Unlimited Users",
                        "Unlimited Chats",
                        "Unlimited Websites",
                      ].map((item, index) => (
                        <li
                          key={index}
                          className="flex items-center justify-start text-lg text-gray-700 dark:text-gray-300"
                        >
                          <svg
                            className="w-5 h-5 text-blue-500 mr-3 flex-shrink-0"
                            fill="none"
                            stroke="currentColor"
                            viewBox="0 0 24 24"
                          >
                            <path
                              strokeLinecap="round"
                              strokeLinejoin="round"
                              strokeWidth="2"
                              d="M5 13l4 4L19 7"
                            />
                          </svg>
                          {item}
                        </li>
                      ))}
                    </ul>
                  </div>

                  <Link
                    href="https://clikkle.com/offers/chat"
                    className="text-blue-500 hover:text-blue-600 font-medium inline-flex items-center text-lg transition-colors group"
                  >
                    See upgrades
                    <span className="ml-2 transform group-hover:translate-x-1 transition-transform">
                      <ArrowRightIcon className="w-5 h-5" />
                    </span>
                  </Link>
                  <br />
                  <Button
                    onClick={() => {
                      window.location.replace(
                        "https://chat.clikkle.com/signup?theme=" +
                        theme +
                        "&referralApp=" +
                        getEncodedReferrer(),
                      );
                    }}
                    className="bg-[#286efb] hover:bg-[#3367d6] text-white px-8 py-3 h-[40px] mt-4"
                  >
                    Try for free
                  </Button>
                </div>
              </div>
            </div>
          </section>
        </section>

        <section className="w-full">
          <section className="w-full py-20 md:py-32 bg-white dark:bg-[#1a1a1a]">
            <div className="container max-w-[694px] mx-auto px-4  text-center">
              <span className="text-gray-900 dark:text-white text-center font-bold text-sm">
                FAQS SECTION
              </span>
              <div className="text-center mb-24 mt-8">
                <h2 className="text-[32px]  [text-stroke:1px_#000] font-boldmd:text-5xl font-medium text-gray-900 dark:text-white mb-6 font-paragraph-inter-m-regular">
                  Frequently Asked Questions
                </h2>
              </div>
              <div className="space-y-4 border border-gray-300 dark:border-[#5e5e69] rounded-xl overflow-hidden transition-colors bg-gray-100 dark:bg-[#141414] p-2">
                {faqs.map((faq, index) => {
                  const isOpen = openFAQ === index;
                  return (
                    <React.Fragment key={index}>
                      <div
                        className={`rounded-xl overflow-hidden transition-colors !mt-[0px] ${isOpen
                            ? "bg-white dark:bg-[#1a1a1a]"
                            : "bg-gray-100 dark:bg-[#141414]"
                          }`}
                      >
                        <button
                          className="w-full px-4 py-5 text-left flex items-center justify-between hover:bg-white dark:hover:bg-[#1a1a1a] transition-colors"
                          onClick={() => setOpenFAQ(isOpen ? null : index)}
                        >
                          <h3 className="text-lg font-[400] text-gray-900 dark:text-white pr-4">
                            {faq.question}
                          </h3>
                          <ArrowDown
                            className={`w-6 h-6 text-black bg-gray-300 dark:bg-[#d7d7de] rounded-full p-1 font-bold transition-transform ${isOpen ? "rotate-180" : ""
                              }`}
                          />
                        </button>

                        {isOpen && (
                          <div className="pr-8 pl-4 pb-6">
                            <p className="text-[#51515E] dark:text-[#EEEEF0] text-start font-[300] text-md">
                              {faq.answer}
                            </p>
                          </div>
                        )}
                      </div>
                      {index < 4 && (
                        <hr className="h-px bg-gray-300 dark:bg-[#5e5e69] border-0 !m-[5px]" />
                      )}
                    </React.Fragment>
                  );
                })}
              </div>
            </div>
          </section>
        </section>
        <section className="w-full flex justify-center items-center">
          <div className="bg-[#edeef1] dark:bg-[#141414] p-10 md:pt-10 pt-16 rounded-[20px] border-2 border-dashed border-gray-300 dark:border-[#575662] my-24 mx-[1.2rem] md:mx-[50px] md:max-w-[1062px] relative overflow-hidden md:overflow-visible">
            <div className="flex flex-col-reverse md:flex-row items-center md:items-start h-full">
              <div className="w-full text-center md:text-left flex flex-col justify-between gap-4 h-full md:w-[1062px] pt-36 md:pt-0">
                <div>
                  <h2 className="!text-[30px] md:!text-[55px] leading-none font-bold text-gray-900 dark:text-white">
                    Transform Your{" "}
                    <span className="text-[#286efb] dark:text-[#a9c5ff]">
                      Support
                    </span>
                  </h2>
                  <h3 className="!text-[30px] md:!text-[55px] font-bold text-gray-900 dark:text-white leading-tight">
                    Start faster.
                  </h3>
                </div>

                <p className="mt-4 text-gray-600 dark:text-gray-300 text-base md:text-lg">
                  Automate chats, boost conversions, and get real-time insights.
                </p>

                <div className="mt-6 w-full max-w-xl flex flex-col items-center md:items-start gap-4">
                  <div className="flex flex-col sm:flex-row items-center sm:items-stretch gap-3 w-full">
                    <input
                      type="email"
                      placeholder="Enter your email"
                      className="flex-1 px-4 py-3 rounded-lg bg-white text-gray-900 placeholder-gray-500 dark:placeholder-gray-400 focus:outline-none w-full border border-gray-300 dark:border-[#575662] shadow-sm dark:shadow-none"
                    />
                    <button
                      onClick={() => {
                        window.location.replace(
                          "https://chat.clikkle.com/signup?theme=" +
                          theme +
                          "&referralApp=" +
                          getEncodedReferrer(),
                        );
                      }}
                      className="cursor-pointer px-6 py-3 bg-black dark:bg-[#286efb] text-white font-medium rounded-lg transition w-full sm:w-auto"
                    >
                      Get Started for Free
                    </button>
                  </div>

                  <div className="flex items-start gap-2 text-sm text-gray-600 dark:text-gray-300">
                    <label className="relative flex items-center cursor-pointer">
                      <input
                        type="checkbox"
                        id="terms"
                        defaultChecked
                        className="peer appearance-none h-4 w-4 border-2 border-blue-500 rounded-full bg-white dark:bg-gray-800 checked:bg-[#286efb] checked:border-blue-500 checked:ring-2 checked:ring-blue-300 transition duration-200"
                        aria-label="Agree to terms"
                      />
                      <span className="absolute left-0 top-0 h-4 w-4 flex items-center justify-center pointer-events-none peer-checked:before:content-['✓'] peer-checked:before:text-white peer-checked:before:text-sm peer-checked:before:font-bold"></span>
                    </label>

                    <span className="ml-1 leading-5">
                      I agree with the{" "}
                      <Link
                        href="/terms-of-service"
                        className="underline text-gray-900 dark:text-gray-100 hover:text-[#51515E] dark:hover:text-white"
                        target="_blank"
                        rel="noopener noreferrer"
                      >
                        Terms and Conditions
                      </Link>
                    </span>
                  </div>
                </div>
              </div>

              <div className="w-full md:w-1/2 md:h-full md:self-end flex md:justify-end md:items-end justify-center items-center relative">
                <Image
                  src={theme === "dark" ? ctaBlack : ctaimage}
                  alt="Chat illustration"
                  className="w-[11.5rem] sm:w-[13rem] md:w-[340px] absolute left-1/2 md:left-auto top-[-48px] md:top-auto md:bottom-[-42px] md:right-[-35px] -translate-x-1/2 md:translate-x-0 z-10 pointer-events-none"
                />
              </div>
            </div>
          </div>
        </section>
      </div>

      <footer className="w-full">
        <footer className="w-full bg-white dark:bg-[#1a1a1a] border-t border-gray-300 dark:border-[#9c989c] pt-6 md:pt-16">
          <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 mx-auto px-4">
            <div className="flex flex-col md:flex-row justify-between gap-12">
              <div className="space-y-12">
                {/* <Link href="/">
                  <div className="flex items-center justify-start md:w-[245px] w-auto">
                    <Image
                      className="h-[32px] md:h-[40px] w-auto"
                      alt="Clikkle Chat logo"
                      width={114}
                      height={40}
                      src={
                        isDarkMode
                          ? "https://cdn.clikkle.com/images/chat/logo/2025/Clikkle%20Chat%20Blue%20(%20White%20Text).png"
                          : "https://cdn.clikkle.com/images/chat/logo/2025/Clikkle%20Chat%20Blue%20(%20Black%20Text).png"
                      }
                    />
                  </div>
                </Link> */}
                <ClikkleLogo />
                <div className="max-w-[285px] space-y-1 md:space-y-2 mt-[48px]">
                  <h3 className="font-instrument-sans font-medium text-[18px] leading-[20px] tracking-[0em] font-headline-small text-gray-900 dark:text-[#eeeef0]">
                    Get Started For Free
                  </h3>
                  <p className="font-body-medium text-[#51515E] dark:text-[#eeeef0] text-[length:var(--body-medium-font-size)] tracking-[var(--body-medium-letter-spacing)] leading-[var(--body-medium-line-height)]">
                    Transform your Support operations with our modern platform.
                    Comprehensive solutions for every organization.
                  </p>
                </div>
              </div>

              <div className="flex flex-nowrap justify-between gap-y-8 space-x-2 min-[340px]:space-x-5 md:space-x-14 mt-4 text-[10px] min-[360px]:text-xs sm:text-sm overflow-hidden">
                {footerColumns.map((column, index) => (
                  <div key={`column-${index}`} className="flex flex-col gap-5">
                    <h4 className="font-label-medium text-gray-900 dark:text-white text-[length:var(--label-medium-font-size)] tracking-[var(--label-medium-letter-spacing)] leading-[var(--label-medium-line-height)]">
                      {column.title}
                    </h4>
                    <ul className="flex flex-col gap-4">
                      {column.links.map((link, linkIndex) => (
                        <li key={`link-${index}-${linkIndex}`}>
                          <div className="flex items-start gap-3">
                            <Link
                              href={link.url}
                              target={
                                link.url.startsWith("http") ? "_blank" : "_self"
                              }
                              rel={
                                link.url.startsWith("http")
                                  ? "noopener noreferrer"
                                  : undefined
                              }
                              className="font-body-medium text-[#51515E] dark:text-[#d7d7de] text-[length:var(--body-medium-font-size)] tracking-[var(--body-medium-letter-spacing)] leading-[var(--body-medium-line-height)] whitespace-nowrap hover:text-gray-900 dark:hover:text-white transition-colors"
                            >
                              <span className="flex justify-center items-center gap-2">
                                {link.text}{" "}
                                {column.title === "Social" && (
                                  <FaArrowRight className="w-2 h-2 text-[#51515E] dark:text-[#d7d7de]" />
                                )}
                              </span>
                            </Link>
                            {link.isNew && (
                              <div className="hidden md:flex items-center gap-2 ">
                                <div className="relative w-4 h-4">
                                  <div className="relative w-[13px] h-[13px] top-px left-px bg-[#c3e6ff] rounded-[6.67px]">
                                    <div className="relative w-1 h-1 top-[5px] left-[5px] bg-[#286efb] rounded-sm" />
                                  </div>
                                </div>
                                <span className="font-body-medium text-gray-900 dark:text-white text-[length:var(--body-medium-font-size)] tracking-[var(--body-medium-letter-spacing)] leading-[var(--body-medium-line-height)] whitespace-nowrap">
                                  New
                                </span>
                              </div>
                            )}
                          </div>
                        </li>
                      ))}
                    </ul>
                  </div>
                ))}
              </div>
            </div>
          </div>

          <div className="w-full h-10 bg-gray-100 dark:bg-[#141414] mt-12 flex items-center justify-center">
            <p className="font-body-small text-gray-900 dark:text-white text-[length:var(--body-small-font-size)] tracking-[var(--body-small-letter-spacing)] leading-[var(--body-small-line-height)]">
              ©{new Date().getFullYear()} Clikkle All Rights Reserved.
            </p>
          </div>
        </footer>
      </footer>
      <SidebarDrawer open={leftDrawerOpen} toggle={toggleLeftDrawer} />
    </div>
  );
};

export default ChatHome;
