"use client";

import { FaArrowRight } from "react-icons/fa";
import React from "react";
import {
  ArrowDown,
  Bolt,
  ChartBar,
  Ellipsis,
  Globe,
  MessageCircle,
  Smartphone,
  Users,
} from "lucide-react";
import campaigns1 from "../../public/images/campaigns1.jpeg";
import campaigns2 from "../../public/images/campaigns2.jpeg";
import campaigns3 from "../../public/images/campaigns3.jpeg";
import campaigns4 from "../../public/images/campaigns4.jpeg";
import campaigns5 from "../../public/images/campaigns5.jpeg";
import rightArrow from "../../public/images/right-arrow.png";
import chat3 from "../../public/images/chat3.jpeg";
import chat4 from "../../public/images/chat4.jpeg";
import { useState } from "react";
import arrow1 from "../../public/images/arrow-1.png";
import popImg from "../../public/images/pop-img.png";
import { ArrowUpRightIcon } from "lucide-react";
import { Button } from "../components/button";
import { Card, CardContent, CardHeader } from "../components/card";
import { Separator } from "../components/separator";
import { Switch } from "../components/switch";
import { FaStar } from "react-icons/fa";
import { IoIosArrowBack, IoIosArrowForward } from "react-icons/io";
import { ArrowRightIcon } from "lucide-react";
import BGLine from "../../public/images/BGLine.png";
import ctaimage from "../../public/images/ctaWhite.png";
import ctaBlack from "../../public/images/ctaBlack.png";
import { Logs } from "lucide-react";
import { useEffect, useRef } from "react";
import logosDark from "../../public/images/logosDark.png";
import logosLight from "../../public/images/logosLight.png";
import LeftDark from "../../public/images/LeftDark.png";
import Star from "../../public/images/star.png";
import { useTheme } from "../atoms/theme";
import { MacWindowCarousel } from "@/components/MacWindowCarousel";
import ShadowVector from "../../public/images/vectorshadow.png";
import SidebarDrawer from "../components/sidebarDrawer";
import AfterHeroSection from "../../public/images/chat3.jpeg";
import wsj from "../../public/images/mannequin.jpg";
import { Schedule } from "@mui/icons-material";
import {
  Mail as MailIcon,
  Users as UserIcon,
  Phone as PhoneIcon,
  Layout as DragIcon,
  Zap as SparklesIcon,
  FileText as TemplateIcon,
  Calendar as CalendarIcon,
  BarChart as ChartIcon,
  Repeat as AutomationIcon,
  FilePlus as FormsIcon,
  Layers as SegmentIcon,
  Box as IntegrationIcon,
  CornerUpRight as ResendIcon,
  Globe as AdsIcon,
  Monitor as GoogleAdsIcon,
  Handshake as HandshakeIcon,
  Star as StarIcon,
  RefreshCw as DynamicIcon,
  Share2 as SocialAdvancedIcon,
  TrendingUp as ChartComprehensiveIcon,
  Repeat as AutomationUnlimitedIcon,
  ShoppingCart as EcommerceIcon,
  Send as WelcomeIcon,
  Layers as SegmentUnlimitedIcon,
  Megaphone as AdsAdvancedIcon,
  Search as SeoIcon,
} from "lucide-react";
import {
  Mail,
  Zap,
  FileText,
  Search,
  Layout,
  Repeat,
  Calendar,
  BarChart,
  ShoppingCart,
  Database,
  ShieldCheck,
  TrendingUp,
  Monitor,
} from "lucide-react";
import ThemeSwitch from "../components/themeSwitch";
import { apps } from "../constants/products";
import AppsSection from "../components/appsSection";
import { footerColumns } from "../constants/footerText";
import chat1 from "../../public/images/chat1.jpeg";
import campaignsdark from "../../public/images/campaignsdark.png";
import campaignslight from "../../public/images/campaignslight.png";
import AnnouncementBar from "../components/AnnouncementBar";
import { getCookie } from "../utils/cookies";
import TabbedFeature from "../components/TabbedFeature";
import Image from "next/image";
import Link from "next/link";
import { IoHeartCircle } from "react-icons/io5";
import {
  MdAccountTree,
  MdAddCircleOutline,
  MdAnalytics,
  MdCallSplit,
  MdCampaign,
  MdDescription,
  MdEmail,
  MdGroups,
  MdLabel,
  MdPersonAdd,
  MdSave,
  MdTableChart,
  MdUpload,
} from "react-icons/md";
import FeaturedPic from "@/components/FeaturedPic";
import { getEncodedReferrer } from "@/utils/utils";
import ClikkleLogo from "@/components/ClikkleLogo";

const CampaignsHome: React.FC = () => {
  const { theme } = useTheme();
  const [scrolled, setScrolled] = useState(false);
  useEffect(() => {
    const handleScroll = () => {
      setScrolled(window.scrollY > 0);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const [leftDrawerOpen, setLeftDrawerOpen] = useState(false);
  const toggleLeftDrawer = () => setLeftDrawerOpen((prev) => !prev);

  const tabFeatures = [
    {
      id: "audience-dash",
      label: "Audience Dash",
      icon: <MdGroups className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/audience%20dash-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/audience%20dash-darkmode.png",
    },
    {
      id: "campaign-manager",
      label: "Campaign Manager",
      icon: <MdCampaign className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/campaign%20manager-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/campaign%20manager-darkmode.png",
    },
    {
      id: "create-campaign",
      label: "Create Campaign",
      icon: <MdAddCircleOutline className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/create%20campaign-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/create%20campaign-darkmode.png",
    },
    {
      id: "campaign-analytics",
      label: "Campaign Analytics",
      icon: <MdAnalytics className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/campaign%20analytics-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/campaign%20analytics-darkmode.png",
    },
    {
      id: "automation-builder",
      label: "Automation Builder",
      icon: <MdAccountTree className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/Automation%20builder-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/Automation%20builder-darkmode.png",
    },
    {
      id: "add-contacts",
      label: "Add Contacts",
      icon: <MdPersonAdd className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/add%20contacts-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/add%20contacts-darkmode.png",
    },
    {
      id: "import-contacts",
      label: "Import Contacts",
      icon: <MdUpload className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/import%20contacts-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/import%20contacts-darkmode.png",
    },
    {
      id: "csv",
      label: "CSV",
      icon: <MdTableChart className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/csv-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/csv-darkmode.png",
    },
    {
      id: "segments",
      label: "Segments",
      icon: <MdCallSplit className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/segments-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/segments-darkmode.png",
    },
    {
      id: "tags",
      label: "Tags",
      icon: <MdLabel className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/tags-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/tags-darkmode.png",
    },
    {
      id: "create-forms",
      label: "Create Forms",
      icon: <MdDescription className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/create%20forms-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/create%20forms-darkmode.png",
    },
    {
      id: "email-template-builder",
      label: "Email Template Builder",
      icon: <MdEmail className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/email%20template%20builder-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/email%20template%20builder-darkmode.png",
    },
    {
      id: "saved-templates",
      label: "Saved Templates",
      icon: <MdSave className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/saved%20templates-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/saved%20templates-darkmode.png",
    },
  ];

  const features1 = [
    {
      icon: <Mail className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Email Builder",
      description: "Drag-&-drop editor with AI copy generator and templates.",
    },
    {
      icon: <FileText className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Templates",
      description:
        "Prebuilt email and landing page templates for fast launches.",
    },
    {
      icon: <Zap className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "AI Tools",
      description: "Generate subject lines, body copy and content suggestions.",
    },
    {
      icon: <Search className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "SEO & Send Tests",
      description:
        "Subject-line tests, deliverability checks and SEO tips for pages.",
    },
  ];

  const features2 = [
    {
      icon: <Layout className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Automation Builder",
      description: "No-code visual flows: triggers, conditions and actions.",
    },
    {
      icon: <Repeat className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Drip & Sequences",
      description: "Create multi-step nurture sequences and autoresponders.",
    },
    {
      icon: <Users className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Segmentation",
      description: "Filter and target audiences with custom segments.",
    },
    {
      icon: <Calendar className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Scheduling & A/B",
      description: "A/B subject tests, send-time optimization and calendars.",
    },
  ];

  const features3 = [
    {
      icon: <Globe className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Multi-channel",
      description: "Email, social posts, SMS and landing pages from one place.",
    },
    {
      icon: <Monitor className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Ads & Integrations",
      description: "Connect Google/Facebook ad flows and 300+ apps.",
    },
    {
      icon: (
        <ShoppingCart className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Ecommerce",
      description: "Templates, carts, & automations for product journeys.",
    },
    {
      icon: (
        <Smartphone className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Mobile-ready",
      description:
        "Responsive pages, mobile previews and push-ready templates.",
    },
  ];

  const features4 = [
    {
      icon: <BarChart className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Analytics",
      description: "Open/click/exposure reports, cohort and revenue tracking.",
    },
    {
      icon: (
        <TrendingUp className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Growth Tools",
      description: "Lookalike audiences, ad targeting and performance tips.",
    },
    {
      icon: <Database className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Integrations",
      description: "Connect CRMs, stores, analytics and storage providers.",
    },
    {
      icon: (
        <ShieldCheck className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Security & Compliance",
      description: "DKIM/SPF/DMARC, role-based access and data controls.",
    },
  ];
  const [productsOpen, setProductsOpen] = useState(false);
  const productsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (
        productsRef.current &&
        !productsRef.current.contains(event.target as Node)
      ) {
        setProductsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);

  const testimonials = [
    {
      text: "Campaigns helped us boost conversion rates — email-driven revenue increased 27% in three months. Templates and automations saved hours weekly.",
      name: "Amir Khan",
      title: "Head of Marketing, Radiant Retail",
      date: "Jul 5, 2025",
      logo: campaigns1,
      recommendNote: "Higher conversions & faster launches",
    },
    {
      text: "The automation builder made lead nurturing simple. We moved prospects through personalized flows and doubled demo signups.",
      name: "Norma Moreno",
      title: "Growth Lead, ApexFlow",
      date: "Jun 20, 2025",
      logo: campaigns2,
      recommendNote: "Essential for growth marketing",
    },
    {
      text: "Easy A/B testing and clear reporting let us optimize subject lines and timing — open rates rose significantly.",
      name: "Maya Chen",
      title: "Acquisition Manager, NextWave",
      date: "May 30, 2025",
      logo: campaigns3,
      recommendNote: "Actionable analytics",
    },
    {
      text: "Multi-channel scheduling (email + social) and ad integrations saved our team days of manual work each month.",
      name: "Lucas Grant",
      title: "IT Director, SkyBridge",
      date: "Apr 18, 2025",
      logo: campaigns4,
      recommendNote: "Great for cross-channel teams",
    },
    {
      text: "Our event pages + payment flows launched in one afternoon — event signups and revenue both scaled up.",
      name: "Sofia Ramirez",
      title: "Head of Events, BuildSphere",
      date: "Mar 8, 2025",
      logo: campaigns5,
      recommendNote: "Fast launches for events & promos",
    },
  ];

  const [idx, setIdx] = useState(0);
  const { text, name, title, date, logo, recommendNote } = testimonials[idx];

  const prev = () =>
    setIdx((idx - 1 + testimonials.length) % testimonials.length);
  const next = () => setIdx((idx + 1) % testimonials.length);

  const [isAnnual, setIsAnnual] = useState(true);

  const monthlyPlans = [
    {
      name: "Lite",
      description: "Ideal for beginners",
      price: "$17",
      pricePeriod: "per month",
      buttonText: "Start Lite",
      buttonVariant: "outline",
      badge: null,
      features: [
        { icon: MailIcon, text: "", subtext: "All Features Included" },
        { icon: UserIcon, text: "", subtext: "Live 1:1 onboarding" },
        { icon: PhoneIcon, text: "", subtext: "Phone & chat support" },
        { icon: DragIcon, text: "", subtext: "Drag-&-drop email editor" },
        { icon: SparklesIcon, text: "", subtext: "AI copy generator" },
        { icon: TemplateIcon, text: "", subtext: "Basic email templates" },
        { icon: CalendarIcon, text: "", subtext: "Social post automation" },
        { icon: ChartIcon, text: "", subtext: "Basic reporting analytics" },
        { icon: AutomationIcon, text: "", subtext: "1 automation template" },
        { icon: FormsIcon, text: "", subtext: "Web signup forms" },
        { icon: SegmentIcon, text: "", subtext: "1 custom segment" },
        { icon: IntegrationIcon, text: "", subtext: "300+ app integrations" },
      ],
      highlighted: false,
    },
    {
      name: "Standard",
      description: "Great for most businesses",
      price: "$48",
      pricePeriod: "per month",
      buttonText: "Start Standard",
      buttonVariant: "primary",
      badge: "BEST VALUE",
      features: [
        { icon: MailIcon, text: "", subtext: "All Features Included" },
        { icon: UserIcon, text: "", subtext: "Live 1:1 onboarding" },
        { icon: PhoneIcon, text: "", subtext: "Phone & chat support" },
        { icon: Schedule, text: "", subtext: "Email scheduling & A/B" },
        { icon: TemplateIcon, text: "", subtext: "Advanced email templates" },
        { icon: CalendarIcon, text: "", subtext: "Social post scheduling" },
        {
          icon: ChartIcon,
          text: "",
          subtext: "Advanced reporting (opens/clicks)",
        },
        { icon: AutomationIcon, text: "", subtext: "3 automation templates" },
        { icon: ResendIcon, text: "", subtext: "Auto resend to non-openers" },
        { icon: SegmentIcon, text: "", subtext: "10 custom segments" },
        { icon: AdsIcon, text: "", subtext: "Facebook lookalike & ads" },
        { icon: GoogleAdsIcon, text: "", subtext: "Google Ad Manager" },
        { icon: IntegrationIcon, text: "", subtext: "300+ app integrations" },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Premium",
      description: "Ideal for pros",
      price: "$109",
      pricePeriod: "per month",
      buttonText: "Start Premium",
      buttonVariant: "outline",
      badge: null,
      features: [
        { icon: MailIcon, text: "", subtext: "All Features Included" },
        { icon: HandshakeIcon, text: "", subtext: "Priority onboarding" },
        { icon: StarIcon, text: "", subtext: "Dedicated priority support" },
        { icon: DynamicIcon, text: "", subtext: "Dynamic email content" },
        {
          icon: TemplateIcon,
          text: "",
          subtext: "All Standard email features",
        },
        {
          icon: SocialAdvancedIcon,
          text: "",
          subtext: "Advanced social tools",
        },
        {
          icon: ChartComprehensiveIcon,
          text: "",
          subtext: "Comprehensive reporting",
        },
        {
          icon: AutomationUnlimitedIcon,
          text: "",
          subtext: "Unlimited automation templates",
        },
        { icon: AutomationIcon, text: "", subtext: "Custom automations" },
        { icon: EcommerceIcon, text: "", subtext: "Ecommerce templates" },
        { icon: WelcomeIcon, text: "", subtext: "Auto-send welcome emails" },
        {
          icon: SegmentUnlimitedIcon,
          text: "",
          subtext: "Unlimited custom segments",
        },
        { icon: AdsAdvancedIcon, text: "", subtext: "Advanced ad targeting" },
        { icon: SeoIcon, text: "", subtext: "Premium SEO tools" },
        { icon: IntegrationIcon, text: "", subtext: "300+ app integrations" },
      ],
      highlighted: false,
    },
  ];
  const annualPlans = [
    {
      name: "Lite",
      description: "Ideal for beginners",
      price: "$8.50",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start Lite",
      buttonVariant: "outline",
      badge: null,
      features: [
        { icon: MailIcon, text: "", subtext: "All Features Included" },
        { icon: UserIcon, text: "", subtext: "Live 1:1 onboarding" },
        { icon: PhoneIcon, text: "", subtext: "Phone & chat support" },
        { icon: DragIcon, text: "", subtext: "Drag-&-drop email editor" },
        { icon: SparklesIcon, text: "", subtext: "AI copy generator" },
        { icon: TemplateIcon, text: "", subtext: "Basic email templates" },
        { icon: CalendarIcon, text: "", subtext: "Social post automation" },
        { icon: ChartIcon, text: "", subtext: "Basic reporting analytics" },
        { icon: AutomationIcon, text: "", subtext: "1 automation template" },
        { icon: FormsIcon, text: "", subtext: "Web signup forms" },
        { icon: SegmentIcon, text: "", subtext: "1 custom segment" },
        { icon: IntegrationIcon, text: "", subtext: "300+ app integrations" },
      ],
      highlighted: false,
    },
    {
      name: "Standard",
      description: "Great for most businesses",
      price: "$24",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start Standard",
      buttonVariant: "primary",
      badge: "BEST VALUE",
      features: [
        { icon: MailIcon, text: "", subtext: "All Features Included" },
        { icon: UserIcon, text: "", subtext: "Live 1:1 onboarding" },
        { icon: PhoneIcon, text: "", subtext: "Phone & chat support" },
        { icon: Schedule, text: "", subtext: "Email scheduling & A/B" },
        { icon: TemplateIcon, text: "", subtext: "Advanced email templates" },
        { icon: CalendarIcon, text: "", subtext: "Social post scheduling" },
        {
          icon: ChartIcon,
          text: "",
          subtext: "Advanced reporting (opens/clicks)",
        },
        { icon: AutomationIcon, text: "", subtext: "3 automation templates" },
        { icon: ResendIcon, text: "", subtext: "Auto resend to non-openers" },
        { icon: SegmentIcon, text: "", subtext: "10 custom segments" },
        { icon: AdsIcon, text: "", subtext: "Facebook lookalike & ads" },
        { icon: GoogleAdsIcon, text: "", subtext: "Google Ad Manager" },
        { icon: IntegrationIcon, text: "", subtext: "300+ app integrations" },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Premium",
      description: "Ideal for pros",
      price: "$54.50",
      pricePeriod: "per month (billed annually)",
      buttonText: "Start Premium",
      buttonVariant: "outline",
      badge: null,
      features: [
        { icon: MailIcon, text: "", subtext: "All Features Included" },
        { icon: HandshakeIcon, text: "", subtext: "Priority onboarding" },
        { icon: StarIcon, text: "", subtext: "Dedicated priority support" },
        { icon: DynamicIcon, text: "", subtext: "Dynamic email content" },
        {
          icon: TemplateIcon,
          text: "",
          subtext: "All Standard email features",
        },
        {
          icon: SocialAdvancedIcon,
          text: "",
          subtext: "Advanced social tools",
        },
        {
          icon: ChartComprehensiveIcon,
          text: "",
          subtext: "Comprehensive reporting",
        },
        {
          icon: AutomationUnlimitedIcon,
          text: "",
          subtext: "Unlimited automation templates",
        },
        { icon: AutomationIcon, text: "", subtext: "Custom automations" },
        { icon: EcommerceIcon, text: "", subtext: "Ecommerce templates" },
        { icon: WelcomeIcon, text: "", subtext: "Auto-send welcome emails" },
        {
          icon: SegmentUnlimitedIcon,
          text: "",
          subtext: "Unlimited custom segments",
        },
        { icon: AdsAdvancedIcon, text: "", subtext: "Advanced ad targeting" },
        { icon: SeoIcon, text: "", subtext: "Premium SEO tools" },
        { icon: IntegrationIcon, text: "", subtext: "300+ app integrations" },
      ],
      highlighted: false,
    },
  ];

  const [openFAQ, setOpenFAQ] = useState<number | null>(0);
  const faqs = [
    {
      question: "How do I launch my first campaign?",
      answer:
        "Quick start: create an account, import contacts or add a signup form, pick a template, and press send. We provide step-by-step guides, templates, and 1:1 onboarding for Live plans.",
    },
    {
      question: "Can I connect Campaigns to my CRM or store?",
      answer:
        "Yes — connect CRMs, ecommerce platforms, and analytics tools via native integrations or webhooks to sync contacts, events, and conversions in real time.",
    },
    {
      question: "How do you handle deliverability & compliance?",
      answer:
        "We follow email best practices (DKIM/SPF/DMARC), provide deliverability guidance, and offer suppression lists, unsubscribe handling, and GDPR-ready controls.",
    },
    {
      question: "Can I automate sequences and A/B tests?",
      answer:
        "Absolutely — build drip sequences with the visual automation builder, run A/B subject-line and send-time tests, and auto-resend to non-openers.",
    },
    {
      question: "Are there templates and design tools?",
      answer:
        "Yes — use our drag-and-drop editor, AI copy-generator, and library of templates for emails, landing pages and event pages to launch faster.",
    },
    {
      question: "Is there a mobile app or mobile dashboard?",
      answer:
        "You can manage campaigns from mobile web and get notifications; full desktop features are available in the web dashboard. Mobile work supports quick edits and approvals.",
    },
    {
      question: "What support and SLA are included?",
      answer:
        "All plans include email docs and knowledge base. Higher tiers include priority onboarding, phone & chat support, and dedicated success managers for enterprises.",
    },
  ];

  const isDarkMode = theme === "dark";
  const [dotsOpen, setDotsOpen] = useState(false);
  const dotsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (dotsRef.current && !dotsRef.current.contains(event.target as Node)) {
        setDotsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);
  const redirectToSignup = (planName: string, cycle: "monthly" | "annual") => {
    const base = "https://campaigns.clikkle.com/signup";
    const params = new URLSearchParams({
      theme: theme ?? "",
      plan: planName,
      cycle,
    });
    window.location.replace(`${base}?${params.toString()}`);
  };
  const [announcementOpen, setAnnouncementOpen] = useState(false);

  useEffect(() => {
    const checkHeight = () => {
      const el = document.querySelector("[data-announcement]") as HTMLElement;
      if (el && el.offsetHeight > 0) {
        setAnnouncementOpen(true);
      } else {
        setAnnouncementOpen(false);
      }
    };
    checkHeight();
    const observer = new MutationObserver(checkHeight);
    observer.observe(document.body, { childList: true, subtree: true });
    return () => observer.disconnect();
  }, []);

  useEffect(() => {
    const checkDismissedAnnouncements = () => {
      const dismissed = getCookie("dismissedAnnouncements");
      if (dismissed) {
        try {
          const dismissedIds = JSON.parse(dismissed);
          if (dismissedIds.length > 0) {
            setAnnouncementOpen(false);
          }
        } catch (error) {
          console.error("Error parsing dismissed announcements:", error);
        }
      }
    };

    checkDismissedAnnouncements();

    const interval = setInterval(checkDismissedAnnouncements, 1000);

    return () => clearInterval(interval);
  }, []);
  return (
    <div className="bg-white dark:bg-[#1a1a1a] flex flex-col items-center w-full min-h-screen">
      <div className="w-full max-w-[1540px] relative mx-auto flex flex-col items-center justify-center">
        <section className="w-full">
          <section className="relative w-full  md:min-h-[1038px] overflow-hidden">
            <div
              className={`fixed top-0 inset-x-0 z-50 ${scrolled
                  ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1a1a]/90"
                  : productsOpen || dotsOpen
                    ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1a1a]/90"
                    : ""
                }`}
            >
              <div
                ref={(el) => {
                  if (el) {
                    const height = el.getBoundingClientRect().height;

                    if (height !== 0) {
                      setAnnouncementOpen(true);
                    }
                  }
                }}
              >
                <AnnouncementBar onClose={() => setAnnouncementOpen(false)} />
              </div>
              <div className="container max-w-[1233px] mx-auto max-[1300px]:px-14 max-[1100px]:px-4">
                <nav
                  className={`relative flex items-center justify-between py-4`}
                >
                  <ClikkleLogo />
                  <div className="flex md:hidden items-center">
                    <div
                      className="flex items-center gap-0 rounded-xl border border-gray-300 dark:border-[#ffffff3a] p-[8px] shadow-sm"
                      onClick={toggleLeftDrawer}
                    >
                      <p className="text-sm font-medium text-gray-900 dark:text-white">
                        <Logs className="w-5 h-5 text-gray-900 dark:text-white mr-3" />
                      </p>

                      <p className="flex items-center  rounded-xl text-sm font-bold ">
                        Menu
                      </p>
                    </div>
                  </div>

                  <div className="hidden md:flex items-center gap-12  font-inter font-medium text-[18px]">
                    <Link
                      href="#features"
                      className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                    >
                      Features
                    </Link>
                    <Link
                      href="#pricing"
                      className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                    >
                      Pricing
                    </Link>
                    <Link
                      href="/blogs"
                      className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                    >
                      Blog
                    </Link>
                    <div className="flex flex-row justify-center items-center">
                      <div className="relative" ref={productsRef}>
                        <button
                          onClick={() => setProductsOpen((o) => !o)}
                          className="cursor-pointer flex items-center gap-1 text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                        >
                          Products
                        </button>
                        {productsOpen && (
                          <div
                            className={`fixed ${announcementOpen ? "top-[115px]" : "top-[75px]"
                              } 
              left-1/2 transform -translate-x-1/2 w-full bg-white/90 dark:bg-[#1a1a1a]/90 backdrop-blur-md 
              shadow-lg p-6 border-b-2 border-gray-300 dark:border-[#575662] z-50 flex justify-center items-center pb-0`}
                          >
                            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                              <div className="flex flex-col gap-3">
                                {apps
                                  .slice(0, Math.ceil(apps.length / 2))
                                  .map((product) => (
                                    <Link
                                      key={product.id}
                                      href={product.route}
                                      className="flex items-center gap-4 p-[0.35rem] rounded-lg hover:bg-gray-100 dark:hover:bg-white/10 transition"
                                    >
                                      <div>
                                        <Image
                                          src={product.image}
                                          alt={product.title}
                                          className="w-[26px]"
                                          width={26}
                                          height={26}
                                        />
                                      </div>
                                      <div>
                                        <p className="font-bold text-gray-900 dark:text-white text-sm">
                                          {product.title}
                                        </p>
                                        <p className="text-xs text-gray-600 dark:text-gray-300">
                                          {product.description}
                                        </p>
                                      </div>
                                    </Link>
                                  ))}
                              </div>

                              <div className="flex flex-col gap-3">
                                {apps
                                  .slice(
                                    Math.ceil(apps.length / 2),
                                    Math.ceil(apps.length / 2) + 2,
                                  )
                                  .map((product) => (
                                    <Link
                                      key={product.id}
                                      href={product.route}
                                      className="flex items-center gap-4 p-[0.35rem] rounded-lg hover:bg-gray-100 dark:hover:bg-white/10 transition"
                                    >
                                      <div>
                                        <Image
                                          src={product.image}
                                          alt={product.title}
                                          className="w-[26px]"
                                          width={26}
                                          height={26}
                                        />
                                      </div>
                                      <div>
                                        <p className="font-bold text-gray-900 dark:text-white text-sm">
                                          {product.title}
                                        </p>
                                        <p className="text-xs text-gray-600 dark:text-gray-300">
                                          {product.description}
                                        </p>
                                      </div>
                                    </Link>
                                  ))}
                                <Link href="/products">
                                  <Button
                                    style={{ marginTop: "5px" }}
                                    variant="ghost"
                                    className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                  >
                                    View all products
                                    <ArrowRightIcon className="h-2 w-2 dark:text-white" />
                                  </Button>
                                </Link>
                              </div>
                              <div className="hidden lg:flex flex-row items-center justify-center text-center gap-3">
                                <Image
                                  src={
                                    "https://cdn.clikkle.com/images/campaigns/illustration/campaigns6.png"
                                  }
                                  alt="Illustration"
                                  className="w-auto h-[175px]"
                                  width={200}
                                  height={175}
                                />
                                <div className="flex flex-col justify-center items-center h-full">
                                  <p className="text-sm text-gray-700 dark:text-gray-300 max-w-[200px] pb-5">
                                    Get started today the modern solution to
                                    power your business.
                                  </p>
                                  <Button
                                    variant="ghost"
                                    onClick={() => {
                                      window.location.replace(
                                        "https://campaigns.clikkle.com/signup?theme=" +
                                        theme +
                                        "&referralApp=" +
                                        getEncodedReferrer()
                                      );
                                    }}
                                    className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                  >
                                    Get Started Today
                                    <ArrowRightIcon
                                      className={`h-2 w-2 dark:text-white`}
                                    />
                                  </Button>
                                </div>
                              </div>
                            </div>
                          </div>
                        )}
                      </div>

                      <div className="relative" ref={dotsRef}>
                        <Ellipsis
                          onClick={() => setDotsOpen((o) => !o)}
                          className="w-8 h-6 rounded-full p-[1px] cursor-pointer"
                        />
                        {dotsOpen && (
                          <div
                            className={`fixed ${announcementOpen ? "top-[115px]" : "top-[75px]"
                              }  left-1/2 transform -translate-x-1/2 w-full 
    bg-white/90 dark:bg-[#1a1a1a]/90 backdrop-blur-md 
    shadow-lg border-b-2 border-gray-300 dark:border-[#575662] 
    z-50 flex justify-center`}
                          >
                            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 py-6">
                              <div className="flex flex-col md:flex-row justify-between items-start gap-12">
                                <div className="space-y-12">
                                  <div className="max-w-[285px] space-y-2 mb-0">
                                    <h3 className="font-instrument-sans font-medium text-[18px] leading-[20px] text-gray-900 dark:text-[#eeeef0]">
                                      Get Started For Free
                                    </h3>
                                    <p className="font-body-medium text-[#51515E] dark:text-[#eeeef0]">
                                      Streamline your Business with our Apps.
                                      Effortlessly for every team.
                                    </p>
                                  </div>
                                  <Button
                                    style={{ marginTop: "20px" }}
                                    variant="ghost"
                                    onClick={() => {
                                      window.location.replace(
                                        "https://campaigns.clikkle.com/signup?theme=" +
                                        theme +
                                        "&referralApp=" +
                                        getEncodedReferrer()
                                      );
                                    }}
                                    className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                  >
                                    See How It Works
                                    <ArrowRightIcon
                                      className={`h-2 w-2 dark:text-white`}
                                    />
                                  </Button>
                                </div>

                                <div className="flex flex-wrap gap-x-14 gap-y-8 text-xs sm:text-sm">
                                  {footerColumns.map((column, index) => (
                                    <div
                                      key={index}
                                      className="flex flex-col gap-5"
                                    >
                                      <h4 className="font-label-medium text-gray-900 dark:text-white">
                                        {column.title}
                                      </h4>
                                      <ul className="flex flex-col gap-4">
                                        {column.links.map((link, linkIndex) => (
                                          <li key={linkIndex}>
                                            <div className="flex items-start gap-3">
                                              <Link
                                                href={link.url}
                                                target={
                                                  link.url.startsWith("http")
                                                    ? "_blank"
                                                    : "_self"
                                                }
                                                rel={
                                                  link.url.startsWith("http")
                                                    ? "noopener noreferrer"
                                                    : undefined
                                                }
                                                className="font-body-medium text-[#51515E] dark:text-[#d7d7de] hover:text-gray-900 dark:hover:text-white transition-colors whitespace-nowrap flex items-center gap-2"
                                              >
                                                {link.text}
                                                {column.title === "Social" && (
                                                  <FaArrowRight className="w-2 h-2" />
                                                )}
                                              </Link>

                                              {link.isNew && (
                                                <div className="hidden md:flex items-center gap-2">
                                                  <div className="w-4 h-4 flex items-center justify-center">
                                                    <div className="w-[13px] h-[13px] bg-[#c3e6ff] rounded-[6.67px] flex items-center justify-center">
                                                      <div className="w-1 h-1 bg-[#286efb] rounded-sm" />
                                                    </div>
                                                  </div>
                                                  <span className="font-body-medium text-gray-900 dark:text-white whitespace-nowrap">
                                                    New
                                                  </span>
                                                </div>
                                              )}
                                            </div>
                                          </li>
                                        ))}
                                      </ul>
                                    </div>
                                  ))}
                                </div>
                              </div>
                            </div>
                          </div>
                        )}
                      </div>
                    </div>
                  </div>

                  <div className="hidden md:flex items-center gap-4">
                    <div className="hidden md:flex items-center gap-4">
                      <div className="w-6">
                        <ThemeSwitch />
                      </div>
                      <div className="flex items-center gap-2 rounded-xl border border-gray-300 dark:border-[#ffffff3a] p-1 shadow-sm">
                        <button
                          className="cursor-pointer px-3 py-1 text-sm font-medium text-gray-900 dark:text-white"
                          onClick={() => {
                            window.location.replace(
                              "https://campaigns.clikkle.com/login?theme=" +
                              theme +
                              "&referralApp=" +
                              getEncodedReferrer()
                            );
                          }}
                        >
                          Login
                        </button>

                        <button
                          className="cursor-pointer flex items-center gap-1 rounded-xl bg-[#286efb] hover:bg-[#3367d6] px-4 py-1.5 text-sm font-medium text-white transition"
                          onClick={() => {
                            window.location.replace(
                              "https://campaigns.clikkle.com/signup?theme=" +
                              theme +
                              "&referralApp=" +
                              getEncodedReferrer()
                            );
                          }}
                        >
                          Try for free
                          <span>
                            <ArrowRightIcon className="w-4" />
                          </span>
                        </button>
                      </div>
                    </div>
                  </div>
                </nav>
              </div>
            </div>

            <div
              className={`z-10 flex flex-col items-center text-center ${announcementOpen ? "pt-[140px]" : "pt-[110px]"
                } px-6 relative`}
            >
              <div className="absolute h-full w-full top-0 right-0 ">
                <Image
                  src={ShadowVector}
                  alt="Shadow vector"
                  className="w-full h-full"
                  width={1920}
                  height={1080}
                />
              </div>
              <div className="flex items-center justify-center gap-2 mb-2 font-semibold py-4">
                <Link href="/">
                  <div className="flex items-center justify-center md:w-[245px] w-auto">
                    <Image
                      className="h-[32px] md:h-[40px] w-auto"
                      alt="Clikkle Campaigns logo"
                      width={114}
                      height={40}
                      src={
                        isDarkMode
                          ? "https://cdn.clikkle.com/images/campaigns/logo/2025/Clikkle%20Campaigns%20Blue%20(%20White%20Text).png"
                          : "https://cdn.clikkle.com/images/campaigns/logo/2025/Clikkle%20Campaigns%20Blue%20(%20Black%20Text).png"
                      }
                    />
                  </div>
                </Link>
              </div>
              <h1 className="font-inter font-black text-[40px] lg:text-7xl text-gray-900 dark:text-[#fff] mb-3 md:mb-[0.5rem] max-w-5xl leading-[1.1] md:leading-[1]">
                <span className={`dark:text-[#A9C5FF] text-[#286efb]`}>
                  Automation{" "}
                </span>
                for
                <br className="hidden sm:block" /> Marketing Teams
              </h1>
              <span className="relative font-small text-[14px] md:text-[18px] text-[#3D3D3D] dark:text-[#EEEEF0] mb-8 max-w-3xl">
                Grow with tools for web, social, chat, and text. Connect at{" "}
                <br className="hidden sm:block" />
                every stage of the customer journey.
                {/*<img
                    src={"/images/arrow-1.png"}
                    alt="arrow"
                    className="hidden sm:block absolute right-[-112px] top-[0px] rotate-[330deg]"
                  />*/}
                {/*<div className="absolute right-[-290px] top-[40px] hidden sm:block">
                   <p className="text-[#51515E] dark:text-[#d7d7de] text-[24px] font-black font-caveat">
                    $ 8.50  / month <br />
                    for Clikkle eSign
                  </p>
                </div>*/}
              </span>
              <div className="flex flex-col sm:flex-row items-center !gap-[8px] sm:gap-4 mb-4 w-full max-w-lg z-10">
                <input
                  type="email"
                  placeholder="Enter Your Email"
                  className="flex-1 px-4 py-3 rounded-lg bg-white text-gray-900 placeholder-gray-500 dark:placeholder-gray-400 focus:outline-none w-full border border-gray-300 dark:border-[#575662] shadow-sm dark:shadow-none"
                />
                <button
                  onClick={() => {
                    window.location.replace(
                      "https://campaigns.clikkle.com/signup?theme=" + theme +
                      "&referralApp=" +
                      getEncodedReferrer()
                    );
                  }}
                  type="submit"
                  className="cursor-pointer px-6 py-[14px] bg-[#25272c] dark:bg-[#286efb] text-white font-medium rounded-lg transition w-full sm:w-auto"
                >
                  Try for Free
                </button>
              </div>{" "}
              <p className="text-[#51515E] dark:text-[#d7d7de] text-sm mb-[0.5rem] z-10">
                No credit card required.{" "}
                <Link
                  href={`${"https://worksuite.clikkle.com/signup?theme=" + theme +
                    "&referralApp=" +
                    getEncodedReferrer()
                    }`}
                  className="text-black dark:text:white dark:text-white underline hover:no-underline hover:cursor-pointer"
                >
                  Sign Up for no cost
                </Link>
              </p>
              <div className="flex flex-col sm:flex-row items-center gap-2 md:gap-16">
                {/*<span className="text-[#51515E] dark:text-[#D7D7DE] text-sm">
                  Trusted by{" "}
                  <span className="dark:text-[#A9C5FF] text-[#286efb]">
                    4K+
                  </span>{" "}
                  companies
                </span>*/}
                <div className="flex items-center gap-8">
                  {/*<Image
                    src={theme === "dark" ? logosDark : logosLight}
                    alt="Logos"
                    className="h-[36px] w-[242px]"
                    width={162}
                    height={36}
                  />*/}
                </div>
              </div>
            </div>
            <div className="flex items-center justify-center pb-8 mt-8 rounded-lg w-full">
              <div className="relative w-full max-w-[1200px]">
                {/*<img
                  src={popImg.src}
                  alt="popImg"
                  className="hidden sm:block absolute w-[120px] left-[-70px] top-[-74px]"
                />*/}
                <MacWindowCarousel initialProduct="campaigns" />
              </div>
            </div>
            {/* <div className="flex items-center justify-center pb-8 mt-8 rounded-lg w-full md:w-auto">
              <div className="relative w-full flex justify-center">
                <TabbedFeature
                  tabs={tabFeatures}
                  decorator={
                    <Image
                      src={popImg}
                      alt="popImg"
                      className="hidden sm:block absolute w-[120px] left-[-70px] top-[-74px] z-10"
                      width={120}
                      height={120}
                    />
                  }
                />
              </div>
            </div> */}
          </section>
        </section>

        <section className="w-full max-w-[1240px] text-gray-900 dark:text-white py-16 px-4 md:px-8 lg:px-16 m-auto">
          <div className="mx-auto text-center">
            <h2 className="text-sm md:text-base font-semibold text-[#286efb] dark:text-[#adc4fb] mb-4 ">
              Why Clikkle Campaigns?
            </h2>

            <h1 className="text-4xl md:text-5xl font-[1000] mb-4  ">
              Automate, optimize, and grow
            </h1>

            <p className="text-lg md:text-xl text-gray-600 dark:text-gray-300 mb-12">
              Email, social, landing pages, and analytics — all in one place.
            </p>

            <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8 mb-16">
              <div className="flex flex-col items-center">
                <div className="bg-gray-100 dark:bg-[#141414] rounded-2xl p-4 mb-4">
                  <MessageCircle className="w-8 h-8 text-gray-600 dark:text-gray-300" />
                </div>
                <h2 className="text-xl font-semibold mb-2">Email Builder</h2>
                <p className="text-gray-600 dark:text-gray-400 text-center">
                  Drag-&-drop editor with AI copy tools.
                </p>
              </div>

              <div className="flex flex-col items-center">
                <div className="bg-gray-100 dark:bg-[#141414] rounded-2xl p-4 mb-4">
                  <Globe className="w-8 h-8 text-gray-600 dark:text-gray-300" />
                </div>
                <h2 className="text-xl font-semibold mb-2">Multi-channel</h2>
                <p className="text-gray-600 dark:text-gray-400 text-center">
                  Email, social, SMS, and landing pages.
                </p>
              </div>

              <div className="flex flex-col items-center">
                <div className="bg-gray-100 dark:bg-[#141414] rounded-2xl p-4 mb-4">
                  <Bolt className="w-8 h-8 text-gray-600 dark:text-gray-300" />
                </div>
                <h2 className="text-xl font-semibold mb-2">Automations</h2>
                <p className="text-gray-600 dark:text-gray-400 text-center">
                  No-code workflows and triggers.
                </p>
              </div>

              <div className="flex flex-col items-center">
                <div className="bg-gray-100 dark:bg-[#141414] rounded-2xl p-4 mb-4">
                  <ChartBar className="w-8 h-8 text-gray-600 dark:text-gray-300" />
                </div>
                <h2 className="text-xl font-semibold mb-2">Analytics</h2>
                <p className="text-gray-600 dark:text-gray-400 text-center">
                  Open/click reports and exports.
                </p>
              </div>
            </div>

            <div className="md:mt-36 font-bold border-gray-300 dark:border-[#575662] max-w-[1120px] mx-auto bg-[#20253a] text-white min-h-[35px] dark:bg-[#141414] rounded-2xl p-6 shadow-lg flex flex-col md:flex-row items-center gap-6 overflow-visible relative">
              <Image
                src={AfterHeroSection}
                alt="Use case preview"
                className="md:w-[260px] md:h-[330px] w-full h-auto rounded-lg md:object-cover md:ml-[1.7rem] md:mt-[-5.3rem] md:transform md:-rotate-3 md:scale-110 shadow-2xl md:z-20"
              />

              <div className="text-left md:p-[60px]">
                <p className="text-lg md:text-2xl !text-[1.40rem] mb-4 leading-normal">
                  Clikkle Campaigns helps teams launch high-performing
                  campaigns. <br className="hidden sm:block" />
                  <span className="bg-[#3d0ebf] font-semibold">
                    Conversions improved and workflows run automatically.
                  </span>
                </p>
                <div className="flex items-center gap-2">
                  <Image
                    src={wsj}
                    alt="partner logo"
                    className="w-8 h-8 rounded-sm"
                  />
                  <div>
                    <p className="font-semibold">Radiant Retail</p>
                    <p className="text-sm">Head of Marketing</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-[#1a1a1a]"
            id="features"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center sm:gap-[8rem]">
                <div className="space-y-8 justify-self-start">
                  <div className="space-y-4">
                    <span className="hidden md:block text-[#286efb] dark:text-[#A9C5FF] text-[16px] font-bold">
                      Feature
                    </span>
                    <h2 className="text-[1.6rem] md:text-5xl text-gray-900 mt-4 md:mt-0  dark:text-white !leading-[1.2] font-inter font-[900]">
                      Use{" "}
                      <span className="text-[#286efb] dark:text-[#A9C5FF]">
                        Workflows{" "}
                      </span>{" "}
                      to <br className="hidden sm:block" /> save time
                    </h2>

                    <p className="text-gray-600 dark:text-[#d7d7de] max-w-lg font-inter font-normal text-[16px] md:text-[18px]     ">
                      Nurture leads automatically with personalized workflows
                      that drive engagement and action.
                    </p>
                  </div>

                  <div className="grid grid-cols-2 gap-6 max-w-[529px]">
                    {features1.map((feature, index) => (
                      <div key={index} className="md:space-y-1">
                        <div className="flex items-center gap-3">
                          <div className="w-4 h-4 rounded-lg flex items-center justify-center text-gray-600 dark:text-[#d7d7de]">
                            {feature.icon}
                          </div>
                          <h3 className="text-gray-900 dark:text-[#d7d7de] text-lg font-open-sauce font-black text-[1.16rem]  ">
                            {feature.title}
                          </h3>
                        </div>
                        <p className="text-gray-600 dark:text-[#d7d7de] text-[14px] leading-[20px] pl-[1.75rem] mt-0 font-inter font-normal">
                          {feature.description}
                        </p>
                      </div>
                    ))}
                  </div>
                  <div className="flex flex-row md:justify-start  gap-4 pt-4">
                    <Button
                      onClick={() => {
                        window.location.replace(
                          "https://campaigns.clikkle.com/signup?theme=" + theme +
                          "&referralApp=" +
                          getEncodedReferrer()
                        );
                      }}
                      className="cursor-pointer bg-[#286efb] hover:bg-[#3367d6] text-white px-8 py-3 h-[40px]"
                    >
                      Get Started
                    </Button>
                    <div className="pl-4 rounded-lg font-light md:block hidden text-gray-600 dark:text-[#d7d7de]">
                      <p className="text-sm leading-relaxed font-inter">
                        <span className="text-[#ff4b5c]">&quot;</span>
                        Build beautiful emails in minutes.
                        <span className="text-[#ff4b5c]">&quot;</span>
                      </p>
                      <div className="flex items-center gap-3 mt-[0.4rem]">
                        <Image
                          src={chat1}
                          alt="Lucas C."
                          width={24}
                          height={24}
                          className="w-6 h-6 rounded-full"
                        />
                        <div>
                          <p className="font-semibold text-sm">Lucas C.</p>
                          <p className="text-xs text-gray-400">
                            Head of Techincal Team
                          </p>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px]  justify-center md:justify-end order-first lg:order-none">
                  <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <FeaturedPic>
                    <Image
                      src={
                        theme === "dark"
                          ? "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/email%20template%20builder-darkmode.png"
                          : "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/email%20template%20builder-daymode.png"
                      }
                      width={600}
                      height={600}
                      alt="Campaigns picture"
                      className="rounded-lg shadow-lg mt-5 relative z-10  md:min-h-[345px]"
                    />
                  </FeaturedPic>
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-[#1a1a1a]"
            id="features2-2"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center">
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px]  justify-center md:justify-start order-first lg:order-none gap-2">
                  <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <FeaturedPic>
                    <Image
                      src={
                        theme === "dark"
                          ? "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/Automation%20builder-darkmode.png"
                          : "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/Automation%20builder-daymode.png"
                      }
                      width={600}
                      height={600}
                      alt="Campaigns picture"
                      className="rounded-lg shadow-lg mt-5 relative z-10  md:min-h-[345px]"
                    />
                  </FeaturedPic>
                </div>
                <div className="space-y-8 flex flex-col items-center md:items-end">
                  <div className="space-y-4">
                    <span className="hidden md:block text-[#286efb] dark:text-[#A9C5FF] text-[16px] font-bold">
                      Feature
                    </span>
                    <h2 className="text-left  text-[1.6rem] md:text-5xl text-gray-900 mt-4 md:mt-0  dark:text-white !leading-[1.2]  font-inter font-[900]  ">
                      <span className="text-[#286efb] dark:text-[#A9C5FF]">
                        Personalize experiences
                      </span>{" "}
                      <br className="hidden sm:block" />
                      across channels
                    </h2>

                    <p className="text-left text-gray-600 dark:text-[#d7d7de] max-w-lg font-inter font-normal text-[16px] md:text-[18px]     ">
                      Personalize your website and follow up across channels
                      with targeted messages based on user activity.
                    </p>
                  </div>

                  <div className="grid grid-cols-2 gap-6 max-w-[517px] justify-start items-start ">
                    {features2.map((feature, index) => (
                      <div key={index} className="md:space-y-1">
                        <div className="flex items-center gap-3">
                          <div className="w-4 h-4 rounded-lg flex items-center justify-center text-gray-600 dark:text-[#d7d7de]">
                            {feature.icon}
                          </div>
                          <h3 className="text-gray-900 dark:text-[#d7d7de] text-lg font-open-sauce font-black text-[1.16rem]  ">
                            {feature.title}
                          </h3>
                        </div>
                        <p className="text-gray-600 dark:text-[#d7d7de] text-[14px] leading-[20px] pl-[1.75rem] mt-0 font-inter font-normal">
                          {feature.description}
                        </p>
                      </div>
                    ))}

                    <div className="flex items-start gap-6 pt-4">
                      <div className="flex flex-row sm:flex-row sm:items-center gap-4">
                        <Button
                          onClick={() => {
                            window.location.replace(
                              "https://campaigns.clikkle.com/signup?theme=" +
                              theme
                            );
                          }}
                          className="bg-[#286efb] hover:bg-[#3367d6] text-white px-8 py-3 h-[40px]"
                          style={{
                            boxShadow: `
          0px 0.25px 0.25px 0px rgba(0,0,0,0.24),
          0px 0.75px 0.75px 0px rgba(0,0,0,0.12),
          0px 1px 1.5px -0.5px rgba(0,0,0,0.12),
          0px 2px 4px -1px rgba(0,0,0,0.12),
          0px 4px 8px -4px rgba(0,0,0,0.12),
          0px 8px 12px -4px rgba(0,0,0,0.06)
        `,
                          }}
                        >
                          Get Started
                        </Button>
                      </div>
                      <div className="pl-4 rounded-lg text-gray-600 dark:text-[#d7d7de] font-light hidden md:block max-w-[280px]">
                        <p className="text-sm leading-relaxed font-inter w-60">
                          <span className="text-[#ff4b5c]">&quot;</span>
                          One place for email, SMS & social.
                          <span className="text-[#ff4b5c]">&rdquo;</span>
                        </p>
                        <div className="flex items-center gap-3 mt-2">
                          <Image
                            src={chat1}
                            alt="Lucas C."
                            width={24}
                            height={24}
                            className="w-6 h-6 rounded-full"
                          />
                          <div>
                            <p className="font-semibold text-sm">Lucas C.</p>
                            <p className="text-xs text-gray-400">
                              Head of Techincal Team
                            </p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-[#1a1a1a]"
            id="features3-3"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center sm:gap-[8rem]">
                <div className="space-y-8 justify-self-start">
                  <div className="space-y-4">
                    {" "}
                    <span className="hidden md:block text-[#286efb] dark:text-[#A9C5FF] text-[16px] font-bold">
                      Feature
                    </span>
                    <h2 className="text-[1.6rem] md:text-5xl text-gray-900 mt-4 md:mt-0  dark:text-white !leading-[1.2]  font-inter font-[900]  ">
                      <span className="text-[#286efb] dark:text-[#A9C5FF]">
                        {" "}
                        Deliver free offers
                      </span>{" "}
                      and collect information.{" "}
                    </h2>
                    <p className="text-gray-600 dark:text-[#d7d7de] max-w-lg font-inter font-normal text-[16px] md:text-[18px]     ">
                      Capture leads with customizable forms and trigger
                      automations to deliver content and nurture them.
                    </p>
                  </div>

                  <div className="grid grid-cols-2 gap-6 max-w-[529px]">
                    {features3.map((feature, index) => (
                      <div key={index} className="md:space-y-1">
                        <div className="flex items-center gap-3">
                          <div className="w-4 h-4 rounded-lg flex items-center justify-center text-gray-600 dark:text-[#d7d7de]">
                            {feature.icon}
                          </div>
                          <h3 className="text-gray-900 dark:text-[#d7d7de] text-lg font-open-sauce font-black text-[1.16rem]  ">
                            {feature.title}
                          </h3>
                        </div>
                        <p className="text-gray-600 dark:text-[#d7d7de] text-[14px] leading-[20px] pl-[1.75rem] mt-0 font-inter font-normal">
                          {feature.description}
                        </p>
                      </div>
                    ))}
                  </div>
                  <div className="flex flex-row md:justify-start  gap-4 pt-4">
                    <Button
                      onClick={() => {
                        window.location.replace(
                          "https://campaigns.clikkle.com/signup?theme=" + theme +
                          "&referralApp=" +
                          getEncodedReferrer()
                        );
                      }}
                      className="bg-[#286efb] hover:bg-[#3367d6] text-white px-8 py-3 h-[40px]"
                    >
                      Get Started
                    </Button>
                    <div className="pl-4 rounded-lg text-gray-600 dark:text-[#d7d7de] font-light md:block hidden">
                      <p className="text-sm leading-relaxed font-inter">
                        <span className="text-[#ff4b5c]">&rdquo;</span>
                        Reports that make decisions obvious.
                        <span className="text-[#ff4b5c]">&rdquo;</span>
                      </p>
                      <div className="flex items-center gap-3 mt-[0.4rem]">
                        <Image
                          src={chat3}
                          alt="Maya C."
                          width={24}
                          height={24}
                          className="w-6 h-6 rounded-full"
                        />
                        <div>
                          <p className="font-semibold text-sm">Lucas G.</p>
                          <p className="text-xs text-gray-400">Growth Lead</p>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div className="w-full relative flex items-center justify-center md:justify-start order-first lg:order-none gap-[8rem] justify-self-end">
                  <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <FeaturedPic>
                    <Image
                      src={
                        theme === "dark"
                          ? "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/create%20forms-darkmode.png"
                          : "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/create%20forms-daymode.png"
                      }
                      width={600}
                      height={600}
                      alt="Campaigns picture"
                      className="rounded-lg shadow-lg mt-5 relative z-10  md:min-h-[345px]"
                    />
                  </FeaturedPic>
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-[#1a1a1a]"
            id="features4-4"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center">
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px]  justify-center md:justify-start order-first lg:order-none gap-2">
                  <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <FeaturedPic>
                    <Image
                      src={
                        theme === "dark"
                          ? "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/audience%20dash-darkmode.png"
                          : "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/campaigns/dedicated%20campaigns%20app/audience%20dash-daymode.png"
                      }
                      width={600}
                      height={600}
                      alt="Campaigns picture"
                      className="rounded-lg shadow-lg mt-5 relative z-10  md:min-h-[345px]"
                    />
                  </FeaturedPic>
                </div>
                <div className="space-y-8 flex flex-col items-center md:items-end">
                  <div className="space-y-4">
                    {" "}
                    <span className="hidden md:block text-[#286efb] dark:text-[#A9C5FF] text-[16px] font-bold">
                      Feature
                    </span>
                    <h2 className="text-left  text-[1.6rem] md:text-5xl text-gray-900 mt-4 md:mt-0  dark:text-white !leading-[1.2]  font-inter font-[900]  ">
                      <span className="text-[#286efb] dark:text-[#A9C5FF]">
                        Reach people
                      </span>{" "}
                      where <br className="hidden sm:block" /> they are
                    </h2>
                    <p className="text-left text-gray-600 dark:text-[#d7d7de] max-w-lg font-inter font-normal text-[16px] md:text-[18px]     ">
                      Reach your audience across channels with text automation,
                      personalized pages, and social integrations.
                    </p>
                  </div>

                  <div className="grid grid-cols-2 gap-6 max-w-[517px]">
                    {features4.map((feature, index) => (
                      <div key={index} className="md:space-y-1">
                        <div className="flex items-center gap-3">
                          <div className="w-4 h-4 rounded-lg flex items-center justify-center text-gray-600 dark:text-[#d7d7de]">
                            {feature.icon}
                          </div>
                          <h3 className="text-gray-900 dark:text-[#d7d7de] text-lg font-open-sauce font-black text-[1.16rem]  ">
                            {feature.title}
                          </h3>
                        </div>
                        <p className="text-gray-600 dark:text-[#d7d7de] text-[14px] leading-[20px] pl-[1.75rem] mt-0 font-inter font-normal">
                          {feature.description}
                        </p>
                      </div>
                    ))}
                    <div className="flex items-start gap-6 pt-4">
                      <div className="flex flex-row sm:flex-row sm:items-center gap-4">
                        <Button
                          onClick={() => {
                            window.location.replace(
                              "https://campaigns.clikkle.com/signup?theme=" +
                              theme +
                              "&referralApp=" +
                              getEncodedReferrer()
                            );
                          }}
                          className="bg-[#286efb] hover:bg-[#3367d6] text-white px-8 py-3 h-[40px]"
                          style={{
                            boxShadow: `
          0px 0.25px 0.25px 0px rgba(0,0,0,0.24),
          0px 0.75px 0.75px 0px rgba(0,0,0,0.12),
          0px 1px 1.5px -0.5px rgba(0,0,0,0.12),
          0px 2px 4px -1px rgba(0,0,0,0.12),
          0px 4px 8px -4px rgba(0,0,0,0.12),
          0px 8px 12px -4px rgba(0,0,0,0.06)
        `,
                          }}
                        >
                          Get Started
                        </Button>
                      </div>
                      <div className="pl-4 rounded-lg text-gray-600 dark:text-[#d7d7de] font-light hidden md:block max-w-[280px]">
                        <p className="text-sm leading-relaxed font-inter w-60">
                          <span className="text-[#ff4b5c]">&rdquo;</span>
                          Flows cut manual work instantly.
                          <span className="text-[#ff4b5c]">&quot;</span>
                        </p>

                        <div className="flex items-center gap-3 mt-2">
                          <Image
                            src={chat4}
                            alt="Lucas G."
                            width={24}
                            height={24}
                            className="w-6 h-6 rounded-full"
                          />
                          <div>
                            <p className="font-semibold text-sm">Ethan R.</p>
                            <p className="text-xs text-gray-400">
                              Customer Experience Manager
                            </p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </section>{" "}
        </section>
        <section className="w-full">
          <AppsSection />
        </section>

        <section className="w-full min-h-[510px]">
          <div className="bg-white dark:bg-[#1a1a1a] py-12 md:py-32 px-4 md:px-0">
            <div className="max-w-3xl mx-auto text-center flex flex-col justify-center items-center">
              <h2 className="text-[34px] md:text-5xl  font-inter leading-[48px]   [text-stroke:1px_#000] font-bold text-gray-900 dark:text-white text-center">
                See what our <br className="hidden sm:block" />
                <span className="text-[#286efb] dark:text-[#a9c5ff]  [text-stroke:1px_#000] font-bold">
                  Users
                </span>{" "}
                are saying
              </h2>
              <p className="mt-4 text-gray-600 dark:text-gray-300 text-sm md:text-base font-inter font-normal text-[14px] leading-[20px] tracking-[0em] text-center max-w-[508px]">
                Don&apos;t just take our word for it. See what our valued
                customers have to say about their experience with our platform
                and how it has transformed their business operations.
              </p>
            </div>

            <div className="max-w-2xl mx-auto mt-8 md:px-0">
              <div className="flex justify-center space-x-1">
                {Array(5)
                  .fill(0)
                  .map((_, i) => (
                    <FaStar key={i} className="text-yellow-400" />
                  ))}
              </div>

              <div className="mt-6 flex items-center justify-center">
                <button
                  onClick={prev}
                  className="cursor-pointer p-2 md:p-4 rounded-full border border-gray-300 dark:border-gray-500"
                >
                  <IoIosArrowBack
                    size={18}
                    className="text-gray-900 dark:text-white"
                  />
                </button>

                <p className="mx-4 md:mx-8 text-gray-900 dark:text-white text-sm md:text-lg font-inter font-normal md:font-medium text-[24px] leading-[23px] md:leading-[25px]   text-center md:min-w-[700px]">
                  {text}
                </p>

                <button
                  onClick={next}
                  className="cursor-pointer p-2 md:p-4 rounded-full border border-gray-300 dark:border-gray-500"
                >
                  <IoIosArrowForward
                    size={18}
                    className="text-gray-900 dark:text-white"
                  />
                </button>
              </div>

              <div className="mt-4 text-center text-sm text-gray-600 dark:text-gray-400">
                <span className="text-red-500">*</span>
                {recommendNote}
              </div>

              <div className="mt-6 flex flex-col items-center">
                <Image
                  src={logo}
                  alt="Company Logo"
                  width={24}
                  height={24}
                  className="h-16 w-16 rounded-full object-cover"
                />
                <p className="mt-2 font-medium text-gray-900 dark:text-white">
                  {name}
                </p>
                <p className="text-gray-600 dark:text-gray-400 text-sm">
                  {title}
                </p>
                <p className="text-gray-500 dark:text-gray-500 text-xs mt-1">
                  {date}
                </p>
              </div>
            </div>
          </div>
        </section>

        <section className="w-full" id="moreInfo">
          <section
            className="relative py-16 bg-white dark:bg-[#1a1a1a] overflow-hidden"
            id="pricing"
          >
            <div className="container mx-auto px-4 py-12">
              <div className="flex flex-col md:flex-row items-center justify-center gap-12 md:gap-24">
                <div className="relative w-full md:w-auto flex justify-center">
                  <Image
                    src="/images/free-dog.png"
                    alt="Free forever"
                    width={400}
                    height={400}
                    className="object-contain max-w-[200px] md:max-w-[300px]"
                  />
                </div>

                <div className="w-full md:w-auto text-center md:text-start mx-auto md:mx-0">
                  <h2 className="text-4xl md:text-5xl font-bold text-gray-900 dark:text-white mb-6">
                    Free forever!
                  </h2>
                  <div className="w-full md:w-auto flex justify-center items-center md:block">
                    <ul className="space-y-3 mb-6 text-start">
                      {[
                        "Unlimited Users",
                        "Unlimited Emails",
                        "Unlimited Campaigns",
                      ].map((item, index) => (
                        <li
                          key={index}
                          className="flex items-center justify-start text-lg text-gray-700 dark:text-gray-300"
                        >
                          <svg
                            className="w-5 h-5 text-blue-500 mr-3 flex-shrink-0"
                            fill="none"
                            stroke="currentColor"
                            viewBox="0 0 24 24"
                          >
                            <path
                              strokeLinecap="round"
                              strokeLinejoin="round"
                              strokeWidth="2"
                              d="M5 13l4 4L19 7"
                            />
                          </svg>
                          {item}
                        </li>
                      ))}
                    </ul>
                  </div>

                  <Link
                    href="https://clikkle.com/offers/campaigns"
                    className="text-blue-500 hover:text-blue-600 font-medium inline-flex items-center text-lg transition-colors group"
                  >
                    See upgrades
                    <span className="ml-2 transform group-hover:translate-x-1 transition-transform">
                      <ArrowRightIcon className="w-5 h-5" />
                    </span>
                  </Link>
                  <br />
                  <Button
                    onClick={() => {
                      window.location.replace(
                        "https://campaigns.clikkle.com/signup?theme=" + theme +
                        "&referralApp=" +
                        getEncodedReferrer()
                      );
                    }}
                    className="bg-[#286efb] hover:bg-[#3367d6] text-white px-8 py-3 h-[40px] mt-4"
                  >
                    Try for free
                  </Button>
                </div>
              </div>
            </div>
          </section>
        </section>

        <section className="w-full">
          <section className="w-full py-20 md:py-32 bg-white dark:bg-[#1a1a1a]">
            <div className="container max-w-[694px] mx-auto px-4  text-center">
              <span className="text-gray-900 dark:text-white text-center font-bold text-sm">
                FAQS SECTION
              </span>
              <div className="text-center mb-24 mt-8">
                <h2 className="text-[32px]  [text-stroke:1px_#000] font-boldmd:text-5xl font-medium text-gray-900 dark:text-white mb-6 font-paragraph-inter-m-regular">
                  Frequently Asked Questions
                </h2>
              </div>
              <div className="space-y-4 border border-gray-300 dark:border-[#5e5e69] rounded-xl overflow-hidden transition-colors bg-gray-100 dark:bg-[#141414] p-2">
                {faqs.map((faq, index) => {
                  const isOpen = openFAQ === index;
                  return (
                    <React.Fragment key={index}>
                      <div
                        className={`rounded-xl overflow-hidden transition-colors !mt-[0px] ${isOpen
                            ? "bg-white dark:bg-[#1a1a1a]"
                            : "bg-gray-100 dark:bg-[#141414]"
                          }`}
                      >
                        <button
                          className="w-full px-4 py-5 text-left flex items-center justify-between hover:bg-white dark:hover:bg-[#1a1a1a] transition-colors"
                          onClick={() => setOpenFAQ(isOpen ? null : index)}
                        >
                          <h3 className="text-lg font-[400] text-gray-900 dark:text-white pr-4">
                            {faq.question}
                          </h3>
                          <ArrowDown
                            className={`w-6 h-6 text-black bg-gray-300 dark:bg-[#d7d7de] rounded-full p-1 font-bold transition-transform ${isOpen ? "rotate-180" : ""
                              }`}
                          />
                        </button>

                        {isOpen && (
                          <div className="pr-8 pl-4 pb-6">
                            <p className="text-[#51515E] dark:text-[#EEEEF0] text-start font-[300] text-md">
                              {faq.answer}
                            </p>
                          </div>
                        )}
                      </div>
                      {index < 4 && (
                        <hr className="h-px bg-gray-300 dark:bg-[#5e5e69] border-0 !m-[5px]" />
                      )}
                    </React.Fragment>
                  );
                })}
              </div>
            </div>
          </section>
        </section>
        <section className="w-full flex justify-center items-center">
          <div className="bg-[#edeef1] dark:bg-[#141414] p-10 md:pt-10 pt-16 rounded-[20px] border-2 border-dashed border-gray-300 dark:border-[#575662] my-24 mx-[1.2rem] md:mx-[50px] md:max-w-[1062px] relative overflow-hidden md:overflow-visible">
            <div className="flex flex-col-reverse md:flex-row items-center md:items-start h-full">
              <div className="w-full text-center md:text-left flex flex-col justify-between gap-4 h-full md:w-[1062px] pt-36 md:pt-0">
                <div>
                  <h2 className="!text-[30px] md:!text-[55px] leading-none font-bold text-gray-900 dark:text-white">
                    Grow your{" "}
                    <span className="text-[#286efb] dark:text-[#a9c5ff]">
                      marketing
                    </span>
                  </h2>
                  <h3 className="!text-[30px] md:!text-[55px] font-bold text-gray-900 dark:text-white leading-tight">
                    Launch faster.
                  </h3>
                </div>

                <p className="mt-4 text-gray-600 dark:text-gray-300 text-base md:text-lg">
                  Create emails, pages, and automations in minutes.
                </p>

                <div className="mt-6 w-full max-w-xl flex flex-col items-center md:items-start gap-4">
                  <div className="flex flex-col sm:flex-row items-center sm:items-stretch gap-3 w-full">
                    <input
                      type="email"
                      placeholder="Enter your email"
                      className="flex-1 px-4 py-3 rounded-lg bg-white text-gray-900 placeholder-gray-500 dark:placeholder-gray-400 focus:outline-none w-full border border-gray-300 dark:border-[#575662] shadow-sm dark:shadow-none"
                    />
                    <button
                      onClick={() => {
                        window.location.replace(
                          "https://campaigns.clikkle.com/signup?theme=" + theme
                        );
                      }}
                      className="cursor-pointer px-6 py-3 bg-black dark:bg-[#286efb] text-white font-medium rounded-lg transition w-full sm:w-auto"
                    >
                      Get Started for Free
                    </button>
                  </div>

                  <div className="flex items-start gap-2 text-sm text-gray-600 dark:text-gray-300">
                    <label className="relative flex items-center cursor-pointer">
                      <input
                        type="checkbox"
                        id="terms"
                        defaultChecked
                        className="peer appearance-none h-4 w-4 border-2 border-blue-500 rounded-full bg-white dark:bg-gray-800 checked:bg-[#286efb] checked:border-blue-500 checked:ring-2 checked:ring-blue-300 transition duration-200"
                        aria-label="Agree to terms"
                      />
                      <span className="absolute left-0 top-0 h-4 w-4 flex items-center justify-center pointer-events-none peer-checked:before:content-['✓'] peer-checked:before:text-white peer-checked:before:text-sm peer-checked:before:font-bold"></span>
                    </label>

                    <span className="ml-1 leading-5">
                      I agree with the{" "}
                      <Link
                        href="/terms-of-service"
                        className="underline text-gray-900 dark:text-gray-100 hover:text-[#51515E] dark:hover:text-white"
                        target="_blank"
                        rel="noopener noreferrer"
                      >
                        Terms and Conditions
                      </Link>
                    </span>
                  </div>
                </div>
              </div>

              <div className="w-full md:w-1/2 md:h-full md:self-end flex md:justify-end md:items-end justify-center items-center relative">
                <Image
                  src={theme === "dark" ? ctaBlack : ctaimage}
                  alt="Campaigns Illustration"
                  className="w-[11.5rem] sm:w-[13rem] md:w-[340px] absolute left-1/2 md:left-auto top-[-48px] md:top-auto md:bottom-[-42px] md:right-[-35px] -translate-x-1/2 md:translate-x-0 z-10 pointer-events-none"
                />
              </div>
            </div>
          </div>
        </section>
      </div>

      <footer className="w-full">
        <footer className="w-full bg-white dark:bg-[#1a1a1a] border-t border-gray-300 dark:border-[#9c989c] pt-6 md:pt-16">
          <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 mx-auto px-4">
            <div className="flex flex-col md:flex-row justify-between gap-12">
              <div className="space-y-12">
                {/* <Link href="/">
                  <div className="flex items-center justify-start md:w-[245px] w-auto">
                    <Image
                      className="h-[32px] md:h-[40px] w-auto"
                      alt="Clikkle Campaigns logo"
                      width={114}
                      height={40}
                      src={
                        isDarkMode
                          ? "https://cdn.clikkle.com/images/campaigns/logo/2025/Clikkle%20Campaigns%20Blue%20(%20White%20Text).png"
                          : "https://cdn.clikkle.com/images/campaigns/logo/2025/Clikkle%20Campaigns%20Blue%20(%20Black%20Text).png"
                      }
                    />
                  </div>
                </Link> */}
                <ClikkleLogo />
                <div className="max-w-[285px] space-y-1 md:space-y-2 mt-[48px]">
                  <h3 className="font-instrument-sans font-medium text-[18px] leading-[20px] tracking-[0em] font-headline-small text-gray-900 dark:text-[#eeeef0]">
                    Get Started For Free
                  </h3>
                  <p className="font-body-medium text-[#51515E] dark:text-[#eeeef0] text-[length:var(--body-medium-font-size)] tracking-[var(--body-medium-letter-spacing)] leading-[var(--body-medium-line-height)]">
                    Launch campaigns and automate marketing across channels.
                    Everything teams need to grow.
                  </p>
                </div>
              </div>

              <div className="flex flex-nowrap justify-between gap-y-8 space-x-2 min-[340px]:space-x-5 md:space-x-14 mt-4 text-[10px] min-[360px]:text-xs sm:text-sm overflow-hidden">
                {footerColumns.map((column, index) => (
                  <div key={`column-${index}`} className="flex flex-col gap-5">
                    <h4 className="font-label-medium text-gray-900 dark:text-white text-[length:var(--label-medium-font-size)] tracking-[var(--label-medium-letter-spacing)] leading-[var(--label-medium-line-height)]">
                      {column.title}
                    </h4>
                    <ul className="flex flex-col gap-4">
                      {column.links.map((link, linkIndex) => (
                        <li key={`link-${index}-${linkIndex}`}>
                          <div className="flex items-start gap-3">
                            <Link
                              href={link.url}
                              target={
                                link.url.startsWith("http") ? "_blank" : "_self"
                              }
                              rel={
                                link.url.startsWith("http")
                                  ? "noopener noreferrer"
                                  : undefined
                              }
                              className="font-body-medium text-[#51515E] dark:text-[#d7d7de] text-[length:var(--body-medium-font-size)] tracking-[var(--body-medium-letter-spacing)] leading-[var(--body-medium-line-height)] whitespace-nowrap hover:text-gray-900 dark:hover:text-white transition-colors"
                            >
                              <span className="flex justify-center items-center gap-2">
                                {link.text}{" "}
                                {column.title === "Social" && (
                                  <FaArrowRight className="w-2 h-2 text-[#51515E] dark:text-[#d7d7de]" />
                                )}
                              </span>
                            </Link>
                            {link.isNew && (
                              <div className="hidden md:flex items-center gap-2 ">
                                <div className="relative w-4 h-4">
                                  <div className="relative w-[13px] h-[13px] top-px left-px bg-[#c3e6ff] rounded-[6.67px]">
                                    <div className="relative w-1 h-1 top-[5px] left-[5px] bg-[#286efb] rounded-sm" />
                                  </div>
                                </div>
                                <span className="font-body-medium text-gray-900 dark:text-white text-[length:var(--body-medium-font-size)] tracking-[var(--body-medium-letter-spacing)] leading-[var(--body-medium-line-height)] whitespace-nowrap">
                                  New
                                </span>
                              </div>
                            )}
                          </div>
                        </li>
                      ))}
                    </ul>
                  </div>
                ))}
              </div>
            </div>
          </div>

          <div className="w-full h-10 bg-gray-100 dark:bg-[#141414] mt-12 flex items-center justify-center">
            <p className="font-body-small text-gray-900 dark:text-white text-[length:var(--body-small-font-size)] tracking-[var(--body-small-letter-spacing)] leading-[var(--body-small-line-height)]">
              ©{new Date().getFullYear()} Clikkle All Rights Reserved.
            </p>
          </div>
        </footer>
      </footer>
      <SidebarDrawer open={leftDrawerOpen} toggle={toggleLeftDrawer} />
    </div>
  );
};

export default CampaignsHome;
