/* eslint-disable react-hooks/exhaustive-deps */
/* eslint-disable @next/next/no-img-element */
/* eslint-disable react-hooks/rules-of-hooks */
"use client";
/* eslint-disable @typescript-eslint/no-explicit-any */
import React, { useEffect, useRef, useState } from "react";
import { useRouter, useParams } from "next/navigation";
import {
  ArrowLeft,
  Calendar,
  Clock,
  Share2,
  Facebook,
  Twitter,
  Linkedin,
  Copy,
  Check,
  ArrowRightIcon,
  Ellipsis,
  Logs,
} from "lucide-react";
import { BlogPost } from "../constants/blogData";
import { footerColumns } from "../constants/footerText";
import { FaArrowRight } from "react-icons/fa";
import { apps } from "../constants/products";
import illustration from "../../public/images/banner.png";
import SidebarDrawer from "../components/sidebarDrawer";
import ThemeSwitch from "../components/themeSwitch";
import { Button } from "../components/button";
import { useTheme } from "../atoms/theme";
import Link from "next/link";
import Image from "next/image";
import ClikkleLogo from "@/components/ClikkleLogo";
import Footer from "@/components/Footer";
import { getEncodedReferrer } from "@/utils/utils";

const DEFAULT_API_BASE_URL = "https://admin.clikkle.com:5100/api";

interface BlogPostPageProps {
  blogId: string;
  initialPost?: BlogPost | null;
}

const BlogPostPage: React.FC<BlogPostPageProps> = ({ blogId, initialPost }) => {
  const router = useRouter();
  const params = useParams();
  const slug = (params?.slug as string) || (params?.id as string) || blogId;

  if (!slug) {
    return (
      <div className="min-h-screen bg-white dark:bg-[#1a1a1a] flex items-center justify-center flex-col gap-4">
        <p className="text-gray-600 dark:text-gray-300">
          No blog post slug provided
        </p>
        <button
          onClick={() => router.push("/blogs")}
          className="text-blue-600 dark:text-blue-400 hover:underline cursor-pointer"
        >
          Back to blogs
        </button>
      </div>
    );
  }
  const [post, setPost] = useState<BlogPost | null | undefined>(initialPost);
  const [relatedPosts, setRelatedPosts] = useState<BlogPost[]>([]);
  const [loading, setLoading] = useState(!initialPost);
  const [shareMenuOpen, setShareMenuOpen] = useState(false);
  const [copySuccess, setCopySuccess] = useState(false);
  const API_BASE_URL = DEFAULT_API_BASE_URL;

  useEffect(() => {
    const fetchPostBySlug = async () => {
      if (initialPost) {
        setLoading(false);
        return;
      }
      if (!slug) {
        setLoading(false);
        setPost(null);
        return;
      }
      try {
        setLoading(true);
        const apiUrl = `${API_BASE_URL}/blogs/public/slug/${slug}`;

        const controller = new AbortController();
        const timeoutId = setTimeout(() => controller.abort(), 10000);

        try {
          const res = await fetch(apiUrl, {
            method: "GET",
            headers: {
              "Content-Type": "application/json",
            },
            signal: controller.signal,
          });
          clearTimeout(timeoutId);

          if (res.ok) {
            const json = await res.json();
            if (json?.success && json.data) {
              const b = json.data;
              const mapped: BlogPost = {
                id: b._id,
                slug: b.slug,
                title: b.title,
                excerpt: b.excerpt || "",
                content: b.content || "",
                featuredImage:
                  b.featuredImage ||
                  "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
                author: {
                  name: b.author?.name || "Unknown Author",
                  avatar:
                    b.author?.avatar ||
                    "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
                  bio: b.author?.bio || "",
                },
                publishedDate: b.publishedDate || new Date().toISOString(),
                category: b.category || "News",
                tags: Array.isArray(b.tags) ? b.tags : [],
                readTime: b.readTime ?? b.calculatedReadTime ?? 0,
                seoTitle: b.metaTitle || b.title,
                seoDescription: b.metaDescription || b.excerpt || "",
              };
              setPost(mapped);

              document.title = `Clikkle Blogs | ${
                mapped.excerpt || mapped.title
              }`;
              const metaDescription = document.querySelector(
                'meta[name="description"]'
              );
              if (metaDescription) {
                metaDescription.setAttribute(
                  "content",
                  mapped.seoDescription || mapped.excerpt
                );
              }
              return;
            }
          }
        } catch (apiError) {
          console.log(apiError);
          clearTimeout(timeoutId);
        }
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
      } catch (err) {
        setPost(null);
      } finally {
        setLoading(false);
      }
    };

    fetchPostBySlug();
  }, [slug]);

  useEffect(() => {
    const incrementViews = async () => {
      try {
        if (!post?.id) return;
        await fetch(`${API_BASE_URL}/blogs/public/${post?.id}/views`, {
          method: "PATCH",
        });
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
      } catch (_) {}
    };
    incrementViews();
  }, [post?.id]);

  useEffect(() => {
    const fetchRelated = async () => {
      try {
        if (!post?.category) return;
        const params = new URLSearchParams();
        params.set("page", "1");
        params.set("limit", "6");
        params.set("status", "published");
        params.set("category", post?.category);
        params.set("sortBy", "publishedDate");
        params.set("sortOrder", "desc");

        const res = await fetch(
          `${API_BASE_URL}/blogs/public?${params?.toString()}`
        );
        const json = await res.json();
        if (!res.ok || !json?.success) return;
        const mapped: BlogPost[] = (json.data || [])
          .filter((b: any) => b.slug !== post?.slug)
          .slice(0, 3)
          .map((b: any) => ({
            id: b._id,
            slug: b.slug,
            title: b.title,
            excerpt: b.excerpt || "",
            content: b.content || "",
            featuredImage:
              b.featuredImage ||
              "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
            author: {
              name: b.author?.name || "Unknown Author",
              avatar:
                b.author?.avatar ||
                "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
              bio: b.author?.bio || "",
            },
            publishedDate: b.publishedDate || new Date().toISOString(),
            category: b.category || "News",
            tags: Array.isArray(b.tags) ? b.tags : [],
            readTime: b.readTime ?? b.calculatedReadTime ?? 0,
            seoTitle: b.metaTitle || b.title,
            seoDescription: b.metaDescription || b.excerpt || "",
          }));
        setRelatedPosts(mapped);
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
      } catch (_) {}
    };
    fetchRelated();
  }, [post?.category, post?.slug]);

  const handleShare = (platform: string) => {
    const url = window.location.href;
    const title = post?.title || "";

    let shareUrl = "";
    switch (platform) {
      case "facebook":
        shareUrl = `https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(
          url
        )}`;
        break;
      case "twitter":
        shareUrl = `https://twitter.com/intent/tweet?url=${encodeURIComponent(
          url
        )}&text=${encodeURIComponent(title)}`;
        break;
      case "linkedin":
        shareUrl = `https://www.linkedin.com/sharing/share-offsite/?url=${encodeURIComponent(
          url
        )}`;
        break;
      case "copy":
        navigator.clipboard.writeText(url);
        setCopySuccess(true);
        setTimeout(() => setCopySuccess(false), 2000);
        return;
    }

    if (shareUrl) {
      window.open(shareUrl, "_blank", "width=600,height=400");
    }
    setShareMenuOpen(false);
  };

  const formatDate = (dateString: string) => {
    return new Date(dateString).toLocaleDateString("en-US", {
      year: "numeric",
      month: "long",
      day: "numeric",
    });
  };
  const [leftDrawerOpen, setLeftDrawerOpen] = useState(false);
  const toggleLeftDrawer = () => setLeftDrawerOpen((prev) => !prev);

  const [productsOpen, setProductsOpen] = useState(false);
  const [dotsOpen, setDotsOpen] = useState(false);
  const productsRef = useRef<HTMLDivElement>(null);
  const dotsRef = useRef<HTMLDivElement>(null);
  const [isVisible] = useState(false);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (
        productsRef.current &&
        !productsRef.current.contains(event.target as Node)
      ) {
        setProductsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (dotsRef.current && !dotsRef.current.contains(event.target as Node)) {
        setDotsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);

  const [scrolled, setScrolled] = useState(false);
  useEffect(() => {
    const handleScroll = () => {
      setScrolled(window.scrollY > 0);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);
  const { theme } = useTheme();

  if (loading) {
    return (
      <div className="min-h-screen bg-white dark:bg-[#1a1a1a] flex items-center justify-center">
        <div className="animate-spin rounded-full h-32 w-32 border-b-2 border-blue-600"></div>
      </div>
    );
  }

  if (post == null) {
    return (
      <div className="min-h-screen bg-white dark:bg-[#1a1a1a] flex items-center justify-center flex-col gap-4">
        <p className="text-gray-600 dark:text-gray-300">Post not found</p>
        <Link
          href="/blogs"
          className="text-blue-600 dark:text-blue-400 cursor-pointer"
        >
          Back to blogs
        </Link>
      </div>
    );
  }

  return (
    <>
      <div className="min-h-screen bg-white dark:bg-[#1a1a1a]">
        <section className="w-full">
          <section className="relative w-full h-28 overflow-hidden">
            <div
              className={`fixed top-0 inset-x-0 z-50 ${
                scrolled
                  ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1a1a]/90"
                  : productsOpen || dotsOpen
                  ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1a1a]/90"
                  : ""
              }`}
            >
              <div className="container max-w-[1233px] mx-auto max-[1300px]:px-14 max-[1100px]:px-4">
                <nav
                  className={`relative flex items-center justify-between py-4`}
                >
                  <ClikkleLogo />

                  <div className="flex md:hidden items-center">
                    <div
                      className="flex items-center gap-0 rounded-xl border border-gray-300 dark:border-[#ffffff3a] p-[8px] shadow-sm"
                      onClick={toggleLeftDrawer}
                    >
                      <p className="text-sm font-medium text-gray-900 dark:text-white">
                        <Logs className="w-5 h-5 text-gray-900 dark:text-white mr-3" />
                      </p>

                      <p className="flex items-center  rounded-xl text-sm font-bold ">
                        Menu
                      </p>
                    </div>
                  </div>

                  <div className="hidden md:flex items-center gap-12 font-inter font-medium text-[18px]">
                    <Link
                      href="https://clikkle.com#features"
                      className="text-gray-900 dark:text-white hover:text-gray-900 dark:hover:text-[#d7d7de] transition-colors"
                    >
                      Features
                    </Link>
                    <Link
                      href="https://clikkle.com/#pricing"
                      className="text-gray-900 dark:text-white hover:text-gray-900 dark:hover:text-[#d7d7de] transition-colors"
                    >
                      Pricing
                    </Link>
                    <Link
                      href="/blogs"
                      className="text-gray-900 dark:text-white hover:text-gray-900 dark:hover:text-[#d7d7de] transition-colors"
                    >
                      Blog
                    </Link>
                    <div className="flex flex-row justify-center items-center">
                      <div className="relative" ref={productsRef}>
                        <button
                          onClick={() => setProductsOpen((o) => !o)}
                          className="cursor-pointer flex items-center gap-1 text-gray-900 dark:text-white hover:text-gray-900 dark:hover:text-[#d7d7de] transition-colors"
                        >
                          Products
                        </button>
                        {productsOpen && (
                          <div
                            className={`fixed ${
                              isVisible ? "top-[117px]" : "top-[75px]"
                            } 
              left-1/2 transform -translate-x-1/2 w-full bg-white/90 dark:bg-[#1a1a1a]/90 backdrop-blur-md 
              shadow-lg p-6 border-b-2 border-gray-300 dark:border-[#575662] z-50 flex justify-center items-center pb-0`}
                          >
                            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                  <div className="flex flex-col gap-3">
                              {apps
                                .slice(0, Math.ceil(apps.length / 2))
                                .map((product) => (
                                  <Link
                                    key={product.id}
                                    href={product.route}
                                    className="flex items-center gap-4 p-[0.35rem] rounded-lg hover:bg-gray-100 dark:hover:bg-white/10 transition"
                                  >
                                    <div>
                                      <Image
                                        src={product.image}
                                        alt={product.title}
                                        className="w-[26px]"
                                        width={26}
                                        height={26}
                                      />
                                    </div>
                                    <div>
                                      <p className="font-bold text-gray-900 dark:text-white text-sm">
                                        {product.title}
                                      </p>
                                      <p className="text-xs text-gray-600 dark:text-gray-300">
                                        {product.description}
                                      </p>
                                    </div>
                                  </Link>
                                ))}
                            </div>

                            <div className="flex flex-col gap-3">
                              {apps
                                .slice(
                                  Math.ceil(apps.length / 2),
                                  Math.ceil(apps.length / 2) + 2,
                                )
                                .map((product) => (
                                  <Link
                                    key={product.id}
                                    href={product.route}
                                    className="flex items-center gap-4 p-[0.35rem] rounded-lg hover:bg-gray-100 dark:hover:bg-white/10 transition"
                                  >
                                    <div>
                                      <Image
                                        src={product.image}
                                        alt={product.title}
                                        className="w-[26px]"
                                        width={26}
                                        height={26}
                                      />
                                    </div>
                                    <div>
                                      <p className="font-bold text-gray-900 dark:text-white text-sm">
                                        {product.title}
                                      </p>
                                      <p className="text-xs text-gray-600 dark:text-gray-300">
                                        {product.description}
                                      </p>
                                    </div>
                                  </Link>
                                ))}
                              <Link href="/products">
                                <Button
                                  style={{ marginTop: "5px" }}
                                  variant="ghost"
                                  className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                >
                                  View all products
                                  <ArrowRightIcon className="h-2 w-2 dark:text-white" />
                                </Button>
                              </Link>
                            </div>
                              <div className="hidden lg:flex flex-row items-center justify-center text-center gap-3">
                                <Image
                                  src={illustration}
                                  alt="Illustration"
                                  className="w-auto h-[175px]"
                                  width={400}
                                  height={175}
                                />
                                <div className="flex flex-col justify-center items-center h-full">
                                  <p className="text-sm text-gray-700 dark:text-gray-100 max-w-[200px] pb-5">
                                    Get started today the modern solution to
                                    power your business.
                                  </p>
                                  <Button
                                    variant="ghost"
                                    onClick={() => {
                                      window.location.replace(
                                        `https://worksuite.clikkle.com/signup?theme=${theme}&referralApp=${getEncodedReferrer()}`
                                      );
                                    }}
                                    className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                  >
                                    Get Started Today
                                    <ArrowRightIcon
                                      className={`h-2 w-2 dark:text-white`}
                                    />
                                  </Button>
                                </div>
                              </div>
                            </div>
                          </div>
                        )}
                      </div>

                      <div className="relative" ref={dotsRef}>
                        <Ellipsis
                          onClick={() => setDotsOpen((o) => !o)}
                          className="w-8 h-6 rounded-full p-[1px] cursor-pointer"
                        />
                        {dotsOpen && (
                          <div
                            className={`fixed ${
                              isVisible ? "top-[117px]" : "top-[75px]"
                            } left-1/2 transform -translate-x-1/2 w-full 
    bg-white/90 dark:bg-[#1a1a1a]/90 backdrop-blur-md 
    shadow-lg border-b-2 border-gray-300 dark:border-[#575662] 
    z-50 flex justify-center`}
                          >
                            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 py-6">
                              <div className="flex flex-col md:flex-row justify-between items-start gap-12">
                                <div className="space-y-12">
                                  <div className="max-w-[285px] space-y-2 mb-0">
                                    <h3 className="font-instrument-sans font-medium text-[18px] leading-[20px] text-gray-900 dark:text-[#eeeef0]">
                                      Get Started For Free
                                    </h3>
                                    <p className="font-body-medium text-[#51515E] dark:text-[#eeeef0]">
                                      Streamline your Business with our Apps.
                                      Effortlessly for every team.
                                    </p>
                                  </div>
                                  <Button
                                    style={{ marginTop: "20px" }}
                                    variant="ghost"
                                    onClick={() => {
                                      window.location.replace(
                                        `https://worksuite.clikkle.com/signup?theme=${theme}&referralApp=${getEncodedReferrer()}`
                                      );
                                    }}
                                    className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                  >
                                    See How It Works
                                    <ArrowRightIcon
                                      className={`h-2 w-2 dark:text-white`}
                                    />
                                  </Button>
                                </div>

                                <div className="flex flex-wrap gap-x-14 gap-y-8 text-xs sm:text-sm">
                                  {footerColumns.map((column, index) => (
                                    <div
                                      key={index}
                                      className="flex flex-col gap-5"
                                    >
                                      <h4 className="font-label-medium text-gray-900 dark:text-white">
                                        {column.title}
                                      </h4>
                                      <ul className="flex flex-col gap-4">
                                        {column.links.map((link, linkIndex) => (
                                          <li key={linkIndex}>
                                            <div className="flex items-start gap-3">
                                              <Link
                                                href={link.url}
                                                target={
                                                  link.url.startsWith("http")
                                                    ? "_blank"
                                                    : "_self"
                                                }
                                                rel={
                                                  link.url.startsWith("http")
                                                    ? "noopener noreferrer"
                                                    : undefined
                                                }
                                                className="font-body-medium text-[#51515E] dark:text-[#d7d7de] hover:text-gray-900 dark:hover:text-white transition-colors whitespace-nowrap flex items-center gap-2"
                                              >
                                                {link.text}
                                                {column.title === "Social" && (
                                                  <FaArrowRight className="w-2 h-2" />
                                                )}
                                              </Link>

                                              {link.isNew && (
                                                <div className="hidden md:flex items-center gap-2">
                                                  <div className="w-4 h-4 flex items-center justify-center">
                                                    <div className="w-[13px] h-[13px] bg-[#c3e6ff] rounded-[6.67px] flex items-center justify-center">
                                                      <div className="w-1 h-1 bg-[#286efb] rounded-sm" />
                                                    </div>
                                                  </div>
                                                  <span className="font-body-medium text-gray-900 dark:text-white whitespace-nowrap">
                                                    New
                                                  </span>
                                                </div>
                                              )}
                                            </div>
                                          </li>
                                        ))}
                                      </ul>
                                    </div>
                                  ))}
                                </div>
                              </div>
                            </div>
                          </div>
                        )}
                      </div>
                    </div>
                  </div>

                  <div className="hidden md:flex items-center gap-4">
                    <div className="hidden md:flex items-center gap-4">
                      <div className="w-6">
                        <ThemeSwitch />
                      </div>
                      <div className="flex items-center gap-2 rounded-xl border border-gray-300 dark:border-[#ffffff3a] p-1 shadow-sm">
                        <button
                          className="cursor-pointer px-3 py-1 text-sm font-medium text-gray-900 dark:text-white"
                          onClick={() => {
                            window.location.replace(
                              `https://worksuite.clikkle.com/login?theme=${theme}&referralApp=${getEncodedReferrer()}`
                            );
                          }}
                        >
                          Login
                        </button>

                        <button
                          className="cursor-pointer flex items-center gap-1 rounded-xl bg-[#286efb] hover:bg-[#3367d6] px-4 py-1.5 text-sm font-medium text-white transition"
                          onClick={() => {
                            window.location.replace(
                              `https://worksuite.clikkle.com/signup?theme=${theme}&referralApp=${getEncodedReferrer()}`
                            );
                          }}
                        >
                          Try for free
                          <span>
                            <ArrowRightIcon className="w-4" />
                          </span>
                        </button>
                      </div>
                    </div>
                  </div>
                </nav>
              </div>
            </div>
          </section>
        </section>
        <div className="">
          <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-4">
            <button
              onClick={() => router.push("/blogs")}
              className="flex items-center transition-colors cursor-pointer"
            >
              <ArrowLeft className="h-5 w-5 mr-2" />
              Back to Blogs
            </button>
          </div>
        </div>

        <article className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
          <h1 className="text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900 dark:text-white mb-6 leading-tight">
            {post?.title}
          </h1>
          <div className="mb-8">
            <img
              src={post?.featuredImage}
              alt={post?.title}
              className="w-full h-auto object-cover rounded-lg shadow-lg"
            />
          </div>

          <header className="mb-8">
            <div className="mb-4">
              <span className="inline-block cursor-pointer px-3 py-1 text-sm font-medium bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200 rounded-full">
                {post?.category}
              </span>
            </div>

            <div className="flex flex-wrap items-center gap-6 text-gray-600 dark:text-gray-300 mb-6">
              <div className="flex items-center">
                <img
                  src={post?.author.avatar}
                  alt={post?.author.name}
                  className="w-8 h-8 rounded-full mr-2 object-cover"
                />
                <span>{post?.author.name}</span>
              </div>
              <div className="flex items-center">
                <Calendar className="h-4 w-4 mr-2" />
                <span>
                  {formatDate(post?.publishedDate || new Date().toISOString())}
                </span>
              </div>
              <div className="flex items-center">
                <Clock className="h-4 w-4 mr-2" />
                <span>{post?.readTime} min read</span>
              </div>
            </div>

            <div className="relative">
              <button
                onClick={() => setShareMenuOpen(!shareMenuOpen)}
                className="cursor-pointer flex items-center px-4 py-2 bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-300 rounded-lg hover:bg-gray-200 dark:hover:bg-gray-600 transition-colors"
              >
                <Share2 className="h-4 w-4 mr-2" />
                Share
              </button>

              {shareMenuOpen && (
                <div className="absolute top-full left-0 mt-2 bg-white dark:bg-[#1a1a1a] rounded-lg shadow-lg border dark:border-gray-700 p-2 z-10">
                  <button
                    onClick={() => handleShare("facebook")}
                    className="flex items-center w-full px-3 py-2 text-left hover:bg-gray-100 dark:hover:bg-gray-700 rounded"
                  >
                    <Facebook className="h-4 w-4 mr-2 text-blue-600" />
                    Facebook
                  </button>
                  <button
                    onClick={() => handleShare("twitter")}
                    className="flex items-center w-full px-3 py-2 text-left hover:bg-gray-100 dark:hover:bg-gray-700 rounded"
                  >
                    <Twitter className="h-4 w-4 mr-2 text-blue-400" />
                    Twitter
                  </button>
                  <button
                    onClick={() => handleShare("linkedin")}
                    className="flex items-center w-full px-3 py-2 text-left hover:bg-gray-100 dark:hover:bg-gray-700 rounded"
                  >
                    <Linkedin className="h-4 w-4 mr-2 text-blue-700" />
                    LinkedIn
                  </button>
                  <button
                    onClick={() => handleShare("copy")}
                    className="flex items-center w-full px-3 py-2 text-left hover:bg-gray-100 dark:hover:bg-gray-700 rounded"
                  >
                    {copySuccess ? (
                      <Check className="h-4 w-4 mr-2 text-green-600" />
                    ) : (
                      <Copy className="h-4 w-4 mr-2" />
                    )}
                    {copySuccess ? "Copied!" : "Copy Link"}
                  </button>
                </div>
              )}
            </div>
          </header>

          <div className="bg-white dark:bg-[#1a1a1a] p-6 xs:p-8 sm:p-0 mb-8">
            <div className="prose dark:prose-invert max-w-none">
              <div dangerouslySetInnerHTML={{ __html: post?.content || "" }} />
            </div>
          </div>

          {post?.author.bio && (
            <div className="bg-white dark:bg-[#1a1a1a] rounded-lg shadow-sm p-6 mb-8  border border-gray-300 dark:border-[#575662]">
              <div className="flex items-start space-x-4">
                <img
                  src={post?.author.avatar}
                  alt={post?.author.name}
                  className="w-16 h-16 rounded-full object-cover"
                />
                <div>
                  <h3 className="text-lg font-semibold text-gray-900 dark:text-white mb-2">
                    About {post?.author.name}
                  </h3>
                  <p className="text-gray-600 dark:text-gray-300">
                    {post?.author.bio}
                  </p>
                </div>
              </div>
            </div>
          )}

          {relatedPosts.length > 0 && (
            <div className="bg-white dark:bg-[#1a1a1a] rounded-lg shadow-sm p-6  border border-gray-300 dark:border-[#575662]">
              <h3 className="text-xl font-bold text-gray-900 dark:text-white mb-6">
                Related Posts
              </h3>
              <div className="grid gap-6 md:grid-cols-2 lg:grid-cols-3">
                {relatedPosts.map((relatedPost) => (
                  <Link
                    key={relatedPost.id}
                    href={`/blogs/${relatedPost.slug}`}
                    onClick={() =>
                      window.scrollTo({ top: 0, behavior: "smooth" })
                    }
                    className="group block"
                  >
                    <div className="bg-white dark:bg-[#1a1a1a] border border-gray-300 dark:border-[#575662] rounded-lg overflow-hidden hover:shadow-md transition-shadow">
                      <img
                        src={relatedPost.featuredImage}
                        alt={relatedPost.title}
                        className="w-full h-32 object-cover group-hover:scale-105 transition-transform duration-300"
                      />
                      <div className="p-4">
                        <h4 className="font-semibold text-gray-900 dark:text-white mb-2 line-clamp-2 group-hover:text-blue-600 dark:group-hover:text-blue-400 transition-colors">
                          {relatedPost.title}
                        </h4>
                        <p className="text-sm text-gray-600 dark:text-gray-300 line-clamp-2">
                          {relatedPost.excerpt}
                        </p>
                        <div className="flex items-center mt-3 text-xs text-gray-500 dark:text-gray-400">
                          <Calendar className="h-3 w-3 mr-1" />
                          {formatDate(relatedPost.publishedDate)}
                        </div>
                      </div>
                    </div>
                  </Link>
                ))}
              </div>
            </div>
          )}

          <div className="bg-white dark:bg-[#1a1a1a] rounded-lg shadow-sm p-6 mt-8  border border-gray-300 dark:border-[#575662]">
            <h3 className="text-xl font-bold text-gray-900 dark:text-white mb-4">
              Comments
            </h3>
            <div className="text-center py-8 text-gray-500 dark:text-gray-400">
              <p className="mb-4">Comments section coming soon!</p>
              <p className="text-sm">
                We&apos;re working on adding a comment system to enhance your
                reading experience.
              </p>
            </div>
          </div>
        </article>
      </div>

      <Footer />
      <SidebarDrawer open={leftDrawerOpen} toggle={toggleLeftDrawer} />
    </>
  );
};

export default BlogPostPage;
