import { Metadata } from "next";
import ComingSoon from "@/clikklepages/comingSoon";

export const metadata: Metadata = {
  title: "Clikkle Social | Social Media Management Software | Social Media Tools",
  description: "Manage social media efficiently with Clikkle's social media management software. Schedule posts, track engagement, analyze performance, and manage multiple social accounts from one platform.",
  keywords: "social media management, social media tools, social media scheduling, content management, social media analytics, social media platform, social media automation",
  openGraph: {
    title: "Clikkle Social | Social Media Management Software | Social Media Tools",
    description: "Manage social media efficiently with Clikkle's social media management platform. Schedule posts and track engagement.",
    url: "https://clikkle.com/social",
    images: [
      {
        url: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
        width: 1200,
        height: 1200,
        alt: "Clikkle Social Media Management Dashboard",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Clikkle Social | Social Media Management Software | Social Media Tools",
    description: "Manage social media efficiently with Clikkle's social media management platform.",
    images: ["https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png"],
  },
  alternates: {
    canonical: "https://clikkle.com/social",
  },
  icons: {
    icon: "https://cdn.clikkle.com/images/social/logo/2025/clikkle%20social.png",
    apple: "https://cdn.clikkle.com/images/social/logo/2025/clikkle%20social.png",
  },
};

export default function SocialHome() {
    return (
        <ComingSoon/>
    )
}