import { Metadata } from "next";
import ProjectsHomePage from "../../clikklepages/projectsHome";

export const metadata: Metadata = {
  title: "Clikkle Projects | Project Management Software | Team Collaboration",
  description: "Manage projects efficiently with Clikkle's project management software. Track tasks, collaborate with teams, set deadlines, monitor progress, and deliver projects on time with our comprehensive project management platform.",
  keywords: "project management software, task management, team collaboration, project tracking, deadline management, project planning, team productivity, project dashboard",
  openGraph: {
    title: "Clikkle Projects | Project Management Software | Team Collaboration",
    description: "Manage projects efficiently with Clikkle's project management platform. Track tasks, collaborate with teams, and deliver on time.",
    url: "https://clikkle.com/projects",
    images: [
      {
        url: "https://cdn.clikkle.com/images/projects/logo/2025/clikkle%20projects.png",
        width: 1200,
        height: 1200,
        alt: "Clikkle Project Management Dashboard",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Clikkle Projects | Project Management Software | Team Collaboration",
    description: "Manage projects efficiently with Clikkle's project management platform.",
    images: ["https://cdn.clikkle.com/images/projects/logo/2025/clikkle%20projects.png"],
  },
  alternates: {
    canonical: "https://clikkle.com/projects",
  },
    icons: {
    icon: "https://cdn.clikkle.com/images/projects/logo/2025/clikkle%20projects.png",
    apple:
      "https://cdn.clikkle.com/images/projects/logo/2025/clikkle%20projects.png",
  },
};

export default function ProjectsHome() {
  return <ProjectsHomePage />;
}