import AllProducts from "@/clikklepages/allProducts";
import { Metadata } from "next";
export const metadata: Metadata = {
  title: "All Products | Clikkle Business Suite",
  description:
    "Explore all products offered by Clikkle Business Suite. Discover our comprehensive range of business solutions designed to streamline your operations.",
  keywords:
    "clikkle products, business solutions, clikkle business suite, business tools, productivity software",
  openGraph: {
    title: "All Products | Clikkle Business Suite",
    description: "Explore all products offered by Clikkle Business Suite.",
    url: "https://clikkle.com/products",
    images: [
      {
        url: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
        width: 1200,
        height: 1200,
        alt: "Clikkle All Products",
      },
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "All Products | Clikkle Business Suite",
    description: "Explore all products offered by Clikkle Business Suite.",
    images: ["https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png"],
  },
  alternates: {
    canonical: "https://clikkle.com/products",
  },
  icons: {
    icon: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
    apple: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
  },
};

export default function Products() {
  return <AllProducts />;
}
