import { Metadata } from "next";
import PrivacyPolicyComponent from "../../clikklepages/privacyPolicy";

export const metadata: Metadata = {
  title: "Privacy Policy | Clikkle Business Suite - Data Protection",
  description: "Read Clikkle's privacy policy to understand how we protect your business data. Learn about our data collection, usage, storage practices, and your privacy rights when using our business suite.",
  keywords: "privacy policy, data protection, business data privacy, clikkle privacy, data security, privacy rights, GDPR compliance, business privacy",
  openGraph: {
    title: "Privacy Policy | Clikkle Business Suite - Data Protection",
    description: "Read Clikkle's privacy policy to understand how we protect your business data and your privacy rights.",
    url: "https://clikkle.com/privacy-policy",
    images: [
      {
        url: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
        width: 1200,
        height: 1200,
        alt: "Clikkle Privacy Policy",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Privacy Policy | Clikkle Business Suite - Data Protection",
    description: "Read Clikkle's privacy policy to understand how we protect your business data.",
    images: ["https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png"],
  },
  alternates: {
    canonical: "https://clikkle.com/privacy-policy",
  },
  icons: {
    icon: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
    apple: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
  },
};

export default function PrivacyPolicyHome() {
  return <PrivacyPolicyComponent />;
}