/* eslint-disable @next/next/no-page-custom-font */
import type { Metadata } from "next";
import "./globals.css";
import CookiesWrapper from "@/wrappers/CookiesWrapper";
import RootContainer from "@/globals/root";
import ScrollHandler from "@/wrappers/Scrollhandler";
import { Suspense } from "react";
import Loader from "@/components/loader";
import ClikkleChat from "@/components/ClikkleChat";
import Script from "next/script";

export const metadata: Metadata = {
  title: "Clikkle | Business Apps And Collaboration Tools",
  description:
    "Clikkle is an all-in-one business suite offering CRM, HR management, project management, file sharing, e-signature, and team collaboration tools. Streamline your business operations with our comprehensive productivity platform.",
  keywords:
    "business apps, collaboration tools, CRM, HR management, project management, file sharing, e-signature, productivity suite, business software, team collaboration",
  authors: [{ name: "Clikkle" }],
  creator: "Clikkle",
  publisher: "Clikkle",
  formatDetection: {
    email: false,
    address: false,
    telephone: false,
  },
  metadataBase: new URL("https://clikkle.com"),
  alternates: {
    canonical: "https://clikkle.com",
  },
  openGraph: {
    title: "Clikkle | All-in-One Business Suite & Collaboration Tools",
    description:
      "Streamline your business with Clikkle's comprehensive suite: CRM, HR, project management, file sharing, e-signature, and team collaboration tools in one platform.",
    url: "https://clikkle.com",
    siteName: "Clikkle",
    images: [
      {
        url: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
        width: 1200,
        height: 1200,
        alt: "Clikkle Business Suite Platform",
      },
    ],
    locale: "en_US",
    type: "website",
  },
  twitter: {
    card: "summary_large_image",
    title: "Clikkle | Business Apps & Collaboration Tools",
    description:
      "All-in-one business suite: CRM, HR, project management, file sharing, e-signature, and team collaboration tools.",
    images: ["https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png"],
  },
  robots: {
    index: true,
    follow: true,
    googleBot: {
      index: true,
      follow: true,
      "max-video-preview": -1,
      "max-image-preview": "large",
      "max-snippet": -1,
    },
  },
  verification: {
    google: "your-google-verification-code",
    yandex: "your-yandex-verification-code",
  },
  manifest: "/manifest.json",
  icons: {
    icon: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
    apple: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
  },
};

export default function RootLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  return (
    <html lang="en" suppressHydrationWarning>
      <head>
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link
          rel="preconnect"
          href="https://fonts.gstatic.com"
          crossOrigin="anonymous"
        />
        <link
          href="https://fonts.googleapis.com/css2?family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&display=swap"
          rel="stylesheet"
        />
        <link
          href="https://fonts.googleapis.com/css2?family=Caveat:wght@400;500;600;700&display=swap"
          rel="stylesheet"
        />
      </head>
      <body>
        <CookiesWrapper />
        <Suspense fallback={<Loader />}>
          <ScrollHandler />
          <RootContainer>{children}</RootContainer>
        </Suspense>
        <ClikkleChat />
        <Script
          src="https://www.googletagmanager.com/gtag/js?id=G-GNXYL2DKBL"
          strategy="afterInteractive"
        />
        <Script id="google-analytics" strategy="afterInteractive">
          {`
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());

            gtag('config', 'G-GNXYL2DKBL');
          `}
        </Script>
      </body>
    </html>
  );
}
