import { Metadata } from "next";
import CrmHomePage from "../../clikklepages/crmHome";

export const metadata: Metadata = {
  title: "Clikkle CRM | Customer Relationship Management",
  description:
    "Streamline your customer relationships with Clikkle's powerful CRM software. Track leads, manage contacts, automate sales processes, and grow your business with our intuitive customer relationship management platform.",
  keywords:
    "CRM software, customer relationship management, sales automation, lead tracking, contact management, sales pipeline, customer management, business CRM",
  openGraph: {
    title: "Clikkle CRM | Customer Relationship Management",
    description:
      "Manage your customer relationships effectively with Clikkle's CRM. Track leads, automate sales, and grow your business.",
    url: "https://clikkle.com/crm",
    images: [
      {
        url: "https://cdn.clikkle.com/images/crm/2025/clikkle%20crm.png",
        width: 1200,
        height: 1200,
        alt: "Clikkle CRM Dashboard Interface",
      },
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Clikkle CRM | Customer Relationship Management",
    description:
      "Manage your customer relationships effectively with Clikkle's CRM platform.",
    images: ["https://cdn.clikkle.com/images/crm/2025/clikkle%20crm.png"],
  },
  alternates: {
    canonical: "https://clikkle.com/crm",
  },
  icons: {
    icon: "https://cdn.clikkle.com/images/crm/2025/clikkle%20crm.png",
    apple: "https://cdn.clikkle.com/images/crm/2025/clikkle%20crm.png",
  },
};

export default function CrmHome() {
  return <CrmHomePage />;
}