import { Metadata } from "next";
import CreatorAIHome from "@/clikklepages/creatorAi";

export const metadata: Metadata = {
  title: "Clikkle Creator AI | AI-Powered Content Creation Suite",
  description: "Transform your content creation with Clikkle Creator AI. Generate SEO-optimized articles, create stunning visuals, remove backgrounds, and produce professional content 10x faster with AI-powered tools.",
  keywords: "AI content creation, AI writing tool, AI image generator, background remover, content creator tools, AI article writer, text to image AI, content automation, AI content suite",
  openGraph: {
    title: "Clikkle Creator AI | AI-Powered Content Creation Suite",
    description: "Transform your content creation with AI. Generate articles, create visuals, remove backgrounds, and produce professional content 10x faster.",
    url: "https://clikkle.com/creator",
    siteName: "Clikkle",
    images: [
      {
        url: "https://cdn.clikkle.com/images/creator/logo/2025/Clikkle%20Creator.png",
        width: 1200,
        height: 1200,
        alt: "Clikkle Creator AI - AI-Powered Content Creation Suite",
      }
    ],
    locale: "en_US",
    type: "website",
  },
  twitter: {
    card: "summary_large_image",
    title: "Clikkle Creator AI | AI-Powered Content Creation Suite",
    description: "Transform your content creation with AI. Generate articles, create visuals, and produce professional content 10x faster.",
    images: ["https://cdn.clikkle.com/images/creator/logo/2025/Clikkle%20Creator.png"],
  },
  alternates: {
    canonical: "https://clikkle.com/creator",
  },
    icons: {
    icon: "https://cdn.clikkle.com/images/creator/logo/2025/Clikkle%20Creator.png",
    apple: "https://cdn.clikkle.com/images/creator/logo/2025/Clikkle%20Creator.png",
  },
};

export default function CreatorHome() {
 return <CreatorAIHome />;
}
