import { Metadata } from "next";
import BlogsHomeComponent from "../../clikklepages/blogsHome";

export const metadata: Metadata = {
  title: "Business Blog | Tips & Insights for Growing Your Business",
  description: "Explore Clikkle's business blog for expert tips, insights, and strategies on CRM, HR management, project management, and business growth. Stay updated with the latest business trends and best practices.",
  keywords: "business blog, business tips, CRM insights, HR management tips, project management advice, business growth, entrepreneurship, business strategy, business trends",
  openGraph: {
    title: "Business Blog | Tips & Insights for Growing Your Business",
    description: "Explore Clikkle's business blog for expert tips, insights, and strategies on CRM, HR management, and business growth.",
    url: "https://clikkle.com/blogs",
    images: [
      {
        url: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
        width: 1200,
        height: 1200,
        alt: "Clikkle Business Blog",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Business Blog | Tips & Insights for Growing Your Business",
    description: "Explore Clikkle's business blog for expert tips and business growth strategies.",
    images: ["https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png"],
  },
  alternates: {
    canonical: "https://clikkle.com/blogs",
  },
  icons: {
    icon: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
    apple: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
  },
};

export default function BlogsHome() {
  return <BlogsHomeComponent />;
}