import PartnersPage from "@/clikklepages/partnersPage";
import { Metadata } from "next";

export const metadata: Metadata = {
  title: "Affiliate Program | Earn with Clikkle Business Suite",
  description:
    "Join Clikkle's affiliate program and earn commissions by promoting our all-in-one business suite. Get marketing materials, tracking tools, and competitive commission rates for referring customers.",
  keywords:
    "affiliate program, business software affiliate, earn commissions, referral program, affiliate marketing, business suite affiliate, partner program, earn money online",
  openGraph: {
    title: "Affiliate Program | Earn with Clikkle Business Suite",
    description:
      "Join Clikkle's affiliate program and earn commissions by promoting our all-in-one business suite. Get marketing materials and tracking tools.",
    url: "https://clikkle.com/affiliate-program",
    images: [
      {
        url: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
        width: 1200,
        height: 1200,
        alt: "Clikkle Affiliate Program - Earn Commissions",
      },
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Affiliate Program | Earn with Clikkle Business Suite",
    description:
      "Join Clikkle's affiliate program and earn commissions by promoting our business suite.",
    images: ["https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png"],
  },
  alternates: {
    canonical: "https://clikkle.com/affiliate-program",
  },
  icons: {
    icon: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
    apple: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
  },
};

export default function AffiliateProgram() {
  return <PartnersPage />;
}
