import { Metadata } from "next";
import ComingSoon from "@/clikklepages/comingSoon";

export const metadata: Metadata = {
  title: "Clikkle Ads | Digital Advertising Management | Ad Campaign Software",
  description: "Optimize your digital advertising with Clikkle's ad management software. Create, manage, and track ad campaigns across multiple platforms. Monitor ROI, analyze performance, and maximize your advertising budget.",
  keywords: "digital advertising, ad management, advertising campaigns, ad campaign software, digital ads, advertising platform, ad tracking, advertising ROI, campaign optimization",
  openGraph: {
    title: "Clikkle Ads | Digital Advertising Management | Ad Campaign Software",
    description: "Optimize your digital advertising with Clikkle's ad management software. Create and manage ad campaigns across multiple platforms.",
    url: "https://clikkle.com/ads",
    images: [
      {
        url: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
        width: 1200,
        height: 1200,
        alt: "Clikkle Ad Management Dashboard",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Clikkle Ads | Digital Advertising Management | Ad Campaign Software",
    description: "Optimize your digital advertising with Clikkle's ad management platform.",
    images: ["https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png"],
  },
  alternates: {
    canonical: "https://clikkle.com/ads",
  },
  icons: {
    icon: "https://cdn.clikkle.com/images/ads/logo/2025/clikkle%20ads.png",
    apple: "https://cdn.clikkle.com/images/ads/logo/2025/clikkle%20ads.png",
  },
};

export default function AdsHome() {
      return (
        <ComingSoon/>
    )
}